/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.health.connect.ReadRecordsRequest;
import android.health.connect.TimeRangeFilter;
import android.health.connect.aidl.ReadRecordsRequestParcel;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Record;
import android.util.ArraySet;
import java.util.Objects;
import java.util.Set;

public class ReadRecordsRequestUsingFilters<T extends Record>
extends ReadRecordsRequest<T> {
    private final TimeRangeFilter mTimeRangeFilter;
    private final Set<DataOrigin> mDataOrigins;
    private final int mPageSize;
    private final long mPageToken;
    private final boolean mAscending;

    private ReadRecordsRequestUsingFilters(TimeRangeFilter timeRangeFilter, Class<T> recordType, Set<DataOrigin> dataOrigins, int pageSize, long pageToken, boolean ascending) {
        super(recordType);
        Objects.requireNonNull(dataOrigins);
        this.mTimeRangeFilter = timeRangeFilter;
        this.mDataOrigins = dataOrigins;
        this.mPageSize = pageSize;
        this.mAscending = pageToken != -1L ? pageToken % 2L == 0L : ascending;
        this.mPageToken = pageToken;
    }

    public TimeRangeFilter getTimeRangeFilter() {
        return this.mTimeRangeFilter;
    }

    public Set<DataOrigin> getDataOrigins() {
        return this.mDataOrigins;
    }

    public int getPageSize() {
        return this.mPageSize;
    }

    public long getPageToken() {
        return this.mPageToken;
    }

    public boolean isAscending() {
        return this.mAscending;
    }

    @Override
    public ReadRecordsRequestParcel toReadRecordsRequestParcel() {
        return new ReadRecordsRequestParcel(this);
    }

    public static class Builder<T extends Record> {
        private final Class<T> mRecordType;
        private final Set<DataOrigin> mDataOrigins = new ArraySet<DataOrigin>();
        private TimeRangeFilter mTimeRangeFilter;
        private int mPageSize = 1000;
        private long mPageToken = -1L;
        private boolean mAscending = true;
        private boolean mIsOrderingSet = false;

        public Builder(Class<T> recordType) {
            Objects.requireNonNull(recordType);
            this.mRecordType = recordType;
        }

        public Builder<T> addDataOrigins(DataOrigin dataOrigin) {
            Objects.requireNonNull(dataOrigin);
            this.mDataOrigins.add(dataOrigin);
            return this;
        }

        public Builder<T> setTimeRangeFilter(TimeRangeFilter timeRangeFilter) {
            this.mTimeRangeFilter = timeRangeFilter;
            return this;
        }

        public Builder<T> setPageSize(int pageSize) {
            if (pageSize > 5000) {
                throw new IllegalArgumentException("Maximum allowed pageSize is 5000, requested " + pageSize);
            }
            this.mPageSize = pageSize;
            return this;
        }

        public Builder<T> setPageToken(long pageToken) {
            this.mPageToken = pageToken;
            return this;
        }

        public Builder<T> setAscending(boolean ascending) {
            this.mAscending = ascending;
            this.mIsOrderingSet = true;
            return this;
        }

        public ReadRecordsRequestUsingFilters<T> build() {
            if (this.mPageToken != -1L && this.mIsOrderingSet) {
                throw new IllegalStateException("Cannot set both pageToken and sort order");
            }
            return new ReadRecordsRequestUsingFilters<T>(this.mTimeRangeFilter, this.mRecordType, this.mDataOrigins, this.mPageSize, this.mPageToken, this.mAscending);
        }
    }
}

