/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.annotation.SuppressLint;
import android.health.connect.ReadRecordsRequest;
import android.health.connect.RecordIdFilter;
import android.health.connect.aidl.ReadRecordsRequestParcel;
import android.health.connect.datatypes.Record;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ReadRecordsRequestUsingIds<T extends Record>
extends ReadRecordsRequest<T> {
    private final List<RecordIdFilter> mRecordIdFiltersList;

    private ReadRecordsRequestUsingIds(Class<T> recordType, List<RecordIdFilter> recordIdFiltersList) {
        super(recordType);
        Objects.requireNonNull(recordIdFiltersList);
        this.mRecordIdFiltersList = recordIdFiltersList;
    }

    public List<RecordIdFilter> getRecordIdFilters() {
        return this.mRecordIdFiltersList;
    }

    @Override
    public ReadRecordsRequestParcel toReadRecordsRequestParcel() {
        return new ReadRecordsRequestParcel(this);
    }

    public static class Builder<T extends Record> {
        private final Class<T> mRecordType;
        private final List<RecordIdFilter> mRecordIdFiltersList = new ArrayList<RecordIdFilter>();

        public Builder(Class<T> recordType) {
            Objects.requireNonNull(recordType);
            this.mRecordType = recordType;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder<T> addId(String id2) {
            this.mRecordIdFiltersList.add(RecordIdFilter.fromId(this.mRecordType, id2));
            return this;
        }

        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        public Builder<T> addClientRecordId(String clientRecordId) {
            this.mRecordIdFiltersList.add(RecordIdFilter.fromClientRecordId(this.mRecordType, clientRecordId));
            return this;
        }

        public ReadRecordsRequestUsingIds<T> build() {
            if (this.mRecordIdFiltersList.isEmpty()) {
                throw new IllegalArgumentException("RecordIdFilter list is empty, Either record id or client record id must be set");
            }
            return new ReadRecordsRequestUsingIds<T>(this.mRecordType, this.mRecordIdFiltersList);
        }
    }
}

