/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.health.connect.TimeRangeFilter;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class TimeInstantRangeFilter
implements TimeRangeFilter {
    private final Instant mStartTime;
    private final Instant mEndTime;

    private TimeInstantRangeFilter(Instant startTime, Instant endTime) {
        if (startTime == null && endTime == null) {
            throw new IllegalArgumentException("Both start time and end time cannot be null.");
        }
        if (startTime != null && endTime != null && !endTime.isAfter(startTime)) {
            throw new IllegalArgumentException("end time needs to be after start time.");
        }
        this.mStartTime = startTime != null ? startTime : Instant.EPOCH;
        this.mEndTime = endTime != null ? endTime : Instant.now().plus(1L, ChronoUnit.DAYS);
    }

    public Instant getStartTime() {
        return this.mStartTime;
    }

    public Instant getEndTime() {
        return this.mEndTime;
    }

    public boolean isBounded() {
        return this.mStartTime != null && this.mEndTime != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!this.mStartTime.equals(((TimeInstantRangeFilter)o).mStartTime)) {
            return false;
        }
        return this.mEndTime.equals(((TimeInstantRangeFilter)o).mEndTime);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.mStartTime == null ? 0 : this.mStartTime.hashCode());
        result = 31 * result + (this.mEndTime == null ? 0 : this.mEndTime.hashCode());
        return result;
    }

    public static class Builder {
        private Instant mStartTime;
        private Instant mEndTime;

        public Builder setStartTime(Instant startTime) {
            this.mStartTime = startTime;
            return this;
        }

        public Builder setEndTime(Instant endTime) {
            this.mEndTime = endTime;
            return this;
        }

        public TimeInstantRangeFilter build() {
            return new TimeInstantRangeFilter(this.mStartTime, this.mEndTime);
        }
    }
}

