/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect;

import android.health.connect.LocalTimeRangeFilter;
import android.health.connect.TimeInstantRangeFilter;
import android.health.connect.TimeRangeFilter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

public class TimeRangeFilterHelper {
    private static final ZoneOffset LOCAL_TIME_ZERO_OFFSET = ZoneOffset.UTC;

    public static boolean isLocalTimeFilter(TimeRangeFilter timeRangeFilter) {
        return timeRangeFilter instanceof LocalTimeRangeFilter;
    }

    public static long getFilterStartTimeMillis(TimeRangeFilter timeRangeFilter) {
        if (TimeRangeFilterHelper.isLocalTimeFilter(timeRangeFilter)) {
            return TimeRangeFilterHelper.getMillisOfLocalTime(((LocalTimeRangeFilter)timeRangeFilter).getStartTime());
        }
        if (timeRangeFilter instanceof TimeInstantRangeFilter) {
            return ((TimeInstantRangeFilter)timeRangeFilter).getStartTime().toEpochMilli();
        }
        throw new IllegalArgumentException("Invalid time filter object. Object should be either TimeInstantRangeFilter or LocalTimeRangeFilter.");
    }

    public static long getFilterEndTimeMillis(TimeRangeFilter timeRangeFilter) {
        if (TimeRangeFilterHelper.isLocalTimeFilter(timeRangeFilter)) {
            return TimeRangeFilterHelper.getMillisOfLocalTime(((LocalTimeRangeFilter)timeRangeFilter).getEndTime());
        }
        if (timeRangeFilter instanceof TimeInstantRangeFilter) {
            return ((TimeInstantRangeFilter)timeRangeFilter).getEndTime().toEpochMilli();
        }
        throw new IllegalArgumentException("Invalid time filter object. Object should be either TimeInstantRangeFilter or LocalTimeRangeFilter.");
    }

    public static LocalDateTime getLocalTimeFromMillis(Long localDateTimeMillis) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(localDateTimeMillis), LOCAL_TIME_ZERO_OFFSET);
    }

    public static long getMillisOfLocalTime(LocalDateTime time) {
        return time.toInstant(LOCAL_TIME_ZERO_OFFSET).toEpochMilli();
    }
}

