/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.accesslog;

import android.annotation.SystemApi;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.utils.RecordMapper;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@SystemApi
public class AccessLog
implements Parcelable {
    private final List<Class<? extends Record>> mRecordTypesList = new ArrayList<Class<? extends Record>>();
    private final String mPackageName;
    private final Instant mAccessTime;
    private final int mOperationType;
    public static final Parcelable.Creator<AccessLog> CREATOR = new Parcelable.Creator<AccessLog>(){

        @Override
        public AccessLog createFromParcel(Parcel in) {
            return new AccessLog(in);
        }

        public AccessLog[] newArray(int size) {
            return new AccessLog[size];
        }
    };

    public AccessLog(String packageName, List<Integer> recordTypes, long accessTimeInMillis, int operationType) {
        Objects.requireNonNull(packageName);
        Objects.requireNonNull(recordTypes);
        this.mPackageName = packageName;
        RecordMapper recordMapper = RecordMapper.getInstance();
        for (int recordType : recordTypes) {
            this.mRecordTypesList.add(recordMapper.getRecordIdToExternalRecordClassMap().get(recordType));
        }
        this.mAccessTime = Instant.ofEpochMilli(accessTimeInMillis);
        this.mOperationType = operationType;
    }

    private AccessLog(Parcel in) {
        RecordMapper recordMapper = RecordMapper.getInstance();
        for (int recordType : in.createIntArray()) {
            this.mRecordTypesList.add(recordMapper.getRecordIdToExternalRecordClassMap().get(recordType));
        }
        this.mPackageName = in.readString();
        this.mAccessTime = Instant.ofEpochMilli(in.readLong());
        this.mOperationType = in.readInt();
    }

    public List<Class<? extends Record>> getRecordTypes() {
        return this.mRecordTypesList;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public Instant getAccessTime() {
        return this.mAccessTime;
    }

    public int getOperationType() {
        return this.mOperationType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int recordTypeCount = this.mRecordTypesList.size();
        RecordMapper recordMapper = RecordMapper.getInstance();
        int[] recordTypes = new int[recordTypeCount];
        for (int i = 0; i < recordTypeCount; ++i) {
            recordTypes[i] = recordMapper.getRecordType(this.mRecordTypesList.get(i));
        }
        dest.writeIntArray(recordTypes);
        dest.writeString(this.mPackageName);
        dest.writeLong(this.mAccessTime.toEpochMilli());
        dest.writeInt(this.mOperationType);
    }

    public static class OperationType {
        public static final int OPERATION_TYPE_READ = 2;
        public static final int OPERATION_TYPE_UPSERT = 0;
        public static final int OPERATION_TYPE_DELETE = 1;

        private OperationType() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface OperationTypes {
        }
    }
}

