/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.os.Parcel;
import android.os.Parcelable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ActivityDatesResponseParcel
implements Parcelable {
    private final List<LocalDate> mLocalDates;
    public static final Parcelable.Creator<ActivityDatesResponseParcel> CREATOR = new Parcelable.Creator<ActivityDatesResponseParcel>(){

        @Override
        public ActivityDatesResponseParcel createFromParcel(Parcel in) {
            return new ActivityDatesResponseParcel(in);
        }

        public ActivityDatesResponseParcel[] newArray(int size) {
            return new ActivityDatesResponseParcel[size];
        }
    };

    public ActivityDatesResponseParcel(List<LocalDate> localDates) {
        Objects.requireNonNull(localDates);
        this.mLocalDates = localDates;
    }

    protected ActivityDatesResponseParcel(Parcel in) {
        int size = in.readInt();
        this.mLocalDates = new ArrayList<LocalDate>(size);
        for (int i = 0; i < size; ++i) {
            String date = in.readString();
            this.mLocalDates.add(LocalDate.parse(date));
        }
    }

    public List<LocalDate> getDates() {
        return this.mLocalDates;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mLocalDates.size());
        this.mLocalDates.forEach(localDate -> dest.writeString(localDate.format(DateTimeFormatter.ISO_LOCAL_DATE)));
    }
}

