/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.content.AttributionSource;
import android.health.connect.aidl.ActivityDatesRequestParcel;
import android.health.connect.aidl.AggregateDataRequestParcel;
import android.health.connect.aidl.DeleteUsingFiltersRequestParcel;
import android.health.connect.aidl.IAccessLogsResponseCallback;
import android.health.connect.aidl.IActivityDatesResponseCallback;
import android.health.connect.aidl.IAggregateRecordsResponseCallback;
import android.health.connect.aidl.IApplicationInfoResponseCallback;
import android.health.connect.aidl.IChangeLogsResponseCallback;
import android.health.connect.aidl.IDataStagingFinishedCallback;
import android.health.connect.aidl.IEmptyResponseCallback;
import android.health.connect.aidl.IGetChangeLogTokenCallback;
import android.health.connect.aidl.IGetHealthConnectDataStateCallback;
import android.health.connect.aidl.IGetHealthConnectMigrationUiStateCallback;
import android.health.connect.aidl.IGetPriorityResponseCallback;
import android.health.connect.aidl.IInsertRecordsResponseCallback;
import android.health.connect.aidl.IMigrationCallback;
import android.health.connect.aidl.IReadRecordsResponseCallback;
import android.health.connect.aidl.IRecordTypeInfoResponseCallback;
import android.health.connect.aidl.ReadRecordsRequestParcel;
import android.health.connect.aidl.RecordsParcel;
import android.health.connect.aidl.UpdatePriorityRequestParcel;
import android.health.connect.changelog.ChangeLogTokenRequest;
import android.health.connect.changelog.ChangeLogsRequest;
import android.health.connect.migration.MigrationEntityParcel;
import android.health.connect.restore.BackupFileNamesSet;
import android.health.connect.restore.StageRemoteDataRequest;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.UserHandle;
import java.util.ArrayList;
import java.util.List;

public interface IHealthConnectService
extends IInterface {
    public static final String DESCRIPTOR = "android.health.connect.aidl.IHealthConnectService";

    public void grantHealthPermission(String var1, String var2, UserHandle var3) throws RemoteException;

    public void revokeHealthPermission(String var1, String var2, String var3, UserHandle var4) throws RemoteException;

    public void revokeAllHealthPermissions(String var1, String var2, UserHandle var3) throws RemoteException;

    public List<String> getGrantedHealthPermissions(String var1, UserHandle var2) throws RemoteException;

    public long getHistoricalAccessStartDateInMilliseconds(String var1, UserHandle var2) throws RemoteException;

    public void insertRecords(AttributionSource var1, RecordsParcel var2, IInsertRecordsResponseCallback var3) throws RemoteException;

    public void aggregateRecords(AttributionSource var1, AggregateDataRequestParcel var2, IAggregateRecordsResponseCallback var3) throws RemoteException;

    public void readRecords(AttributionSource var1, ReadRecordsRequestParcel var2, IReadRecordsResponseCallback var3) throws RemoteException;

    public void updateRecords(AttributionSource var1, RecordsParcel var2, IEmptyResponseCallback var3) throws RemoteException;

    public void getChangeLogToken(AttributionSource var1, ChangeLogTokenRequest var2, IGetChangeLogTokenCallback var3) throws RemoteException;

    public void getChangeLogs(AttributionSource var1, ChangeLogsRequest var2, IChangeLogsResponseCallback var3) throws RemoteException;

    public void deleteUsingFilters(AttributionSource var1, DeleteUsingFiltersRequestParcel var2, IEmptyResponseCallback var3) throws RemoteException;

    public void deleteUsingFiltersForSelf(AttributionSource var1, DeleteUsingFiltersRequestParcel var2, IEmptyResponseCallback var3) throws RemoteException;

    public void getCurrentPriority(String var1, int var2, IGetPriorityResponseCallback var3) throws RemoteException;

    public void updatePriority(String var1, UpdatePriorityRequestParcel var2, IEmptyResponseCallback var3) throws RemoteException;

    public void setRecordRetentionPeriodInDays(int var1, UserHandle var2, IEmptyResponseCallback var3) throws RemoteException;

    public int getRecordRetentionPeriodInDays(UserHandle var1) throws RemoteException;

    public void getContributorApplicationsInfo(IApplicationInfoResponseCallback var1) throws RemoteException;

    public void queryAllRecordTypesInfo(IRecordTypeInfoResponseCallback var1) throws RemoteException;

    public void queryAccessLogs(String var1, IAccessLogsResponseCallback var2) throws RemoteException;

    public void getActivityDates(ActivityDatesRequestParcel var1, IActivityDatesResponseCallback var2) throws RemoteException;

    public void startMigration(String var1, IMigrationCallback var2) throws RemoteException;

    public void finishMigration(String var1, IMigrationCallback var2) throws RemoteException;

    public void writeMigrationData(String var1, MigrationEntityParcel var2, IMigrationCallback var3) throws RemoteException;

    public void insertMinDataMigrationSdkExtensionVersion(String var1, int var2, IMigrationCallback var3) throws RemoteException;

    public void stageAllHealthConnectRemoteData(StageRemoteDataRequest var1, UserHandle var2, IDataStagingFinishedCallback var3) throws RemoteException;

    public void getAllDataForBackup(StageRemoteDataRequest var1, UserHandle var2) throws RemoteException;

    public BackupFileNamesSet getAllBackupFileNames(boolean var1) throws RemoteException;

    public void deleteAllStagedRemoteData(UserHandle var1) throws RemoteException;

    public void updateDataDownloadState(int var1) throws RemoteException;

    public void getHealthConnectDataState(IGetHealthConnectDataStateCallback var1) throws RemoteException;

    public void getHealthConnectMigrationUiState(IGetHealthConnectMigrationUiStateCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IHealthConnectService {
        static final int TRANSACTION_grantHealthPermission = 1;
        static final int TRANSACTION_revokeHealthPermission = 2;
        static final int TRANSACTION_revokeAllHealthPermissions = 3;
        static final int TRANSACTION_getGrantedHealthPermissions = 4;
        static final int TRANSACTION_getHistoricalAccessStartDateInMilliseconds = 5;
        static final int TRANSACTION_insertRecords = 6;
        static final int TRANSACTION_aggregateRecords = 7;
        static final int TRANSACTION_readRecords = 8;
        static final int TRANSACTION_updateRecords = 9;
        static final int TRANSACTION_getChangeLogToken = 10;
        static final int TRANSACTION_getChangeLogs = 11;
        static final int TRANSACTION_deleteUsingFilters = 12;
        static final int TRANSACTION_deleteUsingFiltersForSelf = 13;
        static final int TRANSACTION_getCurrentPriority = 14;
        static final int TRANSACTION_updatePriority = 15;
        static final int TRANSACTION_setRecordRetentionPeriodInDays = 16;
        static final int TRANSACTION_getRecordRetentionPeriodInDays = 17;
        static final int TRANSACTION_getContributorApplicationsInfo = 18;
        static final int TRANSACTION_queryAllRecordTypesInfo = 19;
        static final int TRANSACTION_queryAccessLogs = 20;
        static final int TRANSACTION_getActivityDates = 21;
        static final int TRANSACTION_startMigration = 22;
        static final int TRANSACTION_finishMigration = 23;
        static final int TRANSACTION_writeMigrationData = 24;
        static final int TRANSACTION_insertMinDataMigrationSdkExtensionVersion = 25;
        static final int TRANSACTION_stageAllHealthConnectRemoteData = 26;
        static final int TRANSACTION_getAllDataForBackup = 27;
        static final int TRANSACTION_getAllBackupFileNames = 28;
        static final int TRANSACTION_deleteAllStagedRemoteData = 29;
        static final int TRANSACTION_updateDataDownloadState = 30;
        static final int TRANSACTION_getHealthConnectDataState = 31;
        static final int TRANSACTION_getHealthConnectMigrationUiState = 32;

        public Stub() {
            this.attachInterface(this, IHealthConnectService.DESCRIPTOR);
        }

        public static IHealthConnectService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IHealthConnectService.DESCRIPTOR);
            if (iin != null && iin instanceof IHealthConnectService) {
                return (IHealthConnectService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "grantHealthPermission";
                }
                case 2: {
                    return "revokeHealthPermission";
                }
                case 3: {
                    return "revokeAllHealthPermissions";
                }
                case 4: {
                    return "getGrantedHealthPermissions";
                }
                case 5: {
                    return "getHistoricalAccessStartDateInMilliseconds";
                }
                case 6: {
                    return "insertRecords";
                }
                case 7: {
                    return "aggregateRecords";
                }
                case 8: {
                    return "readRecords";
                }
                case 9: {
                    return "updateRecords";
                }
                case 10: {
                    return "getChangeLogToken";
                }
                case 11: {
                    return "getChangeLogs";
                }
                case 12: {
                    return "deleteUsingFilters";
                }
                case 13: {
                    return "deleteUsingFiltersForSelf";
                }
                case 14: {
                    return "getCurrentPriority";
                }
                case 15: {
                    return "updatePriority";
                }
                case 16: {
                    return "setRecordRetentionPeriodInDays";
                }
                case 17: {
                    return "getRecordRetentionPeriodInDays";
                }
                case 18: {
                    return "getContributorApplicationsInfo";
                }
                case 19: {
                    return "queryAllRecordTypesInfo";
                }
                case 20: {
                    return "queryAccessLogs";
                }
                case 21: {
                    return "getActivityDates";
                }
                case 22: {
                    return "startMigration";
                }
                case 23: {
                    return "finishMigration";
                }
                case 24: {
                    return "writeMigrationData";
                }
                case 25: {
                    return "insertMinDataMigrationSdkExtensionVersion";
                }
                case 26: {
                    return "stageAllHealthConnectRemoteData";
                }
                case 27: {
                    return "getAllDataForBackup";
                }
                case 28: {
                    return "getAllBackupFileNames";
                }
                case 29: {
                    return "deleteAllStagedRemoteData";
                }
                case 30: {
                    return "updateDataDownloadState";
                }
                case 31: {
                    return "getHealthConnectDataState";
                }
                case 32: {
                    return "getHealthConnectMigrationUiState";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IHealthConnectService.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.grantHealthPermission(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 2: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    UserHandle _arg3 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.revokeHealthPermission(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    UserHandle _arg2 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.revokeAllHealthPermissions(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 4: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    List<String> _result = this.getGrantedHealthPermissions(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    break;
                }
                case 5: {
                    String _arg0 = data.readString();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    long _result = this.getHistoricalAccessStartDateInMilliseconds(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeLong(_result);
                    break;
                }
                case 6: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    RecordsParcel _arg1 = data.readTypedObject(RecordsParcel.CREATOR);
                    IInsertRecordsResponseCallback _arg2 = IInsertRecordsResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.insertRecords(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 7: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    AggregateDataRequestParcel _arg1 = data.readTypedObject(AggregateDataRequestParcel.CREATOR);
                    IAggregateRecordsResponseCallback _arg2 = IAggregateRecordsResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.aggregateRecords(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 8: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    ReadRecordsRequestParcel _arg1 = data.readTypedObject(ReadRecordsRequestParcel.CREATOR);
                    IReadRecordsResponseCallback _arg2 = IReadRecordsResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.readRecords(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 9: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    RecordsParcel _arg1 = data.readTypedObject(RecordsParcel.CREATOR);
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.updateRecords(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 10: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    ChangeLogTokenRequest _arg1 = data.readTypedObject(ChangeLogTokenRequest.CREATOR);
                    IGetChangeLogTokenCallback _arg2 = IGetChangeLogTokenCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getChangeLogToken(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 11: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    ChangeLogsRequest _arg1 = data.readTypedObject(ChangeLogsRequest.CREATOR);
                    IChangeLogsResponseCallback _arg2 = IChangeLogsResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getChangeLogs(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 12: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    DeleteUsingFiltersRequestParcel _arg1 = data.readTypedObject(DeleteUsingFiltersRequestParcel.CREATOR);
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.deleteUsingFilters(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 13: {
                    AttributionSource _arg0 = data.readTypedObject(AttributionSource.CREATOR);
                    DeleteUsingFiltersRequestParcel _arg1 = data.readTypedObject(DeleteUsingFiltersRequestParcel.CREATOR);
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.deleteUsingFiltersForSelf(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 14: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    IGetPriorityResponseCallback _arg2 = IGetPriorityResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getCurrentPriority(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 15: {
                    String _arg0 = data.readString();
                    UpdatePriorityRequestParcel _arg1 = data.readTypedObject(UpdatePriorityRequestParcel.CREATOR);
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.updatePriority(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 16: {
                    int _arg0 = data.readInt();
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    IEmptyResponseCallback _arg2 = IEmptyResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.setRecordRetentionPeriodInDays(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 17: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    int _result = this.getRecordRetentionPeriodInDays(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    break;
                }
                case 18: {
                    IApplicationInfoResponseCallback _arg0 = IApplicationInfoResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getContributorApplicationsInfo(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 19: {
                    IRecordTypeInfoResponseCallback _arg0 = IRecordTypeInfoResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.queryAllRecordTypesInfo(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 20: {
                    String _arg0 = data.readString();
                    IAccessLogsResponseCallback _arg1 = IAccessLogsResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.queryAccessLogs(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 21: {
                    ActivityDatesRequestParcel _arg0 = data.readTypedObject(ActivityDatesRequestParcel.CREATOR);
                    IActivityDatesResponseCallback _arg1 = IActivityDatesResponseCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getActivityDates(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 22: {
                    String _arg0 = data.readString();
                    IMigrationCallback _arg1 = IMigrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.startMigration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 23: {
                    String _arg0 = data.readString();
                    IMigrationCallback _arg1 = IMigrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.finishMigration(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 24: {
                    String _arg0 = data.readString();
                    MigrationEntityParcel _arg1 = data.readTypedObject(MigrationEntityParcel.CREATOR);
                    IMigrationCallback _arg2 = IMigrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.writeMigrationData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 25: {
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    IMigrationCallback _arg2 = IMigrationCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.insertMinDataMigrationSdkExtensionVersion(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 26: {
                    StageRemoteDataRequest _arg0 = data.readTypedObject(StageRemoteDataRequest.CREATOR);
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    IDataStagingFinishedCallback _arg2 = IDataStagingFinishedCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.stageAllHealthConnectRemoteData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    break;
                }
                case 27: {
                    StageRemoteDataRequest _arg0 = data.readTypedObject(StageRemoteDataRequest.CREATOR);
                    UserHandle _arg1 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.getAllDataForBackup(_arg0, _arg1);
                    reply.writeNoException();
                    break;
                }
                case 28: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    BackupFileNamesSet _result = this.getAllBackupFileNames(_arg0);
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 29: {
                    UserHandle _arg0 = data.readTypedObject(UserHandle.CREATOR);
                    data.enforceNoDataAvail();
                    this.deleteAllStagedRemoteData(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 30: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.updateDataDownloadState(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 31: {
                    IGetHealthConnectDataStateCallback _arg0 = IGetHealthConnectDataStateCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getHealthConnectDataState(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 32: {
                    IGetHealthConnectMigrationUiStateCallback _arg0 = IGetHealthConnectMigrationUiStateCallback.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.getHealthConnectMigrationUiState(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 31;
        }

        private static class Proxy
        implements IHealthConnectService {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IHealthConnectService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void grantHealthPermission(String packageName, String permissionName, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(permissionName);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeHealthPermission(String packageName, String permissionName, String reason, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(permissionName);
                    _data.writeString(reason);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void revokeAllHealthPermissions(String packageName, String reason, UserHandle user) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(reason);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getGrantedHealthPermissions(String packageName, UserHandle user) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getHistoricalAccessStartDateInMilliseconds(String packageName, UserHandle user) throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(user, 0);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insertRecords(AttributionSource attributionSource, RecordsParcel recordsParcel, IInsertRecordsResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(recordsParcel, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void aggregateRecords(AttributionSource attributionSource, AggregateDataRequestParcel request, IAggregateRecordsResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readRecords(AttributionSource attributionSource, ReadRecordsRequestParcel request, IReadRecordsResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateRecords(AttributionSource attributionSource, RecordsParcel recordsParcel, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(recordsParcel, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getChangeLogToken(AttributionSource attributionSource, ChangeLogTokenRequest request, IGetChangeLogTokenCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getChangeLogs(AttributionSource attributionSource, ChangeLogsRequest token, IChangeLogsResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(token, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteUsingFilters(AttributionSource attributionSource, DeleteUsingFiltersRequestParcel request, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteUsingFiltersForSelf(AttributionSource attributionSource, DeleteUsingFiltersRequestParcel request, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(attributionSource, 0);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getCurrentPriority(String packageName, int permissionCategory, IGetPriorityResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(permissionCategory);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePriority(String packageName, UpdatePriorityRequestParcel request, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(request, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRecordRetentionPeriodInDays(int days, UserHandle userHandle, IEmptyResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeInt(days);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getRecordRetentionPeriodInDays(UserHandle userHandle) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getContributorApplicationsInfo(IApplicationInfoResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryAllRecordTypesInfo(IRecordTypeInfoResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryAccessLogs(String packageName, IAccessLogsResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getActivityDates(ActivityDatesRequestParcel recordTypes, IActivityDatesResponseCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(recordTypes, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startMigration(String packageName, IMigrationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finishMigration(String packageName, IMigrationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeMigrationData(String packageName, MigrationEntityParcel parcel, IMigrationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeTypedObject(parcel, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void insertMinDataMigrationSdkExtensionVersion(String packageName, int requiredSdkExtension, IMigrationCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(requiredSdkExtension);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stageAllHealthConnectRemoteData(StageRemoteDataRequest stageRemoteDataRequest, UserHandle userHandle, IDataStagingFinishedCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(stageRemoteDataRequest, 0);
                    _data.writeTypedObject(userHandle, 0);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getAllDataForBackup(StageRemoteDataRequest stageRemoteDataRequest, UserHandle userHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(stageRemoteDataRequest, 0);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public BackupFileNamesSet getAllBackupFileNames(boolean forDeviceToDevice) throws RemoteException {
                BackupFileNamesSet _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeBoolean(forDeviceToDevice);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(BackupFileNamesSet.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deleteAllStagedRemoteData(UserHandle userHandle) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeTypedObject(userHandle, 0);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateDataDownloadState(int downloadState) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeInt(downloadState);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getHealthConnectDataState(IGetHealthConnectDataStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getHealthConnectMigrationUiState(IGetHealthConnectMigrationUiStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IHealthConnectService.DESCRIPTOR);
                    _data.writeStrongInterface(callback);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IHealthConnectService {
        @Override
        public void grantHealthPermission(String packageName, String permissionName, UserHandle user) throws RemoteException {
        }

        @Override
        public void revokeHealthPermission(String packageName, String permissionName, String reason, UserHandle user) throws RemoteException {
        }

        @Override
        public void revokeAllHealthPermissions(String packageName, String reason, UserHandle user) throws RemoteException {
        }

        @Override
        public List<String> getGrantedHealthPermissions(String packageName, UserHandle user) throws RemoteException {
            return null;
        }

        @Override
        public long getHistoricalAccessStartDateInMilliseconds(String packageName, UserHandle user) throws RemoteException {
            return 0L;
        }

        @Override
        public void insertRecords(AttributionSource attributionSource, RecordsParcel recordsParcel, IInsertRecordsResponseCallback callback) throws RemoteException {
        }

        @Override
        public void aggregateRecords(AttributionSource attributionSource, AggregateDataRequestParcel request, IAggregateRecordsResponseCallback callback) throws RemoteException {
        }

        @Override
        public void readRecords(AttributionSource attributionSource, ReadRecordsRequestParcel request, IReadRecordsResponseCallback callback) throws RemoteException {
        }

        @Override
        public void updateRecords(AttributionSource attributionSource, RecordsParcel recordsParcel, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void getChangeLogToken(AttributionSource attributionSource, ChangeLogTokenRequest request, IGetChangeLogTokenCallback callback) throws RemoteException {
        }

        @Override
        public void getChangeLogs(AttributionSource attributionSource, ChangeLogsRequest token, IChangeLogsResponseCallback callback) throws RemoteException {
        }

        @Override
        public void deleteUsingFilters(AttributionSource attributionSource, DeleteUsingFiltersRequestParcel request, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void deleteUsingFiltersForSelf(AttributionSource attributionSource, DeleteUsingFiltersRequestParcel request, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void getCurrentPriority(String packageName, int permissionCategory, IGetPriorityResponseCallback callback) throws RemoteException {
        }

        @Override
        public void updatePriority(String packageName, UpdatePriorityRequestParcel request, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public void setRecordRetentionPeriodInDays(int days, UserHandle userHandle, IEmptyResponseCallback callback) throws RemoteException {
        }

        @Override
        public int getRecordRetentionPeriodInDays(UserHandle userHandle) throws RemoteException {
            return 0;
        }

        @Override
        public void getContributorApplicationsInfo(IApplicationInfoResponseCallback callback) throws RemoteException {
        }

        @Override
        public void queryAllRecordTypesInfo(IRecordTypeInfoResponseCallback callback) throws RemoteException {
        }

        @Override
        public void queryAccessLogs(String packageName, IAccessLogsResponseCallback callback) throws RemoteException {
        }

        @Override
        public void getActivityDates(ActivityDatesRequestParcel recordTypes, IActivityDatesResponseCallback callback) throws RemoteException {
        }

        @Override
        public void startMigration(String packageName, IMigrationCallback callback) throws RemoteException {
        }

        @Override
        public void finishMigration(String packageName, IMigrationCallback callback) throws RemoteException {
        }

        @Override
        public void writeMigrationData(String packageName, MigrationEntityParcel parcel, IMigrationCallback callback) throws RemoteException {
        }

        @Override
        public void insertMinDataMigrationSdkExtensionVersion(String packageName, int requiredSdkExtension, IMigrationCallback callback) throws RemoteException {
        }

        @Override
        public void stageAllHealthConnectRemoteData(StageRemoteDataRequest stageRemoteDataRequest, UserHandle userHandle, IDataStagingFinishedCallback callback) throws RemoteException {
        }

        @Override
        public void getAllDataForBackup(StageRemoteDataRequest stageRemoteDataRequest, UserHandle userHandle) throws RemoteException {
        }

        @Override
        public BackupFileNamesSet getAllBackupFileNames(boolean forDeviceToDevice) throws RemoteException {
            return null;
        }

        @Override
        public void deleteAllStagedRemoteData(UserHandle userHandle) throws RemoteException {
        }

        @Override
        public void updateDataDownloadState(int downloadState) throws RemoteException {
        }

        @Override
        public void getHealthConnectDataState(IGetHealthConnectDataStateCallback callback) throws RemoteException {
        }

        @Override
        public void getHealthConnectMigrationUiState(IGetHealthConnectMigrationUiStateCallback callback) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

