/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.health.connect.RecordIdFilter;
import android.health.connect.internal.datatypes.utils.RecordMapper;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.List;

public class RecordIdFiltersParcel
implements Parcelable {
    public static final Parcelable.Creator<RecordIdFiltersParcel> CREATOR = new Parcelable.Creator<RecordIdFiltersParcel>(){

        @Override
        public RecordIdFiltersParcel createFromParcel(Parcel in) {
            return new RecordIdFiltersParcel(in);
        }

        public RecordIdFiltersParcel[] newArray(int size) {
            return new RecordIdFiltersParcel[size];
        }
    };
    private final List<RecordIdFilter> mRecordIdFilters;

    public RecordIdFiltersParcel(List<RecordIdFilter> recordIdFilters) {
        this.mRecordIdFilters = recordIdFilters;
    }

    private RecordIdFiltersParcel(Parcel in) {
        int size = in.readInt();
        this.mRecordIdFilters = new ArrayList<RecordIdFilter>(size);
        for (int i = 0; i < size; ++i) {
            String id2 = in.readString();
            String clientRecordId = in.readString();
            if (id2 != null) {
                this.mRecordIdFilters.add(RecordIdFilter.fromId(RecordMapper.getInstance().getRecordIdToExternalRecordClassMap().get(in.readInt()), id2));
                continue;
            }
            this.mRecordIdFilters.add(RecordIdFilter.fromClientRecordId(RecordMapper.getInstance().getRecordIdToExternalRecordClassMap().get(in.readInt()), clientRecordId));
        }
    }

    public List<RecordIdFilter> getRecordIdFilters() {
        return this.mRecordIdFilters;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRecordIdFilters.size());
        this.mRecordIdFilters.forEach(recordId -> {
            dest.writeString(recordId.getId());
            dest.writeString(recordId.getClientRecordId());
            dest.writeInt(RecordMapper.getInstance().getRecordType(recordId.getRecordType()));
        });
    }
}

