/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.aidl;

import android.health.connect.RecordTypeInfoResponse;
import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.utils.RecordMapper;
import android.health.connect.internal.datatypes.utils.RecordTypePermissionCategoryMapper;
import android.health.connect.internal.datatypes.utils.RecordTypeRecordCategoryMapper;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RecordTypeInfoResponseParcel
implements Parcelable {
    public static final Parcelable.Creator<RecordTypeInfoResponseParcel> CREATOR = new Parcelable.Creator<RecordTypeInfoResponseParcel>(){

        @Override
        public RecordTypeInfoResponseParcel createFromParcel(Parcel in) {
            return new RecordTypeInfoResponseParcel(in);
        }

        public RecordTypeInfoResponseParcel[] newArray(int size) {
            return new RecordTypeInfoResponseParcel[size];
        }
    };
    private Map<Integer, List<String>> mRecordTypeInfoResponses;

    public RecordTypeInfoResponseParcel(Parcel in) {
        int numberOfResponses = in.readInt();
        this.mRecordTypeInfoResponses = new HashMap<Integer, List<String>>(numberOfResponses);
        for (int i = 0; i < numberOfResponses; ++i) {
            Integer recordType = in.readInt();
            ArrayList<String> contributingPackages = in.createStringArrayList();
            this.mRecordTypeInfoResponses.put(recordType, contributingPackages);
        }
    }

    public RecordTypeInfoResponseParcel(Map<Integer, List<DataOrigin>> recordTypeInfoResponses) {
        Objects.requireNonNull(recordTypeInfoResponses);
        this.mRecordTypeInfoResponses = new HashMap<Integer, List<String>>(recordTypeInfoResponses.size());
        recordTypeInfoResponses.forEach((recordType, contributingPackages) -> this.mRecordTypeInfoResponses.put((Integer)recordType, RecordTypeInfoResponseParcel.getContributingPackagesAsListOfString(contributingPackages)));
    }

    public static List<String> getContributingPackagesAsListOfString(List<DataOrigin> contributingPackagesAsDataOrigin) {
        return contributingPackagesAsDataOrigin.stream().map(DataOrigin::getPackageName).filter(packageName -> packageName != null && !packageName.isEmpty()).collect(Collectors.toList());
    }

    public static List<DataOrigin> getContributingPackagesAsDataOrigin(List<String> packagesAsListOfString) {
        return packagesAsListOfString.stream().map(packageName -> new DataOrigin.Builder().setPackageName((String)packageName).build()).collect(Collectors.toList());
    }

    public Map<Class<? extends Record>, RecordTypeInfoResponse> getRecordTypeInfoResponses() {
        HashMap<Class<? extends Record>, RecordTypeInfoResponse> responses = new HashMap<Class<? extends Record>, RecordTypeInfoResponse>(this.mRecordTypeInfoResponses.size());
        this.mRecordTypeInfoResponses.forEach((recordType, contributingPackages) -> {
            RecordTypeInfoResponse res = new RecordTypeInfoResponse(RecordTypePermissionCategoryMapper.getHealthPermissionCategoryForRecordType(recordType), RecordTypeRecordCategoryMapper.getRecordCategoryForRecordType(recordType), RecordTypeInfoResponseParcel.getContributingPackagesAsDataOrigin(contributingPackages));
            Class<? extends Record> recordTypeClass = RecordMapper.getInstance().getRecordIdToExternalRecordClassMap().get(recordType);
            responses.put(recordTypeClass, res);
        });
        return responses;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mRecordTypeInfoResponses.size());
        this.mRecordTypeInfoResponses.forEach((recordType, contributingPackages) -> {
            dest.writeInt((int)recordType);
            dest.writeStringList((List<String>)contributingPackages);
        });
    }
}

