/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.changelog;

import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Record;
import android.health.connect.internal.datatypes.utils.RecordMapper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ChangeLogTokenRequest
implements Parcelable {
    private final Set<DataOrigin> mDataOriginFilters;
    private final Set<Class<? extends Record>> mRecordTypes;
    public static final Parcelable.Creator<ChangeLogTokenRequest> CREATOR = new Parcelable.Creator<ChangeLogTokenRequest>(){

        @Override
        public ChangeLogTokenRequest createFromParcel(Parcel in) {
            return new ChangeLogTokenRequest(in);
        }

        public ChangeLogTokenRequest[] newArray(int size) {
            return new ChangeLogTokenRequest[size];
        }
    };

    private ChangeLogTokenRequest(Set<DataOrigin> dataOriginFilters, Set<Class<? extends Record>> recordTypes) {
        Objects.requireNonNull(recordTypes);
        Objects.requireNonNull(dataOriginFilters);
        this.mDataOriginFilters = dataOriginFilters;
        this.mRecordTypes = recordTypes;
    }

    private ChangeLogTokenRequest(Parcel in) {
        RecordMapper recordMapper = RecordMapper.getInstance();
        ArraySet<Class<? extends Record>> recordTypes = new ArraySet<Class<? extends Record>>();
        for (int recordType : in.createIntArray()) {
            recordTypes.add(recordMapper.getRecordIdToExternalRecordClassMap().get(recordType));
        }
        this.mRecordTypes = recordTypes;
        ArraySet<DataOrigin> dataOrigin = new ArraySet<DataOrigin>();
        for (String packageName : in.createStringArrayList()) {
            dataOrigin.add(new DataOrigin.Builder().setPackageName(packageName).build());
        }
        this.mDataOriginFilters = dataOrigin;
    }

    public Set<DataOrigin> getDataOriginFilters() {
        return this.mDataOriginFilters;
    }

    public Set<Class<? extends Record>> getRecordTypes() {
        return this.mRecordTypes;
    }

    public int[] getRecordTypesArray() {
        return this.getRecordTypesAsInteger();
    }

    public List<Integer> getRecordTypesList() {
        return Arrays.stream(this.getRecordTypesAsInteger()).boxed().collect(Collectors.toList());
    }

    public List<String> getPackageNamesToFilter() {
        return this.getPackageNames();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeIntArray(this.getRecordTypesAsInteger());
        dest.writeStringList(this.getPackageNames());
    }

    private int[] getRecordTypesAsInteger() {
        int[] recordTypes = new int[this.mRecordTypes.size()];
        int index = 0;
        for (Class<? extends Record> recordClass : this.mRecordTypes) {
            recordTypes[index++] = RecordMapper.getInstance().getRecordType(recordClass);
        }
        return recordTypes;
    }

    private List<String> getPackageNames() {
        ArrayList<String> packageNamesToFilter = new ArrayList<String>(this.mDataOriginFilters.size());
        this.mDataOriginFilters.forEach(dataOrigin -> packageNamesToFilter.add(dataOrigin.getPackageName()));
        return packageNamesToFilter;
    }

    public static class Builder {
        private final Set<Class<? extends Record>> mRecordTypes = new ArraySet<Class<? extends Record>>();
        private final Set<DataOrigin> mDataOriginFilters = new ArraySet<DataOrigin>();

        public Builder addRecordType(Class<? extends Record> recordType) {
            Objects.requireNonNull(recordType);
            this.mRecordTypes.add(recordType);
            return this;
        }

        public Builder addDataOriginFilter(DataOrigin dataOriginFilter) {
            Objects.requireNonNull(dataOriginFilter);
            this.mDataOriginFilters.add(dataOriginFilter);
            return this;
        }

        public ChangeLogTokenRequest build() {
            return new ChangeLogTokenRequest(this.mDataOriginFilters, this.mRecordTypes);
        }
    }
}

