/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.changelog;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

public class ChangeLogsRequest
implements Parcelable {
    private final String mToken;
    private final int mPageSize;
    public static final Parcelable.Creator<ChangeLogsRequest> CREATOR = new Parcelable.Creator<ChangeLogsRequest>(){

        @Override
        public ChangeLogsRequest createFromParcel(Parcel in) {
            return new ChangeLogsRequest(in);
        }

        public ChangeLogsRequest[] newArray(int size) {
            return new ChangeLogsRequest[size];
        }
    };

    private ChangeLogsRequest(String token, int pageSize) {
        Objects.requireNonNull(token);
        this.mToken = token;
        this.mPageSize = pageSize;
    }

    private ChangeLogsRequest(Parcel in) {
        this.mToken = in.readString();
        this.mPageSize = in.readInt();
    }

    public String getToken() {
        return this.mToken;
    }

    public int getPageSize() {
        return this.mPageSize;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mToken);
        dest.writeInt(this.mPageSize);
    }

    public static class Builder {
        private String mToken;
        private int mPageSize = 1000;

        public Builder(String token) {
            Objects.requireNonNull(token);
            this.mToken = token;
        }

        public Builder setPageSize(int pageSize) {
            if (pageSize > 5000) {
                throw new IllegalArgumentException("Maximum page size 5000 requested " + pageSize);
            }
            this.mPageSize = pageSize;
            return this;
        }

        public ChangeLogsRequest build() {
            return new ChangeLogsRequest(this.mToken, this.mPageSize);
        }
    }
}

