/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.BodyTemperatureMeasurementLocation;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Temperature;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.BasalBodyTemperatureRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=20)
public class BasalBodyTemperatureRecord
extends InstantRecord {
    private final int mMeasurementLocation;
    private final Temperature mTemperature;

    private BasalBodyTemperatureRecord(Metadata metadata, Instant time, ZoneOffset zoneOffset, int measurementLocation, Temperature temperature, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        Objects.requireNonNull(temperature);
        if (!skipValidation) {
            ValidationUtils.requireInRange(temperature.getInCelsius(), 0.0, 100.0, "temperature");
        }
        ValidationUtils.validateIntDefValue(measurementLocation, BodyTemperatureMeasurementLocation.VALID_TYPES, BodyTemperatureMeasurementLocation.class.getSimpleName());
        this.mMeasurementLocation = measurementLocation;
        this.mTemperature = temperature;
    }

    public int getMeasurementLocation() {
        return this.mMeasurementLocation;
    }

    public Temperature getTemperature() {
        return this.mTemperature;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        BasalBodyTemperatureRecord that = (BasalBodyTemperatureRecord)o;
        return this.getMeasurementLocation() == that.getMeasurementLocation() && this.getTemperature().equals(that.getTemperature());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMeasurementLocation(), this.getTemperature());
    }

    public BasalBodyTemperatureRecordInternal toRecordInternal() {
        BasalBodyTemperatureRecordInternal recordInternal = (BasalBodyTemperatureRecordInternal)new BasalBodyTemperatureRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setMeasurementLocation(this.mMeasurementLocation);
        recordInternal.setTemperature(this.mTemperature.getInCelsius());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final int mMeasurementLocation;
        private final Temperature mTemperature;

        public Builder(Metadata metadata, Instant time, int measurementLocation, Temperature temperature) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(temperature);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mMeasurementLocation = measurementLocation;
            this.mTemperature = temperature;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        public Builder setZoneOffset(ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public BasalBodyTemperatureRecord buildWithoutValidation() {
            return new BasalBodyTemperatureRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMeasurementLocation, this.mTemperature, true);
        }

        public BasalBodyTemperatureRecord build() {
            return new BasalBodyTemperatureRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMeasurementLocation, this.mTemperature, false);
        }
    }
}

