/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Energy;
import android.health.connect.datatypes.units.Power;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.BasalMetabolicRateRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=16)
public class BasalMetabolicRateRecord
extends InstantRecord {
    private final Power mBasalMetabolicRate;
    public static final AggregationType<Energy> BASAL_CALORIES_TOTAL = new AggregationType<Energy>(4, 3, 16, Energy.class);

    private BasalMetabolicRateRecord(Metadata metadata, Instant time, ZoneOffset zoneOffset, Power basalMetabolicRate, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        Objects.requireNonNull(basalMetabolicRate);
        if (!skipValidation) {
            ValidationUtils.requireInRange(basalMetabolicRate.getInWatts(), 0.0, 484.259, "basalMetabolicRate");
        }
        this.mBasalMetabolicRate = basalMetabolicRate;
    }

    public Power getBasalMetabolicRate() {
        return this.mBasalMetabolicRate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        BasalMetabolicRateRecord that = (BasalMetabolicRateRecord)o;
        return this.getBasalMetabolicRate().equals(that.getBasalMetabolicRate());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBasalMetabolicRate());
    }

    public BasalMetabolicRateRecordInternal toRecordInternal() {
        BasalMetabolicRateRecordInternal recordInternal = (BasalMetabolicRateRecordInternal)new BasalMetabolicRateRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setBasalMetabolicRate(this.mBasalMetabolicRate.getInWatts());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final Power mBasalMetabolicRate;

        public Builder(Metadata metadata, Instant time, Power basalMetabolicRate) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(basalMetabolicRate);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mBasalMetabolicRate = basalMetabolicRate;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        public Builder setZoneOffset(ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public BasalMetabolicRateRecord buildWithoutValidation() {
            return new BasalMetabolicRateRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mBasalMetabolicRate, true);
        }

        public BasalMetabolicRateRecord build() {
            return new BasalMetabolicRateRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mBasalMetabolicRate, false);
        }
    }
}

