/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Pressure;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.BloodPressureRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=23)
public class BloodPressureRecord
extends InstantRecord {
    private final int mMeasurementLocation;
    private final Pressure mSystolic;
    private final Pressure mDiastolic;
    private final int mBodyPosition;

    private BloodPressureRecord(Metadata metadata, Instant time, ZoneOffset zoneOffset, int measurementLocation, Pressure systolic, Pressure diastolic, int bodyPosition, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        Objects.requireNonNull(systolic);
        Objects.requireNonNull(diastolic);
        ValidationUtils.validateIntDefValue(measurementLocation, BloodPressureMeasurementLocation.VALID_TYPES, BloodPressureMeasurementLocation.class.getSimpleName());
        if (!skipValidation) {
            ValidationUtils.requireInRange(systolic.getInMillimetersOfMercury(), 20.0, 200.0, "systolic");
            ValidationUtils.requireInRange(diastolic.getInMillimetersOfMercury(), 10.0, 180.0, "diastolic");
        }
        ValidationUtils.validateIntDefValue(bodyPosition, BodyPosition.VALID_TYPES, BodyPosition.class.getSimpleName());
        this.mMeasurementLocation = measurementLocation;
        this.mSystolic = systolic;
        this.mDiastolic = diastolic;
        this.mBodyPosition = bodyPosition;
    }

    public int getMeasurementLocation() {
        return this.mMeasurementLocation;
    }

    public Pressure getSystolic() {
        return this.mSystolic;
    }

    public Pressure getDiastolic() {
        return this.mDiastolic;
    }

    public int getBodyPosition() {
        return this.mBodyPosition;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        BloodPressureRecord that = (BloodPressureRecord)o;
        return this.getMeasurementLocation() == that.getMeasurementLocation() && this.getBodyPosition() == that.getBodyPosition() && this.getSystolic().equals(that.getSystolic()) && this.getDiastolic().equals(that.getDiastolic());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMeasurementLocation(), this.getSystolic(), this.getDiastolic(), this.getBodyPosition());
    }

    public BloodPressureRecordInternal toRecordInternal() {
        BloodPressureRecordInternal recordInternal = (BloodPressureRecordInternal)new BloodPressureRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setMeasurementLocation(this.mMeasurementLocation);
        recordInternal.setSystolic(this.mSystolic.getInMillimetersOfMercury());
        recordInternal.setDiastolic(this.mDiastolic.getInMillimetersOfMercury());
        recordInternal.setBodyPosition(this.mBodyPosition);
        return recordInternal;
    }

    public static class BloodPressureMeasurementLocation {
        public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_UNKNOWN = 0;
        public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_WRIST = 1;
        public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_WRIST = 2;
        public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_LEFT_UPPER_ARM = 3;
        public static final int BLOOD_PRESSURE_MEASUREMENT_LOCATION_RIGHT_UPPER_ARM = 4;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4));

        private BloodPressureMeasurementLocation() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface BloodPressureMeasurementLocations {
        }
    }

    public static class BodyPosition {
        public static final int BODY_POSITION_UNKNOWN = 0;
        public static final int BODY_POSITION_STANDING_UP = 1;
        public static final int BODY_POSITION_SITTING_DOWN = 2;
        public static final int BODY_POSITION_LYING_DOWN = 3;
        public static final int BODY_POSITION_RECLINING = 4;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4));

        private BodyPosition() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface BodyPositionType {
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final int mMeasurementLocation;
        private final Pressure mSystolic;
        private final Pressure mDiastolic;
        private final int mBodyPosition;

        public Builder(Metadata metadata, Instant time, int measurementLocation, Pressure systolic, Pressure diastolic, int bodyPosition) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(systolic);
            Objects.requireNonNull(diastolic);
            ValidationUtils.validateIntDefValue(measurementLocation, BloodPressureMeasurementLocation.VALID_TYPES, BloodPressureMeasurementLocation.class.getSimpleName());
            this.mMetadata = metadata;
            this.mTime = time;
            this.mMeasurementLocation = measurementLocation;
            this.mSystolic = systolic;
            this.mDiastolic = diastolic;
            this.mBodyPosition = bodyPosition;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        public Builder setZoneOffset(ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public BloodPressureRecord buildWithoutValidation() {
            return new BloodPressureRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMeasurementLocation, this.mSystolic, this.mDiastolic, this.mBodyPosition, true);
        }

        public BloodPressureRecord build() {
            return new BloodPressureRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mMeasurementLocation, this.mSystolic, this.mDiastolic, this.mBodyPosition, false);
        }
    }
}

