/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.BodyWaterMassRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=34)
public class BodyWaterMassRecord
extends InstantRecord {
    private final Mass mBodyWaterMass;

    private BodyWaterMassRecord(Metadata metadata, Instant time, ZoneOffset zoneOffset, Mass bodyWaterMass, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(bodyWaterMass);
        if (!skipValidation) {
            ValidationUtils.requireInRange(bodyWaterMass.getInGrams(), 0.0, 1000000.0, "mass");
        }
        this.mBodyWaterMass = bodyWaterMass;
    }

    public Mass getBodyWaterMass() {
        return this.mBodyWaterMass;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        BodyWaterMassRecord that = (BodyWaterMassRecord)o;
        return this.getBodyWaterMass().equals(that.getBodyWaterMass());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getBodyWaterMass());
    }

    public BodyWaterMassRecordInternal toRecordInternal() {
        BodyWaterMassRecordInternal recordInternal = (BodyWaterMassRecordInternal)new BodyWaterMassRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setBodyWaterMass(this.mBodyWaterMass.getInGrams());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private final Mass mBodyWaterMass;
        private ZoneOffset mZoneOffset;

        public Builder(Metadata metadata, Instant time, Mass bodyWaterMass) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            Objects.requireNonNull(bodyWaterMass);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mBodyWaterMass = bodyWaterMass;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        public Builder setZoneOffset(ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public BodyWaterMassRecord buildWithoutValidation() {
            return new BodyWaterMassRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mBodyWaterMass, true);
        }

        public BodyWaterMassRecord build() {
            return new BodyWaterMassRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mBodyWaterMass, false);
        }
    }
}

