/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.CyclingPedalingCadenceRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

@Identifier(recordIdentifier=12)
public class CyclingPedalingCadenceRecord
extends IntervalRecord {
    private final List<CyclingPedalingCadenceRecordSample> mCyclingPedalingCadenceRecordSamples;

    private CyclingPedalingCadenceRecord(Metadata metadata, Instant startTime, ZoneOffset startZoneOffset, Instant endTime, ZoneOffset endZoneOffset, List<CyclingPedalingCadenceRecordSample> cyclingPedalingCadenceRecordSamples, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation);
        Objects.requireNonNull(cyclingPedalingCadenceRecordSamples);
        if (!skipValidation) {
            ValidationUtils.validateSampleStartAndEndTime(startTime, endTime, cyclingPedalingCadenceRecordSamples.stream().map(CyclingPedalingCadenceRecordSample::getTime).toList());
        }
        this.mCyclingPedalingCadenceRecordSamples = cyclingPedalingCadenceRecordSamples;
    }

    public List<CyclingPedalingCadenceRecordSample> getSamples() {
        return this.mCyclingPedalingCadenceRecordSamples;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            CyclingPedalingCadenceRecord other = (CyclingPedalingCadenceRecord)object;
            if (this.getSamples().size() != other.getSamples().size()) {
                return false;
            }
            for (int idx = 0; idx < this.getSamples().size(); ++idx) {
                if (this.getSamples().get(idx).getRevolutionsPerMinute() == other.getSamples().get(idx).getRevolutionsPerMinute() && this.getSamples().get(idx).getTime().toEpochMilli() == other.getSamples().get(idx).getTime().toEpochMilli()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSamples());
    }

    public CyclingPedalingCadenceRecordInternal toRecordInternal() {
        CyclingPedalingCadenceRecordInternal recordInternal = (CyclingPedalingCadenceRecordInternal)new CyclingPedalingCadenceRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        HashSet<CyclingPedalingCadenceRecordInternal.CyclingPedalingCadenceRecordSample> samples = new HashSet<CyclingPedalingCadenceRecordInternal.CyclingPedalingCadenceRecordSample>(this.getSamples().size());
        for (CyclingPedalingCadenceRecordSample cyclingPedalingCadenceRecordSample : this.getSamples()) {
            samples.add(new CyclingPedalingCadenceRecordInternal.CyclingPedalingCadenceRecordSample(cyclingPedalingCadenceRecordSample.getRevolutionsPerMinute(), cyclingPedalingCadenceRecordSample.getTime().toEpochMilli()));
        }
        recordInternal.setSamples(samples);
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        return recordInternal;
    }

    public static class CyclingPedalingCadenceRecordSample {
        private final double mRevolutionsPerMinute;
        private final Instant mTime;

        public CyclingPedalingCadenceRecordSample(double revolutionsPerMinute, Instant time) {
            this(revolutionsPerMinute, time, false);
        }

        public CyclingPedalingCadenceRecordSample(double revolutionsPerMinute, Instant time, boolean skipValidation) {
            Objects.requireNonNull(time);
            if (!skipValidation) {
                ValidationUtils.requireInRange(revolutionsPerMinute, 0.0, 10000.0, "revolutionsPerMinute");
            }
            this.mTime = time;
            this.mRevolutionsPerMinute = revolutionsPerMinute;
        }

        public double getRevolutionsPerMinute() {
            return this.mRevolutionsPerMinute;
        }

        public Instant getTime() {
            return this.mTime;
        }

        public boolean equals(Object object) {
            if (super.equals(object) && object instanceof CyclingPedalingCadenceRecordSample) {
                CyclingPedalingCadenceRecordSample other = (CyclingPedalingCadenceRecordSample)object;
                return this.getRevolutionsPerMinute() == other.getRevolutionsPerMinute() && this.getTime().toEpochMilli() == other.getTime().toEpochMilli();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getRevolutionsPerMinute(), this.getTime());
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<CyclingPedalingCadenceRecordSample> mCyclingPedalingCadenceRecordSamples;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;

        public Builder(Metadata metadata, Instant startTime, Instant endTime, List<CyclingPedalingCadenceRecordSample> cyclingPedalingCadenceRecordSamples) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(cyclingPedalingCadenceRecordSamples);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mCyclingPedalingCadenceRecordSamples = cyclingPedalingCadenceRecordSamples;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        public Builder setStartZoneOffset(ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        public Builder setEndZoneOffset(ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public CyclingPedalingCadenceRecord buildWithoutValidation() {
            return new CyclingPedalingCadenceRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mCyclingPedalingCadenceRecordSamples, true);
        }

        public CyclingPedalingCadenceRecord build() {
            return new CyclingPedalingCadenceRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mCyclingPedalingCadenceRecordSamples, false);
        }
    }
}

