/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.TimeInterval;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.ExerciseSegmentInternal;
import java.time.Instant;
import java.util.Objects;

public class ExerciseSegment
implements TimeInterval.TimeIntervalHolder {
    private final TimeInterval mInterval;
    private final int mSegmentType;
    private final int mRepetitionsCount;

    private ExerciseSegment(TimeInterval interval, int segmentType, int repetitionsCount, boolean skipValidation) {
        Objects.requireNonNull(interval);
        this.mInterval = interval;
        this.mSegmentType = segmentType;
        if (!skipValidation) {
            ValidationUtils.requireNonNegative(repetitionsCount, "repetitionsCount");
        }
        this.mRepetitionsCount = repetitionsCount;
    }

    public int getSegmentType() {
        return this.mSegmentType;
    }

    public int getRepetitionsCount() {
        return this.mRepetitionsCount;
    }

    public Instant getStartTime() {
        return this.mInterval.getStartTime();
    }

    public Instant getEndTime() {
        return this.mInterval.getEndTime();
    }

    @Override
    public TimeInterval getInterval() {
        return this.mInterval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExerciseSegment)) {
            return false;
        }
        ExerciseSegment that = (ExerciseSegment)o;
        return this.mSegmentType == that.mSegmentType && this.mRepetitionsCount == that.mRepetitionsCount && Objects.equals(this.mInterval, that.mInterval);
    }

    public int hashCode() {
        return Objects.hash(this.mSegmentType, this.mRepetitionsCount, this.mInterval);
    }

    public ExerciseSegmentInternal toSegmentInternal() {
        return new ExerciseSegmentInternal().setStarTime(this.getStartTime().toEpochMilli()).setEndTime(this.getEndTime().toEpochMilli()).setSegmentType(this.getSegmentType()).setRepetitionsCount(this.getRepetitionsCount());
    }

    public static class Builder {
        private final TimeInterval mInterval;
        private final int mSegmentType;
        private int mRepetitionsCount = 0;

        public Builder(Instant startTime, Instant endTime, int segmentType) {
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.mInterval = new TimeInterval(startTime, endTime);
            this.mSegmentType = segmentType;
        }

        public Builder setRepetitionsCount(int repetitionsCount) {
            if (repetitionsCount < 0) {
                throw new IllegalArgumentException("Number of repetitions must be non negative.");
            }
            this.mRepetitionsCount = repetitionsCount;
            return this;
        }

        public ExerciseSegment buildWithoutValidation() {
            return new ExerciseSegment(this.mInterval, this.mSegmentType, this.mRepetitionsCount, true);
        }

        public ExerciseSegment build() {
            return new ExerciseSegment(this.mInterval, this.mSegmentType, this.mRepetitionsCount, false);
        }
    }
}

