/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.ExerciseLap;
import android.health.connect.datatypes.ExerciseRoute;
import android.health.connect.datatypes.ExerciseSegment;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ExerciseSessionTypesValidation;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.ExerciseSessionRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Identifier(recordIdentifier=37)
public class ExerciseSessionRecord
extends IntervalRecord {
    public static final AggregationType<Long> EXERCISE_DURATION_TOTAL = new AggregationType<Long>(67, 3, 37, Long.class);
    private final int mExerciseType;
    private final CharSequence mNotes;
    private final CharSequence mTitle;
    private final ExerciseRoute mRoute;
    private final boolean mHasRoute;
    private final List<ExerciseSegment> mSegments;
    private final List<ExerciseLap> mLaps;

    private ExerciseSessionRecord(Metadata metadata, Instant startTime, ZoneOffset startZoneOffset, Instant endTime, ZoneOffset endZoneOffset, CharSequence notes, int exerciseType, CharSequence title, ExerciseRoute route, boolean hasRoute, List<ExerciseSegment> segments, List<ExerciseLap> laps, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation);
        this.mNotes = notes;
        this.mExerciseType = exerciseType;
        this.mTitle = title;
        if (route != null && !hasRoute) {
            throw new IllegalArgumentException("HasRoute must be true if the route is not null");
        }
        this.mRoute = route;
        if (!skipValidation) {
            ExerciseSessionTypesValidation.validateExerciseRouteTimestamps(startTime, endTime, route);
        }
        this.mHasRoute = hasRoute;
        this.mSegments = Collections.unmodifiableList(ValidationUtils.sortAndValidateTimeIntervalHolders(startTime, endTime, segments));
        if (!skipValidation) {
            ExerciseSessionTypesValidation.validateSessionAndSegmentsTypes(exerciseType, this.mSegments);
        }
        this.mLaps = Collections.unmodifiableList(ValidationUtils.sortAndValidateTimeIntervalHolders(startTime, endTime, laps));
    }

    public int getExerciseType() {
        return this.mExerciseType;
    }

    public CharSequence getNotes() {
        return this.mNotes;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public ExerciseRoute getRoute() {
        return this.mRoute;
    }

    public List<ExerciseSegment> getSegments() {
        return this.mSegments;
    }

    public List<ExerciseLap> getLaps() {
        return this.mLaps;
    }

    public boolean hasRoute() {
        return this.mHasRoute;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExerciseSessionRecord)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ExerciseSessionRecord that = (ExerciseSessionRecord)o;
        return this.getExerciseType() == that.getExerciseType() && RecordUtils.isEqualNullableCharSequences(this.getNotes(), that.getNotes()) && RecordUtils.isEqualNullableCharSequences(this.getTitle(), that.getTitle()) && Objects.equals(this.getRoute(), that.getRoute()) && Objects.equals(this.getSegments(), that.getSegments()) && Objects.equals(this.getLaps(), that.getLaps());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getExerciseType(), this.getNotes(), this.getTitle(), this.getRoute(), this.getSegments(), this.getLaps());
    }

    public ExerciseSessionRecordInternal toRecordInternal() {
        ExerciseSessionRecordInternal recordInternal = (ExerciseSessionRecordInternal)new ExerciseSessionRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        if (this.getNotes() != null) {
            recordInternal.setNotes(this.getNotes().toString());
        }
        if (this.getTitle() != null) {
            recordInternal.setTitle(this.getTitle().toString());
        }
        if (this.getRoute() != null) {
            recordInternal.setRoute(this.getRoute().toRouteInternal());
        }
        if (this.getLaps() != null && !this.getLaps().isEmpty()) {
            recordInternal.setExerciseLaps(this.getLaps().stream().map(ExerciseLap::toExerciseLapInternal).collect(Collectors.toList()));
        }
        if (this.getSegments() != null && !this.getSegments().isEmpty()) {
            recordInternal.setExerciseSegments(this.getSegments().stream().map(ExerciseSegment::toSegmentInternal).collect(Collectors.toList()));
        }
        recordInternal.setExerciseType(this.mExerciseType);
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        private final int mExerciseType;
        private CharSequence mNotes;
        private CharSequence mTitle;
        private ExerciseRoute mRoute;
        private final List<ExerciseSegment> mSegments;
        private final List<ExerciseLap> mLaps;
        private boolean mHasRoute;

        public Builder(Metadata metadata, Instant startTime, Instant endTime, int exerciseType) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mExerciseType = exerciseType;
            this.mSegments = new ArrayList<ExerciseSegment>();
            this.mLaps = new ArrayList<ExerciseLap>();
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        public Builder setStartZoneOffset(ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        public Builder setEndZoneOffset(ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public Builder setNotes(CharSequence notes) {
            this.mNotes = notes;
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setRoute(ExerciseRoute route) {
            this.mRoute = route;
            this.mHasRoute = route != null;
            return this;
        }

        public Builder setLaps(List<ExerciseLap> laps) {
            Objects.requireNonNull(laps);
            this.mLaps.clear();
            this.mLaps.addAll(laps);
            return this;
        }

        public Builder setSegments(List<ExerciseSegment> segments) {
            Objects.requireNonNull(segments);
            this.mSegments.clear();
            this.mSegments.addAll(segments);
            return this;
        }

        public Builder setHasRoute(boolean hasRoute) {
            this.mHasRoute = hasRoute;
            return this;
        }

        public ExerciseSessionRecord buildWithoutValidation() {
            return new ExerciseSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mNotes, this.mExerciseType, this.mTitle, this.mRoute, this.mHasRoute, this.mSegments, this.mLaps, true);
        }

        public ExerciseSessionRecord build() {
            return new ExerciseSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mNotes, this.mExerciseType, this.mTitle, this.mRoute, this.mHasRoute, this.mSegments, this.mLaps, false);
        }
    }
}

