/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.HeartRateRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

@Identifier(recordIdentifier=11)
public class HeartRateRecord
extends IntervalRecord {
    public static final AggregationType<Long> BPM_MAX = new AggregationType<Long>(0, 0, 11, Long.class);
    public static final AggregationType<Long> BPM_MIN = new AggregationType<Long>(1, 1, 11, Long.class);
    public static final AggregationType<Long> BPM_AVG = new AggregationType<Long>(7, 2, 11, Long.class);
    public static final AggregationType<Long> HEART_MEASUREMENTS_COUNT = new AggregationType<Long>(64, 4, 11, Long.class);
    private final List<HeartRateSample> mHeartRateSamples;

    private HeartRateRecord(Metadata metadata, Instant startTime, ZoneOffset startZoneOffset, Instant endTime, ZoneOffset endZoneOffset, List<HeartRateSample> heartRateSamples, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation);
        Objects.requireNonNull(heartRateSamples);
        if (!skipValidation) {
            ValidationUtils.validateSampleStartAndEndTime(startTime, endTime, heartRateSamples.stream().map(HeartRateSample::getTime).toList());
        }
        this.mHeartRateSamples = heartRateSamples;
    }

    public List<HeartRateSample> getSamples() {
        return this.mHeartRateSamples;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof HeartRateRecord) {
            HeartRateRecord other = (HeartRateRecord)object;
            if (this.getSamples().size() != other.getSamples().size()) {
                return false;
            }
            for (int idx = 0; idx < this.getSamples().size(); ++idx) {
                if (this.getSamples().get(idx).getBeatsPerMinute() == other.getSamples().get(idx).getBeatsPerMinute() && this.getSamples().get(idx).getTime().toEpochMilli() == other.getSamples().get(idx).getTime().toEpochMilli()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSamples());
    }

    public HeartRateRecordInternal toRecordInternal() {
        HeartRateRecordInternal recordInternal = (HeartRateRecordInternal)new HeartRateRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        HashSet<HeartRateRecordInternal.HeartRateSample> samples = new HashSet<HeartRateRecordInternal.HeartRateSample>(this.getSamples().size());
        for (HeartRateSample heartRateSample : this.getSamples()) {
            samples.add(new HeartRateRecordInternal.HeartRateSample((int)heartRateSample.getBeatsPerMinute(), heartRateSample.getTime().toEpochMilli()));
        }
        recordInternal.setSamples(samples);
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        return recordInternal;
    }

    public static class HeartRateSample {
        private final long mBeatsPerMinute;
        private final Instant mTime;

        public HeartRateSample(long beatsPerMinute, Instant time) {
            this(beatsPerMinute, time, false);
        }

        public HeartRateSample(long beatsPerMinute, Instant time, boolean skipValidation) {
            Objects.requireNonNull(time);
            if (!skipValidation) {
                ValidationUtils.requireInRange(beatsPerMinute, 1L, 300L, "beatsPerMinute");
            }
            this.mBeatsPerMinute = beatsPerMinute;
            this.mTime = time;
        }

        public long getBeatsPerMinute() {
            return this.mBeatsPerMinute;
        }

        public Instant getTime() {
            return this.mTime;
        }

        public boolean equals(Object object) {
            if (super.equals(object) && object instanceof HeartRateSample) {
                HeartRateSample other = (HeartRateSample)object;
                return this.getBeatsPerMinute() == other.getBeatsPerMinute() && this.getTime().toEpochMilli() == other.getTime().toEpochMilli();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getBeatsPerMinute(), this.getTime());
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<HeartRateSample> mHeartRateSamples;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;

        public Builder(Metadata metadata, Instant startTime, Instant endTime, List<HeartRateSample> heartRateSamples) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(heartRateSamples);
            if (heartRateSamples.isEmpty()) {
                throw new IllegalArgumentException("record samples should not be empty");
            }
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mHeartRateSamples = heartRateSamples;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        public Builder setStartZoneOffset(ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        public Builder setEndZoneOffset(ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public HeartRateRecord buildWithoutValidation() {
            return new HeartRateRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mHeartRateSamples, true);
        }

        public HeartRateRecord build() {
            return new HeartRateRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mHeartRateSamples, false);
        }
    }
}

