/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.HeartRateVariabilityRmssdRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=35)
public class HeartRateVariabilityRmssdRecord
extends InstantRecord {
    private final double mHeartRateVariabilityMillis;

    private HeartRateVariabilityRmssdRecord(Metadata metadata, Instant time, ZoneOffset zoneOffset, double heartRateVariabilityMillis, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        if (!skipValidation) {
            ValidationUtils.requireInRange(heartRateVariabilityMillis, 1.0, 200.0, "heartRateVariabilityMillis");
        }
        this.mHeartRateVariabilityMillis = heartRateVariabilityMillis;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        HeartRateVariabilityRmssdRecord that = (HeartRateVariabilityRmssdRecord)o;
        return this.getHeartRateVariabilityMillis() == that.getHeartRateVariabilityMillis();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getHeartRateVariabilityMillis());
    }

    public double getHeartRateVariabilityMillis() {
        return this.mHeartRateVariabilityMillis;
    }

    public HeartRateVariabilityRmssdRecordInternal toRecordInternal() {
        HeartRateVariabilityRmssdRecordInternal recordInternal = (HeartRateVariabilityRmssdRecordInternal)new HeartRateVariabilityRmssdRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setHeartRateVariabilityMillis(this.mHeartRateVariabilityMillis);
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private final double mHeartRateVariabilityMillis;
        private ZoneOffset mZoneOffset;

        public Builder(Metadata metadata, Instant time, double heartRateVariabilityMillis) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mHeartRateVariabilityMillis = heartRateVariabilityMillis;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(this.mTime);
        }

        public Builder setZoneOffset(ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public HeartRateVariabilityRmssdRecord buildWithoutValidation() {
            return new HeartRateVariabilityRmssdRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mHeartRateVariabilityMillis, true);
        }

        public HeartRateVariabilityRmssdRecord build() {
            return new HeartRateVariabilityRmssdRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mHeartRateVariabilityMillis, false);
        }
    }
}

