/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.Record;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

public abstract class InstantRecord
extends Record {
    private final Instant mTime;
    private final ZoneOffset mZoneOffset;

    InstantRecord(Metadata metadata, Instant time, ZoneOffset zoneOffset, boolean skipValidation) {
        super(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        if (!skipValidation && time.isAfter(Instant.now())) {
            throw new IllegalArgumentException("Record time must not be in the future, record time: " + time + " currentTime: " + Instant.now());
        }
        this.mTime = time;
        this.mZoneOffset = zoneOffset;
    }

    public Instant getTime() {
        return this.mTime;
    }

    public ZoneOffset getZoneOffset() {
        return this.mZoneOffset;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            InstantRecord other = (InstantRecord)object;
            return this.getTime().toEpochMilli() == other.getTime().toEpochMilli() && this.getZoneOffset().equals(other.getZoneOffset());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getTime(), this.getZoneOffset());
    }
}

