/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.internal.datatypes.IntermenstrualBleedingRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=36)
public class IntermenstrualBleedingRecord
extends InstantRecord {
    private IntermenstrualBleedingRecord(Metadata metadata, Instant time, ZoneOffset zoneOffset, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public IntermenstrualBleedingRecordInternal toRecordInternal() {
        IntermenstrualBleedingRecordInternal recordInternal = (IntermenstrualBleedingRecordInternal)new IntermenstrualBleedingRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;

        public Builder(Metadata metadata, Instant time) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        public Builder setZoneOffset(ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public IntermenstrualBleedingRecord buildWithoutValidation() {
            return new IntermenstrualBleedingRecord(this.mMetadata, this.mTime, this.mZoneOffset, true);
        }

        public IntermenstrualBleedingRecord build() {
            return new IntermenstrualBleedingRecord(this.mMetadata, this.mTime, this.mZoneOffset, false);
        }
    }
}

