/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Device;
import android.health.connect.datatypes.validation.ValidationUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.util.Objects;
import java.util.Set;

public class Metadata {
    public static final int RECORDING_METHOD_UNKNOWN = 0;
    public static final int RECORDING_METHOD_ACTIVELY_RECORDED = 1;
    public static final int RECORDING_METHOD_AUTOMATICALLY_RECORDED = 2;
    public static final int RECORDING_METHOD_MANUAL_ENTRY = 3;
    public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));
    private final Device mDevice;
    private final DataOrigin mDataOrigin;
    private final Instant mLastModifiedTime;
    private final String mClientRecordId;
    private final long mClientRecordVersion;
    private final int mRecordingMethod;
    private String mId;

    private Metadata(Device device, DataOrigin dataOrigin, String id2, Instant lastModifiedTime, String clientRecordId, long clientRecordVersion, int recordingMethod) {
        ValidationUtils.validateIntDefValue(recordingMethod, VALID_TYPES, RecordingMethod.class.getSimpleName());
        this.mDevice = device;
        this.mDataOrigin = dataOrigin;
        this.mId = id2;
        this.mLastModifiedTime = lastModifiedTime;
        this.mClientRecordId = clientRecordId;
        this.mClientRecordVersion = clientRecordVersion;
        this.mRecordingMethod = recordingMethod;
    }

    public String getClientRecordId() {
        return this.mClientRecordId;
    }

    public long getClientRecordVersion() {
        return this.mClientRecordVersion;
    }

    public DataOrigin getDataOrigin() {
        return this.mDataOrigin;
    }

    public String getId() {
        return this.mId;
    }

    public void setId(String id2) {
        Objects.requireNonNull(id2);
        this.mId = id2;
    }

    public int getRecordingMethod() {
        return this.mRecordingMethod;
    }

    public Instant getLastModifiedTime() {
        return this.mLastModifiedTime;
    }

    public Device getDevice() {
        return this.mDevice;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Metadata) {
            Metadata other = (Metadata)object;
            return this.getDevice().equals(other.getDevice()) && this.getDataOrigin().equals(other.getDataOrigin()) && this.getId().equals(other.getId()) && Objects.equals(this.getClientRecordId(), other.getClientRecordId()) && this.getClientRecordVersion() == other.getClientRecordVersion() && this.getRecordingMethod() == other.getRecordingMethod();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getDevice(), this.getDataOrigin(), this.getId(), this.getClientRecordId(), this.getClientRecordVersion(), this.getLastModifiedTime(), this.getRecordingMethod());
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RecordingMethod {
    }

    public static class Builder {
        private Device mDevice = new Device.Builder().build();
        private DataOrigin mDataOrigin = new DataOrigin.Builder().build();
        private String mId = "";
        private Instant mLastModifiedTime = Instant.EPOCH;
        private String mClientRecordId;
        private long mClientRecordVersion = 0L;
        private int mRecordingMethod = 0;

        public Builder setDevice(Device device) {
            Objects.requireNonNull(device);
            this.mDevice = device;
            return this;
        }

        public Builder setDataOrigin(DataOrigin dataOrigin) {
            Objects.requireNonNull(dataOrigin);
            this.mDataOrigin = dataOrigin;
            return this;
        }

        public Builder setId(String id2) {
            Objects.requireNonNull(id2);
            this.mId = id2;
            return this;
        }

        public Builder setLastModifiedTime(Instant lastModifiedTime) {
            Objects.requireNonNull(lastModifiedTime);
            this.mLastModifiedTime = lastModifiedTime;
            return this;
        }

        public Builder setClientRecordId(String clientRecordId) {
            this.mClientRecordId = clientRecordId;
            return this;
        }

        public Builder setClientRecordVersion(long clientRecordVersion) {
            this.mClientRecordVersion = clientRecordVersion;
            return this;
        }

        public Builder setRecordingMethod(int recordingMethod) {
            this.mRecordingMethod = recordingMethod;
            return this;
        }

        public Metadata build() {
            return new Metadata(this.mDevice, this.mDataOrigin, this.mId, this.mLastModifiedTime, this.mClientRecordId, this.mClientRecordVersion, this.mRecordingMethod);
        }
    }
}

