/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.MealType;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Energy;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.NutritionRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=8)
public class NutritionRecord
extends IntervalRecord {
    private static final Energy ENERGY_0_0 = Energy.fromCalories(0.0);
    private static final Mass MASS_0_0 = Mass.fromGrams(0.0);
    private static final Mass MASS_100 = Mass.fromGrams(100.0);
    private static final Mass MASS_100000 = Mass.fromGrams(100000.0);
    public static final AggregationType<Mass> BIOTIN_TOTAL = new AggregationType<Mass>(13, 3, 8, Mass.class);
    public static final AggregationType<Mass> CAFFEINE_TOTAL = new AggregationType<Mass>(14, 3, 8, Mass.class);
    public static final AggregationType<Mass> CALCIUM_TOTAL = new AggregationType<Mass>(15, 3, 8, Mass.class);
    public static final AggregationType<Mass> CHLORIDE_TOTAL = new AggregationType<Mass>(16, 3, 8, Mass.class);
    public static final AggregationType<Mass> CHOLESTEROL_TOTAL = new AggregationType<Mass>(17, 3, 8, Mass.class);
    public static final AggregationType<Mass> CHROMIUM_TOTAL = new AggregationType<Mass>(18, 3, 8, Mass.class);
    public static final AggregationType<Mass> COPPER_TOTAL = new AggregationType<Mass>(19, 3, 8, Mass.class);
    public static final AggregationType<Mass> DIETARY_FIBER_TOTAL = new AggregationType<Mass>(20, 3, 8, Mass.class);
    public static final AggregationType<Energy> ENERGY_TOTAL = new AggregationType<Energy>(21, 3, 8, Energy.class);
    public static final AggregationType<Energy> ENERGY_FROM_FAT_TOTAL = new AggregationType<Energy>(22, 3, 8, Energy.class);
    public static final AggregationType<Mass> FOLATE_TOTAL = new AggregationType<Mass>(23, 3, 8, Mass.class);
    public static final AggregationType<Mass> FOLIC_ACID_TOTAL = new AggregationType<Mass>(24, 3, 8, Mass.class);
    public static final AggregationType<Mass> IODINE_TOTAL = new AggregationType<Mass>(25, 3, 8, Mass.class);
    public static final AggregationType<Mass> IRON_TOTAL = new AggregationType<Mass>(26, 3, 8, Mass.class);
    public static final AggregationType<Mass> MAGNESIUM_TOTAL = new AggregationType<Mass>(27, 3, 8, Mass.class);
    public static final AggregationType<Mass> MANGANESE_TOTAL = new AggregationType<Mass>(28, 3, 8, Mass.class);
    public static final AggregationType<Mass> MOLYBDENUM_TOTAL = new AggregationType<Mass>(29, 3, 8, Mass.class);
    public static final AggregationType<Mass> MONOUNSATURATED_FAT_TOTAL = new AggregationType<Mass>(30, 3, 8, Mass.class);
    public static final AggregationType<Mass> NIACIN_TOTAL = new AggregationType<Mass>(31, 3, 8, Mass.class);
    public static final AggregationType<Mass> PANTOTHENIC_ACID_TOTAL = new AggregationType<Mass>(32, 3, 8, Mass.class);
    public static final AggregationType<Mass> PHOSPHORUS_TOTAL = new AggregationType<Mass>(33, 3, 8, Mass.class);
    public static final AggregationType<Mass> POLYUNSATURATED_FAT_TOTAL = new AggregationType<Mass>(34, 3, 8, Mass.class);
    public static final AggregationType<Mass> POTASSIUM_TOTAL = new AggregationType<Mass>(35, 3, 8, Mass.class);
    public static final AggregationType<Mass> PROTEIN_TOTAL = new AggregationType<Mass>(36, 3, 8, Mass.class);
    public static final AggregationType<Mass> RIBOFLAVIN_TOTAL = new AggregationType<Mass>(37, 3, 8, Mass.class);
    public static final AggregationType<Mass> SATURATED_FAT_TOTAL = new AggregationType<Mass>(38, 3, 8, Mass.class);
    public static final AggregationType<Mass> SELENIUM_TOTAL = new AggregationType<Mass>(39, 3, 8, Mass.class);
    public static final AggregationType<Mass> SODIUM_TOTAL = new AggregationType<Mass>(40, 3, 8, Mass.class);
    public static final AggregationType<Mass> SUGAR_TOTAL = new AggregationType<Mass>(41, 3, 8, Mass.class);
    public static final AggregationType<Mass> THIAMIN_TOTAL = new AggregationType<Mass>(42, 3, 8, Mass.class);
    public static final AggregationType<Mass> TOTAL_CARBOHYDRATE_TOTAL = new AggregationType<Mass>(43, 3, 8, Mass.class);
    public static final AggregationType<Mass> TOTAL_FAT_TOTAL = new AggregationType<Mass>(44, 3, 8, Mass.class);
    public static final AggregationType<Mass> UNSATURATED_FAT_TOTAL = new AggregationType<Mass>(45, 3, 8, Mass.class);
    public static final AggregationType<Mass> VITAMIN_A_TOTAL = new AggregationType<Mass>(46, 3, 8, Mass.class);
    public static final AggregationType<Mass> VITAMIN_B12_TOTAL = new AggregationType<Mass>(47, 3, 8, Mass.class);
    public static final AggregationType<Mass> VITAMIN_B6_TOTAL = new AggregationType<Mass>(48, 3, 8, Mass.class);
    public static final AggregationType<Mass> VITAMIN_C_TOTAL = new AggregationType<Mass>(49, 3, 8, Mass.class);
    public static final AggregationType<Mass> VITAMIN_D_TOTAL = new AggregationType<Mass>(50, 3, 8, Mass.class);
    public static final AggregationType<Mass> VITAMIN_E_TOTAL = new AggregationType<Mass>(51, 3, 8, Mass.class);
    public static final AggregationType<Mass> VITAMIN_K_TOTAL = new AggregationType<Mass>(52, 3, 8, Mass.class);
    public static final AggregationType<Mass> ZINC_TOTAL = new AggregationType<Mass>(53, 3, 8, Mass.class);
    private final int mMealType;
    private final Mass mUnsaturatedFat;
    private final Mass mPotassium;
    private final Mass mThiamin;
    private final Mass mTransFat;
    private final Mass mManganese;
    private final Energy mEnergyFromFat;
    private final Mass mCaffeine;
    private final Mass mDietaryFiber;
    private final Mass mSelenium;
    private final Mass mVitaminB6;
    private final Mass mProtein;
    private final Mass mChloride;
    private final Mass mCholesterol;
    private final Mass mCopper;
    private final Mass mIodine;
    private final Mass mVitaminB12;
    private final Mass mZinc;
    private final Mass mRiboflavin;
    private final Energy mEnergy;
    private final Mass mMolybdenum;
    private final Mass mPhosphorus;
    private final Mass mChromium;
    private final Mass mTotalFat;
    private final Mass mCalcium;
    private final Mass mVitaminC;
    private final Mass mVitaminE;
    private final Mass mBiotin;
    private final Mass mVitaminD;
    private final Mass mNiacin;
    private final Mass mMagnesium;
    private final Mass mTotalCarbohydrate;
    private final Mass mVitaminK;
    private final Mass mPolyunsaturatedFat;
    private final Mass mSaturatedFat;
    private final Mass mSodium;
    private final Mass mFolate;
    private final Mass mMonounsaturatedFat;
    private final Mass mPantothenicAcid;
    private final String mMealName;
    private final Mass mIron;
    private final Mass mVitaminA;
    private final Mass mFolicAcid;
    private final Mass mSugar;

    private NutritionRecord(Metadata metadata, Instant startTime, ZoneOffset startZoneOffset, Instant endTime, ZoneOffset endZoneOffset, Mass unsaturatedFat, Mass potassium, Mass thiamin, int mealType, Mass transFat, Mass manganese, Energy energyFromFat, Mass caffeine, Mass dietaryFiber, Mass selenium, Mass vitaminB6, Mass protein, Mass chloride, Mass cholesterol, Mass copper, Mass iodine, Mass vitaminB12, Mass zinc, Mass riboflavin, Energy energy, Mass molybdenum, Mass phosphorus, Mass chromium, Mass totalFat, Mass calcium, Mass vitaminC, Mass vitaminE, Mass biotin, Mass vitaminD, Mass niacin, Mass magnesium, Mass totalCarbohydrate, Mass vitaminK, Mass polyunsaturatedFat, Mass saturatedFat, Mass sodium, Mass folate, Mass monounsaturatedFat, Mass pantothenicAcid, String mealName, Mass iron, Mass vitaminA, Mass folicAcid, Mass sugar, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation);
        ValidationUtils.validateIntDefValue(mealType, MealType.VALID_TYPES, MealType.class.getSimpleName());
        if (!skipValidation) {
            ValidationUtils.requireInRangeIfExists(unsaturatedFat, MASS_0_0, MASS_100000, "unsaturatedFat");
            ValidationUtils.requireInRangeIfExists(potassium, MASS_0_0, MASS_100, "potassium");
            ValidationUtils.requireInRangeIfExists(thiamin, MASS_0_0, MASS_100, "thiamin");
            ValidationUtils.requireInRangeIfExists(transFat, MASS_0_0, MASS_100000, "transFat");
            ValidationUtils.requireInRangeIfExists(manganese, MASS_0_0, MASS_100, "manganese");
            ValidationUtils.requireInRangeIfExists(energyFromFat, ENERGY_0_0, Energy.fromCalories(1.0E8), "energyFromFat");
            ValidationUtils.requireInRangeIfExists(caffeine, MASS_0_0, MASS_100, "caffeine");
            ValidationUtils.requireInRangeIfExists(dietaryFiber, MASS_0_0, MASS_100000, "dietaryFiber");
            ValidationUtils.requireInRangeIfExists(selenium, MASS_0_0, MASS_100, "selenium");
            ValidationUtils.requireInRangeIfExists(vitaminB6, MASS_0_0, MASS_100, "vitaminB6");
            ValidationUtils.requireInRangeIfExists(protein, MASS_0_0, MASS_100000, "protein");
            ValidationUtils.requireInRangeIfExists(chloride, MASS_0_0, MASS_100, "chloride");
            ValidationUtils.requireInRangeIfExists(cholesterol, MASS_0_0, MASS_100, "cholesterol");
            ValidationUtils.requireInRangeIfExists(copper, MASS_0_0, MASS_100, "copper");
            ValidationUtils.requireInRangeIfExists(iodine, MASS_0_0, MASS_100, "iodine");
            ValidationUtils.requireInRangeIfExists(vitaminB12, MASS_0_0, MASS_100, "vitaminB12");
            ValidationUtils.requireInRangeIfExists(zinc, MASS_0_0, MASS_100, "zinc");
            ValidationUtils.requireInRangeIfExists(riboflavin, MASS_0_0, MASS_100, "riboflavin");
            ValidationUtils.requireInRangeIfExists(energy, ENERGY_0_0, Energy.fromCalories(1.0E8), "energy");
            ValidationUtils.requireInRangeIfExists(molybdenum, MASS_0_0, MASS_100, "molybdenum");
            ValidationUtils.requireInRangeIfExists(phosphorus, MASS_0_0, MASS_100, "phosphorus");
            ValidationUtils.requireInRangeIfExists(chromium, MASS_0_0, MASS_100, "chromium");
            ValidationUtils.requireInRangeIfExists(totalFat, MASS_0_0, MASS_100000, "totalFat");
            ValidationUtils.requireInRangeIfExists(calcium, MASS_0_0, MASS_100, "calcium");
            ValidationUtils.requireInRangeIfExists(vitaminC, MASS_0_0, MASS_100, "vitaminC");
            ValidationUtils.requireInRangeIfExists(vitaminE, MASS_0_0, MASS_100, "vitaminE");
            ValidationUtils.requireInRangeIfExists(biotin, MASS_0_0, MASS_100, "biotin");
            ValidationUtils.requireInRangeIfExists(vitaminD, MASS_0_0, MASS_100, "vitaminD");
            ValidationUtils.requireInRangeIfExists(niacin, MASS_0_0, MASS_100, "niacin");
            ValidationUtils.requireInRangeIfExists(magnesium, MASS_0_0, MASS_100, "magnesium");
            ValidationUtils.requireInRangeIfExists(totalCarbohydrate, MASS_0_0, MASS_100000, "totalCarbohydrate");
            ValidationUtils.requireInRangeIfExists(vitaminK, MASS_0_0, MASS_100, "vitaminK");
            ValidationUtils.requireInRangeIfExists(polyunsaturatedFat, MASS_0_0, MASS_100000, "polyunsaturatedFat");
            ValidationUtils.requireInRangeIfExists(saturatedFat, MASS_0_0, MASS_100000, "saturatedFat");
            ValidationUtils.requireInRangeIfExists(sodium, MASS_0_0, MASS_100, "sodium");
            ValidationUtils.requireInRangeIfExists(folate, MASS_0_0, MASS_100, "folate");
            ValidationUtils.requireInRangeIfExists(monounsaturatedFat, MASS_0_0, MASS_100000, "monounsaturatedFat");
            ValidationUtils.requireInRangeIfExists(pantothenicAcid, MASS_0_0, MASS_100, "pantothenicAcid");
            ValidationUtils.requireInRangeIfExists(iron, MASS_0_0, MASS_100, "iron");
            ValidationUtils.requireInRangeIfExists(vitaminA, MASS_0_0, MASS_100, "vitaminA");
            ValidationUtils.requireInRangeIfExists(folicAcid, MASS_0_0, MASS_100, "folicAcid");
            ValidationUtils.requireInRangeIfExists(sugar, MASS_0_0, MASS_100000, "sugar");
        }
        this.mUnsaturatedFat = unsaturatedFat;
        this.mPotassium = potassium;
        this.mThiamin = thiamin;
        this.mMealType = mealType;
        this.mTransFat = transFat;
        this.mManganese = manganese;
        this.mEnergyFromFat = energyFromFat;
        this.mCaffeine = caffeine;
        this.mDietaryFiber = dietaryFiber;
        this.mSelenium = selenium;
        this.mVitaminB6 = vitaminB6;
        this.mProtein = protein;
        this.mChloride = chloride;
        this.mCholesterol = cholesterol;
        this.mCopper = copper;
        this.mIodine = iodine;
        this.mVitaminB12 = vitaminB12;
        this.mZinc = zinc;
        this.mRiboflavin = riboflavin;
        this.mEnergy = energy;
        this.mMolybdenum = molybdenum;
        this.mPhosphorus = phosphorus;
        this.mChromium = chromium;
        this.mTotalFat = totalFat;
        this.mCalcium = calcium;
        this.mVitaminC = vitaminC;
        this.mVitaminE = vitaminE;
        this.mBiotin = biotin;
        this.mVitaminD = vitaminD;
        this.mNiacin = niacin;
        this.mMagnesium = magnesium;
        this.mTotalCarbohydrate = totalCarbohydrate;
        this.mVitaminK = vitaminK;
        this.mPolyunsaturatedFat = polyunsaturatedFat;
        this.mSaturatedFat = saturatedFat;
        this.mSodium = sodium;
        this.mFolate = folate;
        this.mMonounsaturatedFat = monounsaturatedFat;
        this.mPantothenicAcid = pantothenicAcid;
        this.mMealName = mealName;
        this.mIron = iron;
        this.mVitaminA = vitaminA;
        this.mFolicAcid = folicAcid;
        this.mSugar = sugar;
    }

    public int getMealType() {
        return this.mMealType;
    }

    public Mass getUnsaturatedFat() {
        return this.mUnsaturatedFat;
    }

    public Mass getPotassium() {
        return this.mPotassium;
    }

    public Mass getThiamin() {
        return this.mThiamin;
    }

    public Mass getTransFat() {
        return this.mTransFat;
    }

    public Mass getManganese() {
        return this.mManganese;
    }

    public Energy getEnergyFromFat() {
        return this.mEnergyFromFat;
    }

    public Mass getCaffeine() {
        return this.mCaffeine;
    }

    public Mass getDietaryFiber() {
        return this.mDietaryFiber;
    }

    public Mass getSelenium() {
        return this.mSelenium;
    }

    public Mass getVitaminB6() {
        return this.mVitaminB6;
    }

    public Mass getProtein() {
        return this.mProtein;
    }

    public Mass getChloride() {
        return this.mChloride;
    }

    public Mass getCholesterol() {
        return this.mCholesterol;
    }

    public Mass getCopper() {
        return this.mCopper;
    }

    public Mass getIodine() {
        return this.mIodine;
    }

    public Mass getVitaminB12() {
        return this.mVitaminB12;
    }

    public Mass getZinc() {
        return this.mZinc;
    }

    public Mass getRiboflavin() {
        return this.mRiboflavin;
    }

    public Energy getEnergy() {
        return this.mEnergy;
    }

    public Mass getMolybdenum() {
        return this.mMolybdenum;
    }

    public Mass getPhosphorus() {
        return this.mPhosphorus;
    }

    public Mass getChromium() {
        return this.mChromium;
    }

    public Mass getTotalFat() {
        return this.mTotalFat;
    }

    public Mass getCalcium() {
        return this.mCalcium;
    }

    public Mass getVitaminC() {
        return this.mVitaminC;
    }

    public Mass getVitaminE() {
        return this.mVitaminE;
    }

    public Mass getBiotin() {
        return this.mBiotin;
    }

    public Mass getVitaminD() {
        return this.mVitaminD;
    }

    public Mass getNiacin() {
        return this.mNiacin;
    }

    public Mass getMagnesium() {
        return this.mMagnesium;
    }

    public Mass getTotalCarbohydrate() {
        return this.mTotalCarbohydrate;
    }

    public Mass getVitaminK() {
        return this.mVitaminK;
    }

    public Mass getPolyunsaturatedFat() {
        return this.mPolyunsaturatedFat;
    }

    public Mass getSaturatedFat() {
        return this.mSaturatedFat;
    }

    public Mass getSodium() {
        return this.mSodium;
    }

    public Mass getFolate() {
        return this.mFolate;
    }

    public Mass getMonounsaturatedFat() {
        return this.mMonounsaturatedFat;
    }

    public Mass getPantothenicAcid() {
        return this.mPantothenicAcid;
    }

    public String getMealName() {
        return this.mMealName;
    }

    public Mass getIron() {
        return this.mIron;
    }

    public Mass getVitaminA() {
        return this.mVitaminA;
    }

    public Mass getFolicAcid() {
        return this.mFolicAcid;
    }

    public Mass getSugar() {
        return this.mSugar;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        NutritionRecord that = (NutritionRecord)o;
        return this.getMealType() == that.getMealType() && Objects.equals(this.getUnsaturatedFat(), that.getUnsaturatedFat()) && Objects.equals(this.getPotassium(), that.getPotassium()) && Objects.equals(this.getThiamin(), that.getThiamin()) && Objects.equals(this.getTransFat(), that.getTransFat()) && Objects.equals(this.getManganese(), that.getManganese()) && Objects.equals(this.getEnergyFromFat(), that.getEnergyFromFat()) && Objects.equals(this.getCaffeine(), that.getCaffeine()) && Objects.equals(this.getDietaryFiber(), that.getDietaryFiber()) && Objects.equals(this.getSelenium(), that.getSelenium()) && Objects.equals(this.getVitaminB6(), that.getVitaminB6()) && Objects.equals(this.getProtein(), that.getProtein()) && Objects.equals(this.getChloride(), that.getChloride()) && Objects.equals(this.getCholesterol(), that.getCholesterol()) && Objects.equals(this.getCopper(), that.getCopper()) && Objects.equals(this.getIodine(), that.getIodine()) && Objects.equals(this.getVitaminB12(), that.getVitaminB12()) && Objects.equals(this.getZinc(), that.getZinc()) && Objects.equals(this.getRiboflavin(), that.getRiboflavin()) && Objects.equals(this.getEnergy(), that.getEnergy()) && Objects.equals(this.getMolybdenum(), that.getMolybdenum()) && Objects.equals(this.getPhosphorus(), that.getPhosphorus()) && Objects.equals(this.getChromium(), that.getChromium()) && Objects.equals(this.getTotalFat(), that.getTotalFat()) && Objects.equals(this.getCalcium(), that.getCalcium()) && Objects.equals(this.getVitaminC(), that.getVitaminC()) && Objects.equals(this.getVitaminE(), that.getVitaminE()) && Objects.equals(this.getBiotin(), that.getBiotin()) && Objects.equals(this.getVitaminD(), that.getVitaminD()) && Objects.equals(this.getNiacin(), that.getNiacin()) && Objects.equals(this.getMagnesium(), that.getMagnesium()) && Objects.equals(this.getTotalCarbohydrate(), that.getTotalCarbohydrate()) && Objects.equals(this.getVitaminK(), that.getVitaminK()) && Objects.equals(this.getPolyunsaturatedFat(), that.getPolyunsaturatedFat()) && Objects.equals(this.getSaturatedFat(), that.getSaturatedFat()) && Objects.equals(this.getSodium(), that.getSodium()) && Objects.equals(this.getFolate(), that.getFolate()) && Objects.equals(this.getMonounsaturatedFat(), that.getMonounsaturatedFat()) && Objects.equals(this.getPantothenicAcid(), that.getPantothenicAcid()) && Objects.equals(this.getMealName(), that.getMealName()) && Objects.equals(this.getIron(), that.getIron()) && Objects.equals(this.getVitaminA(), that.getVitaminA()) && Objects.equals(this.getFolicAcid(), that.getFolicAcid()) && Objects.equals(this.getSugar(), that.getSugar());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getMealType(), this.getUnsaturatedFat(), this.getPotassium(), this.getThiamin(), this.getTransFat(), this.getManganese(), this.getEnergyFromFat(), this.getCaffeine(), this.getDietaryFiber(), this.getSelenium(), this.getVitaminB6(), this.getProtein(), this.getChloride(), this.getCholesterol(), this.getCopper(), this.getIodine(), this.getVitaminB12(), this.getZinc(), this.getRiboflavin(), this.getEnergy(), this.getMolybdenum(), this.getPhosphorus(), this.getChromium(), this.getTotalFat(), this.getCalcium(), this.getVitaminC(), this.getVitaminE(), this.getBiotin(), this.getVitaminD(), this.getNiacin(), this.getMagnesium(), this.getTotalCarbohydrate(), this.getVitaminK(), this.getPolyunsaturatedFat(), this.getSaturatedFat(), this.getSodium(), this.getFolate(), this.getMonounsaturatedFat(), this.getPantothenicAcid(), this.getMealName(), this.getIron(), this.getVitaminA(), this.getFolicAcid(), this.getSugar());
    }

    public NutritionRecordInternal toRecordInternal() {
        NutritionRecordInternal recordInternal = (NutritionRecordInternal)new NutritionRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        if (!Objects.isNull(this.getUnsaturatedFat())) {
            recordInternal.setUnsaturatedFat(this.getUnsaturatedFat().getInGrams());
        }
        if (!Objects.isNull(this.getPotassium())) {
            recordInternal.setPotassium(this.getPotassium().getInGrams());
        }
        if (!Objects.isNull(this.getThiamin())) {
            recordInternal.setThiamin(this.getThiamin().getInGrams());
        }
        recordInternal.setMealType(this.getMealType());
        if (!Objects.isNull(this.getTransFat())) {
            recordInternal.setTransFat(this.getTransFat().getInGrams());
        }
        if (!Objects.isNull(this.getManganese())) {
            recordInternal.setManganese(this.getManganese().getInGrams());
        }
        if (!Objects.isNull(this.getEnergyFromFat())) {
            recordInternal.setEnergyFromFat(this.getEnergyFromFat().getInCalories());
        }
        if (!Objects.isNull(this.getCaffeine())) {
            recordInternal.setCaffeine(this.getCaffeine().getInGrams());
        }
        if (!Objects.isNull(this.getDietaryFiber())) {
            recordInternal.setDietaryFiber(this.getDietaryFiber().getInGrams());
        }
        if (!Objects.isNull(this.getSelenium())) {
            recordInternal.setSelenium(this.getSelenium().getInGrams());
        }
        if (!Objects.isNull(this.getVitaminB6())) {
            recordInternal.setVitaminB6(this.getVitaminB6().getInGrams());
        }
        if (!Objects.isNull(this.getProtein())) {
            recordInternal.setProtein(this.getProtein().getInGrams());
        }
        if (!Objects.isNull(this.getChloride())) {
            recordInternal.setChloride(this.getChloride().getInGrams());
        }
        if (!Objects.isNull(this.getCholesterol())) {
            recordInternal.setCholesterol(this.getCholesterol().getInGrams());
        }
        if (!Objects.isNull(this.getCopper())) {
            recordInternal.setCopper(this.getCopper().getInGrams());
        }
        if (!Objects.isNull(this.getIodine())) {
            recordInternal.setIodine(this.getIodine().getInGrams());
        }
        if (!Objects.isNull(this.getVitaminB12())) {
            recordInternal.setVitaminB12(this.getVitaminB12().getInGrams());
        }
        if (!Objects.isNull(this.getZinc())) {
            recordInternal.setZinc(this.getZinc().getInGrams());
        }
        if (!Objects.isNull(this.getRiboflavin())) {
            recordInternal.setRiboflavin(this.getRiboflavin().getInGrams());
        }
        if (!Objects.isNull(this.getEnergy())) {
            recordInternal.setEnergy(this.getEnergy().getInCalories());
        }
        if (!Objects.isNull(this.getMolybdenum())) {
            recordInternal.setMolybdenum(this.getMolybdenum().getInGrams());
        }
        if (!Objects.isNull(this.getPhosphorus())) {
            recordInternal.setPhosphorus(this.getPhosphorus().getInGrams());
        }
        if (!Objects.isNull(this.getChromium())) {
            recordInternal.setChromium(this.getChromium().getInGrams());
        }
        if (!Objects.isNull(this.getTotalFat())) {
            recordInternal.setTotalFat(this.getTotalFat().getInGrams());
        }
        if (!Objects.isNull(this.getCalcium())) {
            recordInternal.setCalcium(this.getCalcium().getInGrams());
        }
        if (!Objects.isNull(this.getVitaminC())) {
            recordInternal.setVitaminC(this.getVitaminC().getInGrams());
        }
        if (!Objects.isNull(this.getVitaminE())) {
            recordInternal.setVitaminE(this.getVitaminE().getInGrams());
        }
        if (!Objects.isNull(this.getBiotin())) {
            recordInternal.setBiotin(this.getBiotin().getInGrams());
        }
        if (!Objects.isNull(this.getVitaminD())) {
            recordInternal.setVitaminD(this.getVitaminD().getInGrams());
        }
        if (!Objects.isNull(this.getNiacin())) {
            recordInternal.setNiacin(this.getNiacin().getInGrams());
        }
        if (!Objects.isNull(this.getMagnesium())) {
            recordInternal.setMagnesium(this.getMagnesium().getInGrams());
        }
        if (!Objects.isNull(this.getTotalCarbohydrate())) {
            recordInternal.setTotalCarbohydrate(this.getTotalCarbohydrate().getInGrams());
        }
        if (!Objects.isNull(this.getVitaminK())) {
            recordInternal.setVitaminK(this.getVitaminK().getInGrams());
        }
        if (!Objects.isNull(this.getPolyunsaturatedFat())) {
            recordInternal.setPolyunsaturatedFat(this.getPolyunsaturatedFat().getInGrams());
        }
        if (!Objects.isNull(this.getSaturatedFat())) {
            recordInternal.setSaturatedFat(this.getSaturatedFat().getInGrams());
        }
        if (!Objects.isNull(this.getSodium())) {
            recordInternal.setSodium(this.getSodium().getInGrams());
        }
        if (!Objects.isNull(this.getFolate())) {
            recordInternal.setFolate(this.getFolate().getInGrams());
        }
        if (!Objects.isNull(this.getMonounsaturatedFat())) {
            recordInternal.setMonounsaturatedFat(this.getMonounsaturatedFat().getInGrams());
        }
        if (!Objects.isNull(this.getPantothenicAcid())) {
            recordInternal.setPantothenicAcid(this.getPantothenicAcid().getInGrams());
        }
        if (!Objects.isNull(this.getMealName())) {
            recordInternal.setMealName(this.getMealName());
        }
        if (!Objects.isNull(this.getIron())) {
            recordInternal.setIron(this.getIron().getInGrams());
        }
        if (!Objects.isNull(this.getVitaminA())) {
            recordInternal.setVitaminA(this.getVitaminA().getInGrams());
        }
        if (!Objects.isNull(this.getFolicAcid())) {
            recordInternal.setFolicAcid(this.getFolicAcid().getInGrams());
        }
        if (!Objects.isNull(this.getSugar())) {
            recordInternal.setSugar(this.getSugar().getInGrams());
        }
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        private Mass mUnsaturatedFat;
        private Mass mPotassium;
        private Mass mThiamin;
        private int mMealType;
        private Mass mTransFat;
        private Mass mManganese;
        private Energy mEnergyFromFat;
        private Mass mCaffeine;
        private Mass mDietaryFiber;
        private Mass mSelenium;
        private Mass mVitaminB6;
        private Mass mProtein;
        private Mass mChloride;
        private Mass mCholesterol;
        private Mass mCopper;
        private Mass mIodine;
        private Mass mVitaminB12;
        private Mass mZinc;
        private Mass mRiboflavin;
        private Energy mEnergy;
        private Mass mMolybdenum;
        private Mass mPhosphorus;
        private Mass mChromium;
        private Mass mTotalFat;
        private Mass mCalcium;
        private Mass mVitaminC;
        private Mass mVitaminE;
        private Mass mBiotin;
        private Mass mVitaminD;
        private Mass mNiacin;
        private Mass mMagnesium;
        private Mass mTotalCarbohydrate;
        private Mass mVitaminK;
        private Mass mPolyunsaturatedFat;
        private Mass mSaturatedFat;
        private Mass mSodium;
        private Mass mFolate;
        private Mass mMonounsaturatedFat;
        private Mass mPantothenicAcid;
        private String mMealName;
        private Mass mIron;
        private Mass mVitaminA;
        private Mass mFolicAcid;
        private Mass mSugar;

        public Builder(Metadata metadata, Instant startTime, Instant endTime) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        public Builder setStartZoneOffset(ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        public Builder setEndZoneOffset(ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public Builder setUnsaturatedFat(Mass unsaturatedFat) {
            this.mUnsaturatedFat = unsaturatedFat;
            return this;
        }

        public Builder setPotassium(Mass potassium) {
            this.mPotassium = potassium;
            return this;
        }

        public Builder setThiamin(Mass thiamin) {
            this.mThiamin = thiamin;
            return this;
        }

        public Builder setMealType(int mealType) {
            this.mMealType = mealType;
            return this;
        }

        public Builder setTransFat(Mass transFat) {
            this.mTransFat = transFat;
            return this;
        }

        public Builder setManganese(Mass manganese) {
            this.mManganese = manganese;
            return this;
        }

        public Builder setEnergyFromFat(Energy energyFromFat) {
            this.mEnergyFromFat = energyFromFat;
            return this;
        }

        public Builder setCaffeine(Mass caffeine) {
            this.mCaffeine = caffeine;
            return this;
        }

        public Builder setDietaryFiber(Mass dietaryFiber) {
            this.mDietaryFiber = dietaryFiber;
            return this;
        }

        public Builder setSelenium(Mass selenium) {
            this.mSelenium = selenium;
            return this;
        }

        public Builder setVitaminB6(Mass vitaminB6) {
            this.mVitaminB6 = vitaminB6;
            return this;
        }

        public Builder setProtein(Mass protein) {
            this.mProtein = protein;
            return this;
        }

        public Builder setChloride(Mass chloride) {
            this.mChloride = chloride;
            return this;
        }

        public Builder setCholesterol(Mass cholesterol) {
            this.mCholesterol = cholesterol;
            return this;
        }

        public Builder setCopper(Mass copper) {
            this.mCopper = copper;
            return this;
        }

        public Builder setIodine(Mass iodine) {
            this.mIodine = iodine;
            return this;
        }

        public Builder setVitaminB12(Mass vitaminB12) {
            this.mVitaminB12 = vitaminB12;
            return this;
        }

        public Builder setZinc(Mass zinc) {
            this.mZinc = zinc;
            return this;
        }

        public Builder setRiboflavin(Mass riboflavin) {
            this.mRiboflavin = riboflavin;
            return this;
        }

        public Builder setEnergy(Energy energy) {
            this.mEnergy = energy;
            return this;
        }

        public Builder setMolybdenum(Mass molybdenum) {
            this.mMolybdenum = molybdenum;
            return this;
        }

        public Builder setPhosphorus(Mass phosphorus) {
            this.mPhosphorus = phosphorus;
            return this;
        }

        public Builder setChromium(Mass chromium) {
            this.mChromium = chromium;
            return this;
        }

        public Builder setTotalFat(Mass totalFat) {
            this.mTotalFat = totalFat;
            return this;
        }

        public Builder setCalcium(Mass calcium) {
            this.mCalcium = calcium;
            return this;
        }

        public Builder setVitaminC(Mass vitaminC) {
            this.mVitaminC = vitaminC;
            return this;
        }

        public Builder setVitaminE(Mass vitaminE) {
            this.mVitaminE = vitaminE;
            return this;
        }

        public Builder setBiotin(Mass biotin) {
            this.mBiotin = biotin;
            return this;
        }

        public Builder setVitaminD(Mass vitaminD) {
            this.mVitaminD = vitaminD;
            return this;
        }

        public Builder setNiacin(Mass niacin) {
            this.mNiacin = niacin;
            return this;
        }

        public Builder setMagnesium(Mass magnesium) {
            this.mMagnesium = magnesium;
            return this;
        }

        public Builder setTotalCarbohydrate(Mass totalCarbohydrate) {
            this.mTotalCarbohydrate = totalCarbohydrate;
            return this;
        }

        public Builder setVitaminK(Mass vitaminK) {
            this.mVitaminK = vitaminK;
            return this;
        }

        public Builder setPolyunsaturatedFat(Mass polyunsaturatedFat) {
            this.mPolyunsaturatedFat = polyunsaturatedFat;
            return this;
        }

        public Builder setSaturatedFat(Mass saturatedFat) {
            this.mSaturatedFat = saturatedFat;
            return this;
        }

        public Builder setSodium(Mass sodium) {
            this.mSodium = sodium;
            return this;
        }

        public Builder setFolate(Mass folate) {
            this.mFolate = folate;
            return this;
        }

        public Builder setMonounsaturatedFat(Mass monounsaturatedFat) {
            this.mMonounsaturatedFat = monounsaturatedFat;
            return this;
        }

        public Builder setPantothenicAcid(Mass pantothenicAcid) {
            this.mPantothenicAcid = pantothenicAcid;
            return this;
        }

        public Builder setMealName(String mealName) {
            this.mMealName = mealName;
            return this;
        }

        public Builder setIron(Mass iron) {
            this.mIron = iron;
            return this;
        }

        public Builder setVitaminA(Mass vitaminA) {
            this.mVitaminA = vitaminA;
            return this;
        }

        public Builder setFolicAcid(Mass folicAcid) {
            this.mFolicAcid = folicAcid;
            return this;
        }

        public Builder setSugar(Mass sugar) {
            this.mSugar = sugar;
            return this;
        }

        public NutritionRecord buildWithoutValidation() {
            return new NutritionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mUnsaturatedFat, this.mPotassium, this.mThiamin, this.mMealType, this.mTransFat, this.mManganese, this.mEnergyFromFat, this.mCaffeine, this.mDietaryFiber, this.mSelenium, this.mVitaminB6, this.mProtein, this.mChloride, this.mCholesterol, this.mCopper, this.mIodine, this.mVitaminB12, this.mZinc, this.mRiboflavin, this.mEnergy, this.mMolybdenum, this.mPhosphorus, this.mChromium, this.mTotalFat, this.mCalcium, this.mVitaminC, this.mVitaminE, this.mBiotin, this.mVitaminD, this.mNiacin, this.mMagnesium, this.mTotalCarbohydrate, this.mVitaminK, this.mPolyunsaturatedFat, this.mSaturatedFat, this.mSodium, this.mFolate, this.mMonounsaturatedFat, this.mPantothenicAcid, this.mMealName, this.mIron, this.mVitaminA, this.mFolicAcid, this.mSugar, true);
        }

        public NutritionRecord build() {
            return new NutritionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mUnsaturatedFat, this.mPotassium, this.mThiamin, this.mMealType, this.mTransFat, this.mManganese, this.mEnergyFromFat, this.mCaffeine, this.mDietaryFiber, this.mSelenium, this.mVitaminB6, this.mProtein, this.mChloride, this.mCholesterol, this.mCopper, this.mIodine, this.mVitaminB12, this.mZinc, this.mRiboflavin, this.mEnergy, this.mMolybdenum, this.mPhosphorus, this.mChromium, this.mTotalFat, this.mCalcium, this.mVitaminC, this.mVitaminE, this.mBiotin, this.mVitaminD, this.mNiacin, this.mMagnesium, this.mTotalCarbohydrate, this.mVitaminK, this.mPolyunsaturatedFat, this.mSaturatedFat, this.mSodium, this.mFolate, this.mMonounsaturatedFat, this.mPantothenicAcid, this.mMealName, this.mIron, this.mVitaminA, this.mFolicAcid, this.mSugar, false);
        }
    }
}

