/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.OvulationTestRecordInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=30)
public class OvulationTestRecord
extends InstantRecord {
    private final int mResult;

    private OvulationTestRecord(Metadata metadata, Instant time, ZoneOffset zoneOffset, int result, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        ValidationUtils.validateIntDefValue(result, OvulationTestResult.VALID_TYPES, OvulationTestResult.class.getSimpleName());
        this.mResult = result;
    }

    public int getResult() {
        return this.mResult;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        OvulationTestRecord that = (OvulationTestRecord)o;
        return this.getResult() == that.getResult();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getResult());
    }

    public OvulationTestRecordInternal toRecordInternal() {
        OvulationTestRecordInternal recordInternal = (OvulationTestRecordInternal)new OvulationTestRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setResult(this.mResult);
        return recordInternal;
    }

    public static class OvulationTestResult {
        public static final int RESULT_INCONCLUSIVE = 0;
        public static final int RESULT_POSITIVE = 1;
        public static final int RESULT_HIGH = 2;
        public static final int RESULT_NEGATIVE = 3;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3));

        OvulationTestResult() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface OvulationTestResults {
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final int mResult;

        public Builder(Metadata metadata, Instant time, int result) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mResult = result;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        public Builder setZoneOffset(ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public OvulationTestRecord buildWithoutValidation() {
            return new OvulationTestRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mResult, true);
        }

        public OvulationTestRecord build() {
            return new OvulationTestRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mResult, false);
        }
    }
}

