/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Power;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.PowerRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

@Identifier(recordIdentifier=13)
public class PowerRecord
extends IntervalRecord {
    private final List<PowerRecordSample> mPowerRecordSamples;
    public static final AggregationType<Power> POWER_MAX = new AggregationType<Power>(9, 0, 13, Power.class);
    public static final AggregationType<Power> POWER_MIN = new AggregationType<Power>(8, 1, 13, Power.class);
    public static final AggregationType<Power> POWER_AVG = new AggregationType<Power>(10, 2, 13, Power.class);

    private PowerRecord(Metadata metadata, Instant startTime, ZoneOffset startZoneOffset, Instant endTime, ZoneOffset endZoneOffset, List<PowerRecordSample> powerRecordSamples, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation);
        Objects.requireNonNull(powerRecordSamples);
        if (!skipValidation) {
            ValidationUtils.validateSampleStartAndEndTime(startTime, endTime, powerRecordSamples.stream().map(PowerRecordSample::getTime).toList());
        }
        this.mPowerRecordSamples = powerRecordSamples;
    }

    public List<PowerRecordSample> getSamples() {
        return this.mPowerRecordSamples;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof PowerRecord) {
            PowerRecord other = (PowerRecord)object;
            if (this.getSamples().size() != other.getSamples().size()) {
                return false;
            }
            for (int idx = 0; idx < this.getSamples().size(); ++idx) {
                if (Objects.equals(this.getSamples().get(idx).getPower(), other.getSamples().get(idx).getPower()) && this.getSamples().get(idx).getTime().toEpochMilli() == other.getSamples().get(idx).getTime().toEpochMilli()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSamples());
    }

    public PowerRecordInternal toRecordInternal() {
        PowerRecordInternal recordInternal = (PowerRecordInternal)new PowerRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        HashSet<PowerRecordInternal.PowerRecordSample> samples = new HashSet<PowerRecordInternal.PowerRecordSample>(this.getSamples().size());
        for (PowerRecordSample powerRecordSample : this.getSamples()) {
            samples.add(new PowerRecordInternal.PowerRecordSample(powerRecordSample.getPower().getInWatts(), powerRecordSample.getTime().toEpochMilli()));
        }
        recordInternal.setSamples(samples);
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        return recordInternal;
    }

    public static class PowerRecordSample {
        private final Power mPower;
        private final Instant mTime;

        public PowerRecordSample(Power power, Instant time) {
            this(power, time, false);
        }

        public PowerRecordSample(Power power, Instant time, boolean skipValidation) {
            Objects.requireNonNull(time);
            Objects.requireNonNull(power);
            if (!skipValidation) {
                ValidationUtils.requireInRange(power.getInWatts(), 0.0, 100000.0, "power");
            }
            this.mTime = time;
            this.mPower = power;
        }

        public Power getPower() {
            return this.mPower;
        }

        public Instant getTime() {
            return this.mTime;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PowerRecordSample)) {
                return false;
            }
            PowerRecordSample that = (PowerRecordSample)object;
            return Objects.equals(this.mPower, that.mPower) && this.mTime.toEpochMilli() == that.mTime.toEpochMilli();
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getPower(), this.getTime());
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<PowerRecordSample> mPowerRecordSamples;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;

        public Builder(Metadata metadata, Instant startTime, Instant endTime, List<PowerRecordSample> powerRecordSamples) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(powerRecordSamples);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mPowerRecordSamples = powerRecordSamples;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        public Builder setStartZoneOffset(ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        public Builder setEndZoneOffset(ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public PowerRecord buildWithoutValidation() {
            return new PowerRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mPowerRecordSamples, true);
        }

        public PowerRecord build() {
            return new PowerRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mPowerRecordSamples, false);
        }
    }
}

