/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.InstantRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.RespiratoryRateRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Objects;

@Identifier(recordIdentifier=31)
public class RespiratoryRateRecord
extends InstantRecord {
    private final double mRate;

    private RespiratoryRateRecord(Metadata metadata, Instant time, ZoneOffset zoneOffset, double rate, boolean skipValidation) {
        super(metadata, time, zoneOffset, skipValidation);
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(time);
        Objects.requireNonNull(zoneOffset);
        if (!skipValidation) {
            ValidationUtils.requireInRange(rate, 0.0, 1000.0, "rate");
        }
        this.mRate = rate;
    }

    public double getRate() {
        return this.mRate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        RespiratoryRateRecord that = (RespiratoryRateRecord)o;
        return Double.compare(that.getRate(), this.getRate()) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getRate());
    }

    public RespiratoryRateRecordInternal toRecordInternal() {
        RespiratoryRateRecordInternal recordInternal = (RespiratoryRateRecordInternal)new RespiratoryRateRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setTime(this.getTime().toEpochMilli());
        recordInternal.setZoneOffset(this.getZoneOffset().getTotalSeconds());
        recordInternal.setRate(this.mRate);
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mTime;
        private ZoneOffset mZoneOffset;
        private final double mRate;

        public Builder(Metadata metadata, Instant time, double rate) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(time);
            this.mMetadata = metadata;
            this.mTime = time;
            this.mRate = rate;
            this.mZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(time);
        }

        public Builder setZoneOffset(ZoneOffset zoneOffset) {
            Objects.requireNonNull(zoneOffset);
            this.mZoneOffset = zoneOffset;
            return this;
        }

        public Builder clearZoneOffset() {
            this.mZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public RespiratoryRateRecord buildWithoutValidation() {
            return new RespiratoryRateRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mRate, true);
        }

        public RespiratoryRateRecord build() {
            return new RespiratoryRateRecord(this.mMetadata, this.mTime, this.mZoneOffset, this.mRate, false);
        }
    }
}

