/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.TimeInterval;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.SleepSessionRecordInternal;
import android.health.connect.internal.datatypes.SleepStageInternal;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Identifier(recordIdentifier=38)
public class SleepSessionRecord
extends IntervalRecord {
    public static final AggregationType<Long> SLEEP_DURATION_TOTAL = new AggregationType<Long>(66, 3, 38, Long.class);
    private final List<Stage> mStages;
    private final CharSequence mNotes;
    private final CharSequence mTitle;

    private SleepSessionRecord(Metadata metadata, Instant startTime, ZoneOffset startZoneOffset, Instant endTime, ZoneOffset endZoneOffset, List<Stage> stages, CharSequence notes, CharSequence title, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation);
        Objects.requireNonNull(stages);
        this.mStages = Collections.unmodifiableList(ValidationUtils.sortAndValidateTimeIntervalHolders(startTime, endTime, stages));
        this.mNotes = notes;
        this.mTitle = title;
    }

    public CharSequence getNotes() {
        return this.mNotes;
    }

    public CharSequence getTitle() {
        return this.mTitle;
    }

    public List<Stage> getStages() {
        return this.mStages;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SleepSessionRecord)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SleepSessionRecord that = (SleepSessionRecord)o;
        return RecordUtils.isEqualNullableCharSequences(this.getNotes(), that.getNotes()) && RecordUtils.isEqualNullableCharSequences(this.getTitle(), that.getTitle()) && Objects.equals(this.getStages(), that.getStages());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getNotes(), this.getTitle(), this.getStages());
    }

    public SleepSessionRecordInternal toRecordInternal() {
        SleepSessionRecordInternal recordInternal = (SleepSessionRecordInternal)new SleepSessionRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        recordInternal.setSleepStages(this.getStages().stream().map(Stage::toInternalStage).collect(Collectors.toList()));
        if (this.getNotes() != null) {
            recordInternal.setNotes(this.getNotes().toString());
        }
        if (this.getTitle() != null) {
            recordInternal.setTitle(this.getTitle().toString());
        }
        return recordInternal;
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<Stage> mStages;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;
        private CharSequence mNotes;
        private CharSequence mTitle;

        public Builder(Metadata metadata, Instant startTime, Instant endTime) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mStages = new ArrayList<Stage>();
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        public Builder setStartZoneOffset(ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        public Builder setEndZoneOffset(ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public Builder setNotes(CharSequence notes) {
            this.mNotes = notes;
            return this;
        }

        public Builder setTitle(CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setStages(List<Stage> stages) {
            Objects.requireNonNull(stages);
            this.mStages.clear();
            this.mStages.addAll(stages);
            return this;
        }

        public SleepSessionRecord buildWithoutValidation() {
            return new SleepSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mStages, this.mNotes, this.mTitle, true);
        }

        public SleepSessionRecord build() {
            return new SleepSessionRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mStages, this.mNotes, this.mTitle, false);
        }
    }

    public static class StageType {
        public static final int STAGE_TYPE_UNKNOWN = 0;
        public static final int STAGE_TYPE_AWAKE = 1;
        public static final int STAGE_TYPE_SLEEPING = 2;
        public static final int STAGE_TYPE_AWAKE_OUT_OF_BED = 3;
        public static final int STAGE_TYPE_SLEEPING_LIGHT = 4;
        public static final int STAGE_TYPE_SLEEPING_DEEP = 5;
        public static final int STAGE_TYPE_SLEEPING_REM = 6;
        public static final int STAGE_TYPE_AWAKE_IN_BED = 7;
        public static final Set<Integer> VALID_TYPES = Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(6), Integer.valueOf(7));
        public static final List<Integer> DURATION_EXCLUDE_TYPES = List.of(Integer.valueOf(1), Integer.valueOf(3), Integer.valueOf(7));

        private StageType() {
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface StageTypes {
        }
    }

    public static class Stage
    implements TimeInterval.TimeIntervalHolder {
        private final TimeInterval mInterval;
        private final int mStageType;

        public Stage(Instant startTime, Instant endTime, int stageType) {
            ValidationUtils.validateIntDefValue(stageType, StageType.VALID_TYPES, StageType.class.getSimpleName());
            this.mInterval = new TimeInterval(startTime, endTime);
            this.mStageType = stageType;
        }

        public Instant getStartTime() {
            return this.mInterval.getStartTime();
        }

        public Instant getEndTime() {
            return this.mInterval.getEndTime();
        }

        public int getType() {
            return this.mStageType;
        }

        @Override
        public TimeInterval getInterval() {
            return this.mInterval;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Stage)) {
                return false;
            }
            Stage that = (Stage)o;
            return this.getType() == that.getType() && this.getStartTime().toEpochMilli() == that.getStartTime().toEpochMilli() && this.getEndTime().toEpochMilli() == that.getEndTime().toEpochMilli();
        }

        public int hashCode() {
            return Objects.hash(this.getStartTime(), this.getEndTime(), this.mStageType);
        }

        public SleepStageInternal toInternalStage() {
            return new SleepStageInternal().setStartTime(this.getStartTime().toEpochMilli()).setEndTime(this.getEndTime().toEpochMilli()).setStageType(this.getType());
        }
    }
}

