/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.units.Velocity;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.SpeedRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

@Identifier(recordIdentifier=14)
public class SpeedRecord
extends IntervalRecord {
    private final List<SpeedRecordSample> mSpeedRecordSamples;

    private SpeedRecord(Metadata metadata, Instant startTime, ZoneOffset startZoneOffset, Instant endTime, ZoneOffset endZoneOffset, List<SpeedRecordSample> speedRecordSamples, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation);
        Objects.requireNonNull(speedRecordSamples);
        if (!skipValidation) {
            ValidationUtils.validateSampleStartAndEndTime(startTime, endTime, speedRecordSamples.stream().map(SpeedRecordSample::getTime).toList());
        }
        this.mSpeedRecordSamples = speedRecordSamples;
    }

    public List<SpeedRecordSample> getSamples() {
        return this.mSpeedRecordSamples;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof SpeedRecord) {
            SpeedRecord other = (SpeedRecord)object;
            if (this.getSamples().size() != other.getSamples().size()) {
                return false;
            }
            for (int idx = 0; idx < this.getSamples().size(); ++idx) {
                if (Objects.equals(this.getSamples().get(idx).getSpeed(), other.getSamples().get(idx).getSpeed()) && this.getSamples().get(idx).getTime().toEpochMilli() == other.getSamples().get(idx).getTime().toEpochMilli()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSamples());
    }

    public SpeedRecordInternal toRecordInternal() {
        SpeedRecordInternal recordInternal = (SpeedRecordInternal)new SpeedRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        HashSet<SpeedRecordInternal.SpeedRecordSample> samples = new HashSet<SpeedRecordInternal.SpeedRecordSample>(this.getSamples().size());
        for (SpeedRecordSample speedRecordSample : this.getSamples()) {
            samples.add(new SpeedRecordInternal.SpeedRecordSample(speedRecordSample.getSpeed().getInMetersPerSecond(), speedRecordSample.getTime().toEpochMilli()));
        }
        recordInternal.setSamples(samples);
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        return recordInternal;
    }

    public static class SpeedRecordSample {
        private final Velocity mSpeed;
        private final Instant mTime;

        public SpeedRecordSample(Velocity speed, Instant time) {
            this(speed, time, false);
        }

        public SpeedRecordSample(Velocity speed, Instant time, boolean skipValidation) {
            Objects.requireNonNull(time);
            Objects.requireNonNull(speed);
            if (!skipValidation) {
                ValidationUtils.requireInRange(speed.getInMetersPerSecond(), 0.0, 1000000.0, "speed");
            }
            this.mTime = time;
            this.mSpeed = speed;
        }

        public Velocity getSpeed() {
            return this.mSpeed;
        }

        public Instant getTime() {
            return this.mTime;
        }

        public boolean equals(Object object) {
            if (super.equals(object) && object instanceof SpeedRecordSample) {
                SpeedRecordSample other = (SpeedRecordSample)object;
                return this.getSpeed().equals(other.getSpeed()) && this.getTime().toEpochMilli() == other.getTime().toEpochMilli();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getSpeed(), this.getTime());
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<SpeedRecordSample> mSpeedRecordSamples;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;

        public Builder(Metadata metadata, Instant startTime, Instant endTime, List<SpeedRecordSample> speedRecordSamples) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(speedRecordSamples);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mSpeedRecordSamples = speedRecordSamples;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        public Builder setStartZoneOffset(ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        public Builder setEndZoneOffset(ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public SpeedRecord buildWithoutValidation() {
            return new SpeedRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSpeedRecordSamples, true);
        }

        public SpeedRecord build() {
            return new SpeedRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mSpeedRecordSamples, false);
        }
    }
}

