/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.RecordUtils;
import android.health.connect.datatypes.validation.ValidationUtils;
import android.health.connect.internal.datatypes.StepsCadenceRecordInternal;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

@Identifier(recordIdentifier=15)
public class StepsCadenceRecord
extends IntervalRecord {
    private final List<StepsCadenceRecordSample> mStepsCadenceRecordSamples;

    private StepsCadenceRecord(Metadata metadata, Instant startTime, ZoneOffset startZoneOffset, Instant endTime, ZoneOffset endZoneOffset, List<StepsCadenceRecordSample> stepsCadenceRecordSamples, boolean skipValidation) {
        super(metadata, startTime, startZoneOffset, endTime, endZoneOffset, skipValidation);
        Objects.requireNonNull(stepsCadenceRecordSamples);
        if (!skipValidation) {
            ValidationUtils.validateSampleStartAndEndTime(startTime, endTime, stepsCadenceRecordSamples.stream().map(StepsCadenceRecordSample::getTime).toList());
        }
        this.mStepsCadenceRecordSamples = stepsCadenceRecordSamples;
    }

    public List<StepsCadenceRecordSample> getSamples() {
        return this.mStepsCadenceRecordSamples;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object) && object instanceof StepsCadenceRecord) {
            StepsCadenceRecord other = (StepsCadenceRecord)object;
            if (this.getSamples().size() != other.getSamples().size()) {
                return false;
            }
            for (int idx = 0; idx < this.getSamples().size(); ++idx) {
                if (this.getSamples().get(idx).getRate() == other.getSamples().get(idx).getRate() && this.getSamples().get(idx).getTime().toEpochMilli() == other.getSamples().get(idx).getTime().toEpochMilli()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getSamples());
    }

    public StepsCadenceRecordInternal toRecordInternal() {
        StepsCadenceRecordInternal recordInternal = (StepsCadenceRecordInternal)new StepsCadenceRecordInternal().setUuid(this.getMetadata().getId()).setPackageName(this.getMetadata().getDataOrigin().getPackageName()).setLastModifiedTime(this.getMetadata().getLastModifiedTime().toEpochMilli()).setClientRecordId(this.getMetadata().getClientRecordId()).setClientRecordVersion(this.getMetadata().getClientRecordVersion()).setManufacturer(this.getMetadata().getDevice().getManufacturer()).setModel(this.getMetadata().getDevice().getModel()).setDeviceType(this.getMetadata().getDevice().getType()).setRecordingMethod(this.getMetadata().getRecordingMethod());
        HashSet<StepsCadenceRecordInternal.StepsCadenceRecordSample> samples = new HashSet<StepsCadenceRecordInternal.StepsCadenceRecordSample>(this.getSamples().size());
        for (StepsCadenceRecordSample stepsCadenceRecordSample : this.getSamples()) {
            samples.add(new StepsCadenceRecordInternal.StepsCadenceRecordSample(stepsCadenceRecordSample.getRate(), stepsCadenceRecordSample.getTime().toEpochMilli()));
        }
        recordInternal.setSamples(samples);
        recordInternal.setStartTime(this.getStartTime().toEpochMilli());
        recordInternal.setEndTime(this.getEndTime().toEpochMilli());
        recordInternal.setStartZoneOffset(this.getStartZoneOffset().getTotalSeconds());
        recordInternal.setEndZoneOffset(this.getEndZoneOffset().getTotalSeconds());
        return recordInternal;
    }

    public static class StepsCadenceRecordSample {
        private final double mRate;
        private final Instant mTime;

        public StepsCadenceRecordSample(double rate, Instant time) {
            this(rate, time, false);
        }

        public StepsCadenceRecordSample(double rate, Instant time, boolean skipValidation) {
            Objects.requireNonNull(time);
            if (!skipValidation) {
                ValidationUtils.requireInRange(rate, 0.0, 10000.0, "rate");
            }
            this.mTime = time;
            this.mRate = rate;
        }

        public double getRate() {
            return this.mRate;
        }

        public Instant getTime() {
            return this.mTime;
        }

        public boolean equals(Object object) {
            if (super.equals(object) && object instanceof StepsCadenceRecordSample) {
                StepsCadenceRecordSample other = (StepsCadenceRecordSample)object;
                return this.getRate() == other.getRate() && this.getTime().toEpochMilli() == other.getTime().toEpochMilli();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.getRate(), this.getTime());
        }
    }

    public static class Builder {
        private final Metadata mMetadata;
        private final Instant mStartTime;
        private final Instant mEndTime;
        private final List<StepsCadenceRecordSample> mStepsCadenceRecordSamples;
        private ZoneOffset mStartZoneOffset;
        private ZoneOffset mEndZoneOffset;

        public Builder(Metadata metadata, Instant startTime, Instant endTime, List<StepsCadenceRecordSample> stepsCadenceRecordSamples) {
            Objects.requireNonNull(metadata);
            Objects.requireNonNull(startTime);
            Objects.requireNonNull(endTime);
            Objects.requireNonNull(stepsCadenceRecordSamples);
            this.mMetadata = metadata;
            this.mStartTime = startTime;
            this.mEndTime = endTime;
            this.mStepsCadenceRecordSamples = stepsCadenceRecordSamples;
            this.mStartZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(startTime);
            this.mEndZoneOffset = ZoneOffset.systemDefault().getRules().getOffset(endTime);
        }

        public Builder setStartZoneOffset(ZoneOffset startZoneOffset) {
            Objects.requireNonNull(startZoneOffset);
            this.mStartZoneOffset = startZoneOffset;
            return this;
        }

        public Builder setEndZoneOffset(ZoneOffset endZoneOffset) {
            Objects.requireNonNull(endZoneOffset);
            this.mEndZoneOffset = endZoneOffset;
            return this;
        }

        public Builder clearStartZoneOffset() {
            this.mStartZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public Builder clearEndZoneOffset() {
            this.mEndZoneOffset = RecordUtils.getDefaultZoneOffset();
            return this;
        }

        public StepsCadenceRecord buildWithoutValidation() {
            return new StepsCadenceRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mStepsCadenceRecordSamples, true);
        }

        public StepsCadenceRecord build() {
            return new StepsCadenceRecord(this.mMetadata, this.mStartTime, this.mStartZoneOffset, this.mEndTime, this.mEndZoneOffset, this.mStepsCadenceRecordSamples, false);
        }
    }
}

