/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.datatypes.validation;

import android.health.connect.datatypes.TimeInterval;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class ValidationUtils {
    public static final String INTDEF_VALIDATION_ERROR_PREFIX = "Unknown Intdef value";

    public static void requireInRange(long value, long lowerBound, long upperBound, String name) {
        if (value < lowerBound) {
            throw new IllegalArgumentException(name + " must not be less than " + lowerBound + ", currently " + value);
        }
        if (value > upperBound) {
            throw new IllegalArgumentException(name + " must not be more than " + upperBound + ", currently " + value);
        }
    }

    public static void requireNonNegative(double value, String name) {
        if (value < 0.0) {
            throw new IllegalArgumentException(name + "must be non-negative, currently " + value);
        }
    }

    public static void requireInRange(double value, double lowerBound, double upperBound, String name) {
        if (value < lowerBound) {
            throw new IllegalArgumentException(name + " must not be less than " + lowerBound + ", currently " + value);
        }
        if (value > upperBound) {
            throw new IllegalArgumentException(name + " must not be more than " + upperBound + ", currently " + value);
        }
    }

    public static void validateIntDefValue(int value, Set<Integer> allowedValues, String name) {
        if (!allowedValues.contains(value)) {
            throw new IllegalArgumentException("Unknown Intdef value: " + value + " for Intdef: " + name + ".");
        }
    }

    public static void validateSampleStartAndEndTime(Instant sessionStartTime, Instant sessionEndTime, List<Instant> timeInstants) {
        if (timeInstants.size() > 0) {
            Instant minTime = timeInstants.get(0);
            Instant maxTime = timeInstants.get(0);
            for (Instant instant : timeInstants) {
                if (instant.isBefore(minTime)) {
                    minTime = instant;
                }
                if (!instant.isAfter(maxTime)) continue;
                maxTime = instant;
            }
            if (minTime.isBefore(sessionStartTime) || maxTime.isAfter(sessionEndTime)) {
                throw new IllegalArgumentException("Time instant values must be within session interval");
            }
        }
    }

    public static <T extends Comparable<T>> void requireInRangeIfExists(Comparable<T> value, T threshold, T limit, String name) {
        if (value != null && value.compareTo(threshold) < 0) {
            throw new IllegalArgumentException(name + " must not be less than " + threshold + ", currently " + value);
        }
        if (value != null && value.compareTo(limit) > 0) {
            throw new IllegalArgumentException(name + " must not be more than " + limit + ", currently " + value);
        }
    }

    public static List<? extends TimeInterval.TimeIntervalHolder> sortAndValidateTimeIntervalHolders(Instant parentStartTime, Instant parentEndTime, List<? extends TimeInterval.TimeIntervalHolder> intervalHolders) {
        if (intervalHolders.isEmpty()) {
            return intervalHolders;
        }
        String intervalsName = intervalHolders.get(0).getClass().getSimpleName();
        intervalHolders.sort(Comparator.comparing(TimeInterval.TimeIntervalHolder::getInterval));
        for (int i = 0; i < intervalHolders.size(); ++i) {
            TimeInterval previousInterval;
            TimeInterval currentInterval = intervalHolders.get(i).getInterval();
            if (currentInterval.getStartTime().isBefore(parentStartTime) || currentInterval.getEndTime().isAfter(parentEndTime)) {
                throw new IllegalArgumentException(intervalsName + ": time intervals must be within parent session time interval.");
            }
            if (i == 0 || !(previousInterval = intervalHolders.get(i - 1).getInterval()).getEndTime().isAfter(currentInterval.getStartTime())) continue;
            throw new IllegalArgumentException(intervalsName + ": time intervals must not overlap.");
        }
        return intervalHolders;
    }
}

