/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal;

import android.os.IBinder;
import android.os.Parcel;
import android.os.SharedMemory;
import android.system.ErrnoException;
import com.android.internal.annotations.VisibleForTesting;
import java.nio.ByteBuffer;

public class ParcelUtils {
    @VisibleForTesting
    public static final int USING_SHARED_MEMORY = 0;
    @VisibleForTesting
    public static final int USING_PARCEL = 1;
    @VisibleForTesting
    public static final int IPC_PARCEL_LIMIT = IBinder.getSuggestedMaxIpcSizeBytes() / 2;

    public static Parcel getParcelForSharedMemoryIfRequired(Parcel in) {
        int parcelType = in.readInt();
        if (parcelType == 0) {
            SharedMemory memory = SharedMemory.CREATOR.createFromParcel(in);
            try {
                Parcel dataParcel = Parcel.obtain();
                ByteBuffer buffer = memory.mapReadOnly();
                byte[] payload = new byte[buffer.limit()];
                buffer.get(payload);
                dataParcel.unmarshall(payload, 0, payload.length);
                dataParcel.setDataPosition(0);
                Parcel parcel = dataParcel;
                if (memory != null) {
                    memory.close();
                }
                return parcel;
            }
            catch (Throwable throwable) {
                try {
                    if (memory != null) {
                        try {
                            memory.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ErrnoException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return in;
    }

    public static SharedMemory getSharedMemoryForParcel(Parcel dataParcel, int dataParcelSize) {
        try {
            SharedMemory sharedMemory = SharedMemory.create("RecordsParcelSharedMemory", dataParcelSize);
            ByteBuffer buffer = sharedMemory.mapReadWrite();
            byte[] data = dataParcel.marshall();
            buffer.put(data, 0, dataParcelSize);
            return sharedMemory;
        }
        catch (ErrnoException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putToRequiredMemory(Parcel dest, int flags, IPutToParcelRunnable parcelRunnable) {
        Parcel dataParcel = Parcel.obtain();
        try {
            parcelRunnable.writeToParcel(dataParcel);
            int dataParcelSize = dataParcel.dataSize();
            if (dataParcelSize > IPC_PARCEL_LIMIT) {
                SharedMemory sharedMemory = ParcelUtils.getSharedMemoryForParcel(dataParcel, dataParcelSize);
                dest.writeInt(0);
                sharedMemory.writeToParcel(dest, flags);
            } else {
                dest.writeInt(1);
                parcelRunnable.writeToParcel(dest);
            }
        }
        finally {
            dataParcel.recycle();
        }
    }

    public static interface IPutToParcelRunnable {
        public void writeToParcel(Parcel var1);
    }
}

