/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.health.connect.datatypes.ExerciseLap;
import android.health.connect.datatypes.units.Length;
import android.os.Parcel;
import com.android.internal.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExerciseLapInternal {
    private long mStartTime;
    private long mEndTime;
    private double mLength;

    @VisibleForTesting
    public static ExerciseLapInternal readFromParcel(Parcel parcel) {
        return new ExerciseLapInternal().setStarTime(parcel.readLong()).setEndTime(parcel.readLong()).setLength(parcel.readDouble());
    }

    static void writeLapsToParcel(List<ExerciseLapInternal> laps, Parcel parcel) {
        if (laps == null) {
            parcel.writeInt(0);
            return;
        }
        parcel.writeInt(laps.size());
        for (ExerciseLapInternal lap : laps) {
            lap.writeToParcel(parcel);
        }
    }

    static List<ExerciseLap> getExternalLaps(List<ExerciseLapInternal> internalLaps) {
        ArrayList<ExerciseLap> externalLaps = new ArrayList<ExerciseLap>(internalLaps.size());
        internalLaps.forEach(lap -> externalLaps.add(lap.toExternalRecord()));
        return externalLaps;
    }

    static List<ExerciseLapInternal> populateLapsFromParcel(Parcel parcel) {
        int lapsSize = parcel.readInt();
        if (lapsSize == 0) {
            return null;
        }
        ArrayList<ExerciseLapInternal> laps = new ArrayList<ExerciseLapInternal>(lapsSize);
        for (int i = 0; i < lapsSize; ++i) {
            laps.add(ExerciseLapInternal.readFromParcel(parcel));
        }
        return laps;
    }

    @VisibleForTesting
    public void writeToParcel(Parcel parcel) {
        parcel.writeLong(this.mStartTime);
        parcel.writeLong(this.mEndTime);
        parcel.writeDouble(this.mLength);
    }

    @VisibleForTesting
    public ExerciseLap toExternalRecord() {
        ExerciseLap.Builder builder = new ExerciseLap.Builder(Instant.ofEpochMilli(this.getStartTime()), Instant.ofEpochMilli(this.getEndTime()));
        if (this.getLength() != 0.0) {
            builder.setLength(Length.fromMeters(this.getLength()));
        }
        return builder.buildWithoutValidation();
    }

    public double getLength() {
        return this.mLength;
    }

    public ExerciseLapInternal setLength(double lengthInMeters) {
        this.mLength = lengthInMeters;
        return this;
    }

    public ExerciseLapInternal setStarTime(long startTime) {
        this.mStartTime = startTime;
        return this;
    }

    public ExerciseLapInternal setEndTime(long endTime) {
        this.mEndTime = endTime;
        return this;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExerciseLapInternal)) {
            return false;
        }
        ExerciseLapInternal that = (ExerciseLapInternal)o;
        return this.mStartTime == that.mStartTime && this.mEndTime == that.mEndTime && this.mLength == that.mLength;
    }

    public int hashCode() {
        return Objects.hash(this.mStartTime, this.mEndTime, this.mLength);
    }
}

