/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.health.connect.datatypes.ExerciseRoute;
import android.health.connect.datatypes.units.Length;
import android.os.Parcel;
import com.android.internal.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExerciseRouteInternal {
    private final List<LocationInternal> mRouteExerciseRouteLocations;

    public ExerciseRouteInternal(List<LocationInternal> routeExerciseRouteLocations) {
        Objects.requireNonNull(routeExerciseRouteLocations);
        this.mRouteExerciseRouteLocations = new ArrayList<LocationInternal>(routeExerciseRouteLocations);
    }

    public List<LocationInternal> getRouteLocations() {
        return this.mRouteExerciseRouteLocations;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static ExerciseRouteInternal readFromParcel(Parcel parcel) {
        boolean routeIsNull = parcel.readBoolean();
        if (routeIsNull) {
            return null;
        }
        int routeSize = parcel.readInt();
        ArrayList<LocationInternal> routeLocations = new ArrayList<LocationInternal>(routeSize);
        for (int i = 0; i < routeSize; ++i) {
            routeLocations.add(LocationInternal.readFromParcel(parcel));
        }
        return new ExerciseRouteInternal(routeLocations);
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PACKAGE)
    public static void writeToParcel(ExerciseRouteInternal route, Parcel parcel) {
        if (route == null) {
            parcel.writeBoolean(true);
        } else {
            parcel.writeBoolean(false);
            route.writeToParcel(parcel);
        }
    }

    private void writeToParcel(Parcel parcel) {
        parcel.writeInt(this.mRouteExerciseRouteLocations.size());
        for (LocationInternal location : this.mRouteExerciseRouteLocations) {
            location.writeToParcel(parcel);
        }
    }

    @VisibleForTesting
    public ExerciseRoute toExternalRoute() {
        ArrayList<ExerciseRoute.Location> routeLocations = new ArrayList<ExerciseRoute.Location>(this.mRouteExerciseRouteLocations.size());
        for (LocationInternal location : this.mRouteExerciseRouteLocations) {
            routeLocations.add(location.toExternalExerciseRouteLocation());
        }
        return new ExerciseRoute(routeLocations);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExerciseRouteInternal)) {
            return false;
        }
        ExerciseRouteInternal that = (ExerciseRouteInternal)o;
        return this.getRouteLocations().equals(that.getRouteLocations());
    }

    void addLocation(LocationInternal location) {
        this.mRouteExerciseRouteLocations.add(location);
    }

    public int hashCode() {
        return Objects.hash(this.mRouteExerciseRouteLocations);
    }

    public static class LocationInternal {
        private long mTime = -1L;
        private double mLatitude = Double.MIN_VALUE;
        private double mLongitude = Double.MIN_VALUE;
        private double mHorizontalAccuracy = Double.MIN_VALUE;
        private double mVerticalAccuracy = Double.MIN_VALUE;
        private double mAltitude = Double.MIN_VALUE;

        public long getTime() {
            return this.mTime;
        }

        public LocationInternal setTime(long time) {
            this.mTime = time;
            return this;
        }

        public double getLongitude() {
            return this.mLongitude;
        }

        public LocationInternal setLongitude(double longitude) {
            this.mLongitude = longitude;
            return this;
        }

        public double getLatitude() {
            return this.mLatitude;
        }

        public LocationInternal setLatitude(double latitude) {
            this.mLatitude = latitude;
            return this;
        }

        public double getHorizontalAccuracy() {
            return this.mHorizontalAccuracy;
        }

        public LocationInternal setHorizontalAccuracy(double horizontalAccuracy) {
            this.mHorizontalAccuracy = horizontalAccuracy;
            return this;
        }

        public double getVerticalAccuracy() {
            return this.mVerticalAccuracy;
        }

        public LocationInternal setVerticalAccuracy(double verticalAccuracy) {
            this.mVerticalAccuracy = verticalAccuracy;
            return this;
        }

        public double getAltitude() {
            return this.mAltitude;
        }

        public LocationInternal setAltitude(double altitude) {
            this.mAltitude = altitude;
            return this;
        }

        @VisibleForTesting
        public static LocationInternal readFromParcel(Parcel parcel) {
            return new LocationInternal().setTime(parcel.readLong()).setLatitude(parcel.readDouble()).setLongitude(parcel.readDouble()).setHorizontalAccuracy(parcel.readDouble()).setVerticalAccuracy(parcel.readDouble()).setAltitude(parcel.readDouble());
        }

        @VisibleForTesting
        public void writeToParcel(Parcel parcel) {
            parcel.writeLong(this.getTime());
            parcel.writeDouble(this.getLatitude());
            parcel.writeDouble(this.getLongitude());
            parcel.writeDouble(this.getHorizontalAccuracy());
            parcel.writeDouble(this.getVerticalAccuracy());
            parcel.writeDouble(this.getAltitude());
        }

        @VisibleForTesting
        public ExerciseRoute.Location toExternalExerciseRouteLocation() {
            ExerciseRoute.Location.Builder builder = new ExerciseRoute.Location.Builder(Instant.ofEpochMilli(this.getTime()), this.getLatitude(), this.getLongitude());
            if (this.getHorizontalAccuracy() != Double.MIN_VALUE) {
                builder.setHorizontalAccuracy(Length.fromMeters(this.getHorizontalAccuracy()));
            }
            if (this.getVerticalAccuracy() != Double.MIN_VALUE) {
                builder.setVerticalAccuracy(Length.fromMeters(this.getVerticalAccuracy()));
            }
            if (this.getAltitude() != Double.MIN_VALUE) {
                builder.setAltitude(Length.fromMeters(this.getAltitude()));
            }
            return builder.buildWithoutValidation();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LocationInternal)) {
                return false;
            }
            LocationInternal that = (LocationInternal)o;
            return this.getLatitude() == that.getLatitude() && this.getLongitude() == that.getLongitude() && this.getTime() == that.getTime() && this.getHorizontalAccuracy() == that.getHorizontalAccuracy() && this.getVerticalAccuracy() == that.getVerticalAccuracy() && this.getAltitude() == that.getAltitude();
        }

        public int hashCode() {
            return Objects.hash(this.getTime(), this.getLatitude(), this.getLongitude(), this.getHorizontalAccuracy(), this.getVerticalAccuracy(), this.getAltitude());
        }
    }
}

