/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.health.connect.datatypes.ExerciseSegment;
import android.os.Parcel;
import com.android.internal.annotations.VisibleForTesting;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class ExerciseSegmentInternal {
    private long mStartTime;
    private long mEndTime;
    private int mSegmentType;
    private int mRepetitionsCount;

    @VisibleForTesting
    public static ExerciseSegmentInternal readFromParcel(Parcel parcel) {
        return new ExerciseSegmentInternal().setStarTime(parcel.readLong()).setEndTime(parcel.readLong()).setRepetitionsCount(parcel.readInt()).setSegmentType(parcel.readInt());
    }

    static List<ExerciseSegmentInternal> populateSegmentsFromParcel(Parcel parcel) {
        int size = parcel.readInt();
        if (size == 0) {
            return null;
        }
        ArrayList<ExerciseSegmentInternal> segments = new ArrayList<ExerciseSegmentInternal>(size);
        for (int i = 0; i < size; ++i) {
            segments.add(ExerciseSegmentInternal.readFromParcel(parcel));
        }
        return segments;
    }

    static List<ExerciseSegment> getExternalSegments(List<ExerciseSegmentInternal> internalSegments) {
        ArrayList<ExerciseSegment> externalSegments = new ArrayList<ExerciseSegment>(internalSegments.size());
        internalSegments.forEach(segment -> externalSegments.add(segment.toExternalRecord()));
        return externalSegments;
    }

    static void writeSegmentsToParcel(List<ExerciseSegmentInternal> segments, Parcel parcel) {
        if (segments == null) {
            parcel.writeInt(0);
            return;
        }
        parcel.writeInt(segments.size());
        segments.forEach(segment -> segment.writeToParcel(parcel));
    }

    @VisibleForTesting
    public void writeToParcel(Parcel parcel) {
        parcel.writeLong(this.mStartTime);
        parcel.writeLong(this.mEndTime);
        parcel.writeInt(this.mRepetitionsCount);
        parcel.writeInt(this.mSegmentType);
    }

    @VisibleForTesting
    public ExerciseSegment toExternalRecord() {
        return new ExerciseSegment.Builder(Instant.ofEpochMilli(this.getStartTime()), Instant.ofEpochMilli(this.getEndTime()), this.getSegmentType()).setRepetitionsCount(this.getRepetitionsCount()).buildWithoutValidation();
    }

    public ExerciseSegmentInternal setStarTime(long startTime) {
        this.mStartTime = startTime;
        return this;
    }

    public ExerciseSegmentInternal setEndTime(long endTime) {
        this.mEndTime = endTime;
        return this;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public long getEndTime() {
        return this.mEndTime;
    }

    public int getRepetitionsCount() {
        return this.mRepetitionsCount;
    }

    public ExerciseSegmentInternal setRepetitionsCount(int repetitionsCount) {
        this.mRepetitionsCount = repetitionsCount;
        return this;
    }

    public int getSegmentType() {
        return this.mSegmentType;
    }

    public ExerciseSegmentInternal setSegmentType(int segmentType) {
        this.mSegmentType = segmentType;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExerciseSegmentInternal)) {
            return false;
        }
        ExerciseSegmentInternal that = (ExerciseSegmentInternal)o;
        return this.mSegmentType == that.mSegmentType && this.mRepetitionsCount == that.mRepetitionsCount && this.mStartTime == that.mStartTime && this.mEndTime == that.mEndTime;
    }

    public int hashCode() {
        return Objects.hash(this.mStartTime, this.mEndTime, this.mSegmentType, this.mRepetitionsCount);
    }
}

