/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.health.connect.datatypes.ExerciseSessionRecord;
import android.health.connect.datatypes.Identifier;
import android.health.connect.internal.datatypes.ExerciseLapInternal;
import android.health.connect.internal.datatypes.ExerciseRouteInternal;
import android.health.connect.internal.datatypes.ExerciseSegmentInternal;
import android.health.connect.internal.datatypes.IntervalRecordInternal;
import android.os.Parcel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Identifier(recordIdentifier=37)
public class ExerciseSessionRecordInternal
extends IntervalRecordInternal<ExerciseSessionRecord> {
    private String mNotes;
    private int mExerciseType;
    private String mTitle;
    private ExerciseRouteInternal mExerciseRoute;
    private List<ExerciseLapInternal> mExerciseLaps;
    private List<ExerciseSegmentInternal> mExerciseSegments;
    private boolean mHasRoute;

    public String getNotes() {
        return this.mNotes;
    }

    public ExerciseSessionRecordInternal setNotes(String notes) {
        this.mNotes = notes;
        return this;
    }

    public int getExerciseType() {
        return this.mExerciseType;
    }

    public ExerciseSessionRecordInternal setExerciseType(int exerciseType) {
        this.mExerciseType = exerciseType;
        return this;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public ExerciseSessionRecordInternal setTitle(String title) {
        this.mTitle = title;
        return this;
    }

    public ExerciseRouteInternal getRoute() {
        return this.mExerciseRoute;
    }

    public ExerciseSessionRecordInternal setRoute(ExerciseRouteInternal route) {
        this.mExerciseRoute = route;
        if (route != null) {
            this.mHasRoute = true;
        }
        return this;
    }

    public boolean hasRoute() {
        return this.mHasRoute;
    }

    public ExerciseSessionRecordInternal setHasRoute(boolean hasRoute) {
        if (this.mExerciseRoute != null && !hasRoute) {
            throw new IllegalArgumentException("HasRoute must be true if the route is not null");
        }
        this.mHasRoute = hasRoute;
        return this;
    }

    public List<ExerciseLapInternal> getLaps() {
        return this.mExerciseLaps;
    }

    public ExerciseSessionRecordInternal setExerciseLaps(List<ExerciseLapInternal> exerciseLaps) {
        Objects.requireNonNull(exerciseLaps);
        this.mExerciseLaps = new ArrayList<ExerciseLapInternal>(exerciseLaps);
        return this;
    }

    public List<ExerciseSegmentInternal> getSegments() {
        return this.mExerciseSegments;
    }

    public ExerciseSessionRecordInternal setExerciseSegments(List<ExerciseSegmentInternal> exerciseSegments) {
        Objects.requireNonNull(exerciseSegments);
        this.mExerciseSegments = new ArrayList<ExerciseSegmentInternal>(exerciseSegments);
        return this;
    }

    @Override
    public ExerciseSessionRecord toExternalRecord() {
        ExerciseSessionRecord.Builder builder = new ExerciseSessionRecord.Builder(this.buildMetaData(), this.getStartTime(), this.getEndTime(), this.getExerciseType());
        if (this.getStartZoneOffset() != null) {
            builder.setStartZoneOffset(this.getStartZoneOffset());
        }
        if (this.getEndZoneOffset() != null) {
            builder.setEndZoneOffset(this.getEndZoneOffset());
        }
        if (this.getNotes() != null) {
            builder.setNotes(this.getNotes());
        }
        if (this.getTitle() != null) {
            builder.setTitle(this.getTitle());
        }
        if (this.mExerciseRoute != null) {
            builder.setRoute(this.mExerciseRoute.toExternalRoute());
        }
        builder.setHasRoute(this.mHasRoute);
        if (this.getLaps() != null) {
            builder.setLaps(ExerciseLapInternal.getExternalLaps(this.mExerciseLaps));
        }
        if (this.getSegments() != null) {
            builder.setSegments(ExerciseSegmentInternal.getExternalSegments(this.mExerciseSegments));
        }
        return builder.buildWithoutValidation();
    }

    @Override
    public void populateIntervalRecordTo(Parcel parcel) {
        parcel.writeString(this.mNotes);
        parcel.writeInt(this.mExerciseType);
        parcel.writeString(this.mTitle);
        parcel.writeBoolean(this.mHasRoute);
        ExerciseRouteInternal.writeToParcel(this.mExerciseRoute, parcel);
        ExerciseLapInternal.writeLapsToParcel(this.mExerciseLaps, parcel);
        ExerciseSegmentInternal.writeSegmentsToParcel(this.mExerciseSegments, parcel);
    }

    @Override
    public void populateIntervalRecordFrom(Parcel parcel) {
        this.mNotes = parcel.readString();
        this.mExerciseType = parcel.readInt();
        this.mTitle = parcel.readString();
        this.mHasRoute = parcel.readBoolean();
        this.mExerciseRoute = ExerciseRouteInternal.readFromParcel(parcel);
        this.mExerciseLaps = ExerciseLapInternal.populateLapsFromParcel(parcel);
        this.mExerciseSegments = ExerciseSegmentInternal.populateSegmentsFromParcel(parcel);
    }

    public void addRouteLocation(ExerciseRouteInternal.LocationInternal location) {
        if (this.mExerciseRoute == null) {
            this.mExerciseRoute = new ExerciseRouteInternal(List.of(location));
            this.mHasRoute = true;
        } else {
            this.mExerciseRoute.addLocation(location);
        }
    }
}

