/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.health.connect.datatypes.IntervalRecord;
import android.health.connect.internal.datatypes.RecordInternal;
import android.os.Parcel;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;

public abstract class IntervalRecordInternal<T extends IntervalRecord>
extends RecordInternal<T> {
    private long mStartTime;
    private int mStartZoneOffset;
    private long mEndTime;
    private int mEndZoneOffset;

    IntervalRecordInternal() {
    }

    public long getStartTimeInMillis() {
        return this.mStartTime;
    }

    public int getStartZoneOffsetInSeconds() {
        return this.mStartZoneOffset;
    }

    public long getEndTimeInMillis() {
        return this.mEndTime;
    }

    public int getEndZoneOffsetInSeconds() {
        return this.mEndZoneOffset;
    }

    @Override
    void populateRecordTo(Parcel parcel) {
        parcel.writeLong(this.mStartTime);
        parcel.writeInt(this.mStartZoneOffset);
        parcel.writeLong(this.mEndTime);
        parcel.writeInt(this.mEndZoneOffset);
        this.populateIntervalRecordTo(parcel);
    }

    @Override
    void populateRecordFrom(Parcel parcel) {
        this.mStartTime = parcel.readLong();
        this.mStartZoneOffset = parcel.readInt();
        this.mEndTime = parcel.readLong();
        this.mEndZoneOffset = parcel.readInt();
        this.populateIntervalRecordFrom(parcel);
    }

    Instant getStartTime() {
        return Instant.ofEpochMilli(this.mStartTime);
    }

    public IntervalRecordInternal<T> setStartTime(long startTime) {
        this.mStartTime = startTime;
        return this;
    }

    ZoneOffset getStartZoneOffset() {
        return ZoneOffset.ofTotalSeconds(this.mStartZoneOffset);
    }

    public IntervalRecordInternal<T> setStartZoneOffset(int startZoneOffset) {
        this.mStartZoneOffset = startZoneOffset;
        return this;
    }

    Instant getEndTime() {
        return Instant.ofEpochMilli(this.mEndTime);
    }

    public IntervalRecordInternal<T> setEndTime(long endTime) {
        this.mEndTime = endTime;
        return this;
    }

    ZoneOffset getEndZoneOffset() {
        return ZoneOffset.ofTotalSeconds(this.mEndZoneOffset);
    }

    public IntervalRecordInternal<T> setEndZoneOffset(int endZoneOffset) {
        this.mEndZoneOffset = endZoneOffset;
        return this;
    }

    @Override
    public LocalDate getLocalDate() {
        return LocalDate.ofInstant(this.getStartTime(), this.getStartZoneOffset());
    }

    abstract void populateIntervalRecordFrom(Parcel var1);

    abstract void populateIntervalRecordTo(Parcel var1);
}

