/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.PowerRecord;
import android.health.connect.datatypes.units.Power;
import android.health.connect.internal.datatypes.SeriesRecordInternal;
import android.os.Parcel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=13)
public class PowerRecordInternal
extends SeriesRecordInternal<PowerRecord, PowerRecord.PowerRecordSample> {
    private Set<PowerRecordSample> mPowerRecordSamples;

    @Override
    void populateIntervalRecordFrom(Parcel parcel) {
        int size = parcel.readInt();
        this.mPowerRecordSamples = new HashSet<PowerRecordSample>(size);
        for (int i = 0; i < size; ++i) {
            this.mPowerRecordSamples.add(new PowerRecordSample(parcel.readDouble(), parcel.readLong()));
        }
    }

    @Override
    public Set<PowerRecordSample> getSamples() {
        return this.mPowerRecordSamples;
    }

    @Override
    public PowerRecordInternal setSamples(Set<? extends SeriesRecordInternal.Sample> samples) {
        Objects.requireNonNull(samples);
        this.mPowerRecordSamples = samples;
        return this;
    }

    @Override
    public PowerRecord toExternalRecord() {
        return new PowerRecord.Builder(this.buildMetaData(), this.getStartTime(), this.getEndTime(), this.getExternalSamples()).setStartZoneOffset(this.getStartZoneOffset()).setEndZoneOffset(this.getEndZoneOffset()).buildWithoutValidation();
    }

    @Override
    void populateIntervalRecordTo(Parcel parcel) {
        parcel.writeInt(this.mPowerRecordSamples.size());
        for (PowerRecordSample powerRecordSample : this.mPowerRecordSamples) {
            parcel.writeDouble(powerRecordSample.getPower());
            parcel.writeLong(powerRecordSample.getEpochMillis());
        }
    }

    private List<PowerRecord.PowerRecordSample> getExternalSamples() {
        ArrayList<PowerRecord.PowerRecordSample> powerRecords = new ArrayList<PowerRecord.PowerRecordSample>(this.mPowerRecordSamples.size());
        for (PowerRecordSample powerRecordSample : this.mPowerRecordSamples) {
            powerRecords.add(new PowerRecord.PowerRecordSample(Power.fromWatts(powerRecordSample.getPower()), Instant.ofEpochMilli(powerRecordSample.getEpochMillis()), true));
        }
        return powerRecords;
    }

    public static class PowerRecordSample
    implements SeriesRecordInternal.Sample {
        private final double mPower;
        private final long mEpochMillis;

        public PowerRecordSample(double power, long epochMillis) {
            this.mPower = power;
            this.mEpochMillis = epochMillis;
        }

        public double getPower() {
            return this.mPower;
        }

        public long getEpochMillis() {
            return this.mEpochMillis;
        }

        public boolean equals(Object object) {
            if (super.equals(object) && object instanceof PowerRecordSample) {
                PowerRecordSample other = (PowerRecordSample)object;
                return this.getEpochMillis() == other.getEpochMillis();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getEpochMillis());
        }
    }
}

