/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.health.connect.datatypes.DataOrigin;
import android.health.connect.datatypes.Device;
import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.Metadata;
import android.health.connect.datatypes.Record;
import android.os.Parcel;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Objects;
import java.util.UUID;

public abstract class RecordInternal<T extends Record> {
    private final int mRecordIdentifier;
    private UUID mUuid;
    private String mPackageName;
    private String mAppName;
    private long mLastModifiedTime = -1L;
    private String mClientRecordId;
    private long mClientRecordVersion = -1L;
    private String mManufacturer;
    private String mModel;
    private int mDeviceType;
    private long mDeviceInfoId = -1L;
    private long mAppInfoId = -1L;
    private int mRowId = -1;
    private int mRecordingMethod;

    RecordInternal() {
        Identifier annotation = this.getClass().getAnnotation(Identifier.class);
        Objects.requireNonNull(annotation);
        this.mRecordIdentifier = annotation.recordIdentifier();
    }

    public int getRecordType() {
        return this.mRecordIdentifier;
    }

    public void populateUsing(Parcel parcel) {
        String uuidString = parcel.readString();
        if (uuidString != null && !uuidString.isEmpty()) {
            this.mUuid = UUID.fromString(uuidString);
        }
        this.mPackageName = parcel.readString();
        this.mAppName = parcel.readString();
        this.mLastModifiedTime = parcel.readLong();
        this.mClientRecordId = parcel.readString();
        this.mClientRecordVersion = parcel.readLong();
        this.mManufacturer = parcel.readString();
        this.mModel = parcel.readString();
        this.mDeviceType = parcel.readInt();
        this.mRecordingMethod = parcel.readInt();
        this.populateRecordFrom(parcel);
    }

    public void writeToParcel(Parcel parcel) {
        parcel.writeString(this.mUuid == null ? "" : this.mUuid.toString());
        parcel.writeString(this.mPackageName);
        parcel.writeString(this.mAppName);
        parcel.writeLong(this.mLastModifiedTime);
        parcel.writeString(this.mClientRecordId);
        parcel.writeLong(this.mClientRecordVersion);
        parcel.writeString(this.mManufacturer);
        parcel.writeString(this.mModel);
        parcel.writeInt(this.mDeviceType);
        parcel.writeInt(this.mRecordingMethod);
        this.populateRecordTo(parcel);
    }

    public UUID getUuid() {
        return this.mUuid;
    }

    public RecordInternal<T> setUuid(UUID uuid) {
        this.mUuid = uuid;
        return this;
    }

    public RecordInternal<T> setUuid(String uuid) {
        if (uuid == null || uuid.isEmpty()) {
            this.mUuid = null;
            return this;
        }
        this.mUuid = UUID.fromString(uuid);
        return this;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public RecordInternal<T> setPackageName(String packageName) {
        this.mPackageName = packageName;
        return this;
    }

    public int getRowId() {
        return this.mRowId;
    }

    public RecordInternal<T> setRowId(int rowId) {
        this.mRowId = rowId;
        return this;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public RecordInternal<T> setAppName(String appName) {
        this.mAppName = appName;
        return this;
    }

    public long getLastModifiedTime() {
        return this.mLastModifiedTime;
    }

    public RecordInternal<T> setLastModifiedTime(long lastModifiedTime) {
        this.mLastModifiedTime = lastModifiedTime;
        return this;
    }

    public String getClientRecordId() {
        return this.mClientRecordId;
    }

    public RecordInternal<T> setClientRecordId(String clientRecordId) {
        this.mClientRecordId = clientRecordId;
        return this;
    }

    public long getClientRecordVersion() {
        return this.mClientRecordVersion;
    }

    public RecordInternal<T> setClientRecordVersion(long clientRecordVersion) {
        this.mClientRecordVersion = clientRecordVersion;
        return this;
    }

    public String getManufacturer() {
        return this.mManufacturer;
    }

    public RecordInternal<T> setManufacturer(String manufacturer) {
        this.mManufacturer = manufacturer;
        return this;
    }

    public String getModel() {
        return this.mModel;
    }

    public RecordInternal<T> setModel(String model) {
        this.mModel = model;
        return this;
    }

    public int getDeviceType() {
        return this.mDeviceType;
    }

    public RecordInternal<T> setDeviceType(int deviceType) {
        this.mDeviceType = deviceType;
        return this;
    }

    public long getDeviceInfoId() {
        return this.mDeviceInfoId;
    }

    public RecordInternal<T> setDeviceInfoId(long deviceInfoId) {
        this.mDeviceInfoId = deviceInfoId;
        return this;
    }

    public long getAppInfoId() {
        return this.mAppInfoId;
    }

    public RecordInternal<T> setAppInfoId(long appInfoId) {
        this.mAppInfoId = appInfoId;
        return this;
    }

    public int getRecordingMethod() {
        return this.mRecordingMethod;
    }

    public RecordInternal<T> setRecordingMethod(int recordingMethod) {
        this.mRecordingMethod = recordingMethod;
        return this;
    }

    public abstract T toExternalRecord();

    Metadata buildMetaData() {
        return new Metadata.Builder().setClientRecordId(this.getClientRecordId()).setClientRecordVersion(this.getClientRecordVersion()).setDataOrigin(new DataOrigin.Builder().setPackageName(this.getPackageName()).build()).setId(this.getUuid() == null ? null : this.getUuid().toString()).setLastModifiedTime(Instant.ofEpochMilli(this.getLastModifiedTime())).setRecordingMethod(this.getRecordingMethod()).setDevice(new Device.Builder().setManufacturer(this.getManufacturer()).setType(this.getDeviceType()).setModel(this.getModel()).build()).build();
    }

    public abstract LocalDate getLocalDate();

    abstract void populateRecordTo(Parcel var1);

    abstract void populateRecordFrom(Parcel var1);
}

