/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.SleepSessionRecord;
import android.health.connect.internal.datatypes.IntervalRecordInternal;
import android.health.connect.internal.datatypes.SleepStageInternal;
import android.os.Parcel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Identifier(recordIdentifier=38)
public class SleepSessionRecordInternal
extends IntervalRecordInternal<SleepSessionRecord> {
    private List<SleepStageInternal> mStages;
    private String mNotes;
    private String mTitle;

    public String getNotes() {
        return this.mNotes;
    }

    public SleepSessionRecordInternal setNotes(String notes) {
        this.mNotes = notes;
        return this;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public SleepSessionRecordInternal setTitle(String title) {
        this.mTitle = title;
        return this;
    }

    public List<SleepStageInternal> getSleepStages() {
        return this.mStages;
    }

    public SleepSessionRecordInternal setSleepStages(List<SleepStageInternal> stages) {
        Objects.requireNonNull(stages);
        this.mStages = new ArrayList<SleepStageInternal>(stages);
        return this;
    }

    public SleepSessionRecordInternal addSleepStage(SleepStageInternal stage) {
        if (stage != null) {
            if (this.mStages == null) {
                this.mStages = new ArrayList<SleepStageInternal>();
            }
            this.mStages.add(stage);
        }
        return this;
    }

    @Override
    public void populateIntervalRecordTo(Parcel parcel) {
        parcel.writeString(this.mNotes);
        parcel.writeString(this.mTitle);
        SleepStageInternal.writeStagesToParcel(this.mStages, parcel);
    }

    @Override
    public void populateIntervalRecordFrom(Parcel parcel) {
        this.mNotes = parcel.readString();
        this.mTitle = parcel.readString();
        this.mStages = SleepStageInternal.populateStagesFromParcel(parcel);
    }

    @Override
    public SleepSessionRecord toExternalRecord() {
        SleepSessionRecord.Builder builder = new SleepSessionRecord.Builder(this.buildMetaData(), this.getStartTime(), this.getEndTime());
        if (this.getStartZoneOffset() != null) {
            builder.setStartZoneOffset(this.getStartZoneOffset());
        }
        if (this.getEndZoneOffset() != null) {
            builder.setEndZoneOffset(this.getEndZoneOffset());
        }
        if (this.getNotes() != null) {
            builder.setNotes(this.getNotes());
        }
        if (this.getTitle() != null) {
            builder.setTitle(this.getTitle());
        }
        if (this.getSleepStages() != null) {
            builder.setStages(SleepStageInternal.getExternalStages(this.mStages));
        }
        return builder.buildWithoutValidation();
    }
}

