/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes;

import android.health.connect.datatypes.Identifier;
import android.health.connect.datatypes.SpeedRecord;
import android.health.connect.datatypes.units.Velocity;
import android.health.connect.internal.datatypes.SeriesRecordInternal;
import android.os.Parcel;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@Identifier(recordIdentifier=14)
public class SpeedRecordInternal
extends SeriesRecordInternal<SpeedRecord, SpeedRecord.SpeedRecordSample> {
    private Set<SpeedRecordSample> mSpeedRecordSamples;

    @Override
    void populateIntervalRecordFrom(Parcel parcel) {
        int size = parcel.readInt();
        this.mSpeedRecordSamples = new HashSet<SpeedRecordSample>(size);
        for (int i = 0; i < size; ++i) {
            this.mSpeedRecordSamples.add(new SpeedRecordSample(parcel.readDouble(), parcel.readLong()));
        }
    }

    @Override
    public Set<SpeedRecordSample> getSamples() {
        return this.mSpeedRecordSamples;
    }

    @Override
    public SpeedRecordInternal setSamples(Set<? extends SeriesRecordInternal.Sample> samples) {
        Objects.requireNonNull(samples);
        this.mSpeedRecordSamples = samples;
        return this;
    }

    @Override
    public SpeedRecord toExternalRecord() {
        return new SpeedRecord.Builder(this.buildMetaData(), this.getStartTime(), this.getEndTime(), this.getExternalSamples()).setStartZoneOffset(this.getStartZoneOffset()).setEndZoneOffset(this.getEndZoneOffset()).buildWithoutValidation();
    }

    @Override
    void populateIntervalRecordTo(Parcel parcel) {
        parcel.writeInt(this.mSpeedRecordSamples.size());
        for (SpeedRecordSample speedRecordSample : this.mSpeedRecordSamples) {
            parcel.writeDouble(speedRecordSample.getSpeed());
            parcel.writeLong(speedRecordSample.getEpochMillis());
        }
    }

    private List<SpeedRecord.SpeedRecordSample> getExternalSamples() {
        ArrayList<SpeedRecord.SpeedRecordSample> speedRecords = new ArrayList<SpeedRecord.SpeedRecordSample>(this.mSpeedRecordSamples.size());
        for (SpeedRecordSample speedRecordSample : this.mSpeedRecordSamples) {
            speedRecords.add(new SpeedRecord.SpeedRecordSample(Velocity.fromMetersPerSecond(speedRecordSample.getSpeed()), Instant.ofEpochMilli(speedRecordSample.getEpochMillis()), true));
        }
        return speedRecords;
    }

    public static class SpeedRecordSample
    implements SeriesRecordInternal.Sample {
        private final double mSpeed;
        private final long mEpochMillis;

        public SpeedRecordSample(double speed, long epochMillis) {
            this.mSpeed = speed;
            this.mEpochMillis = epochMillis;
        }

        public double getSpeed() {
            return this.mSpeed;
        }

        public long getEpochMillis() {
            return this.mEpochMillis;
        }

        public boolean equals(Object object) {
            if (super.equals(object) && object instanceof SpeedRecordSample) {
                SpeedRecordSample other = (SpeedRecordSample)object;
                return this.getEpochMillis() == other.getEpochMillis();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.getEpochMillis());
        }
    }
}

