/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.internal.datatypes.utils;

import android.health.connect.AggregateResult;
import android.health.connect.datatypes.ActiveCaloriesBurnedRecord;
import android.health.connect.datatypes.AggregationType;
import android.health.connect.datatypes.BasalMetabolicRateRecord;
import android.health.connect.datatypes.DistanceRecord;
import android.health.connect.datatypes.ElevationGainedRecord;
import android.health.connect.datatypes.ExerciseSessionRecord;
import android.health.connect.datatypes.FloorsClimbedRecord;
import android.health.connect.datatypes.HeartRateRecord;
import android.health.connect.datatypes.HeightRecord;
import android.health.connect.datatypes.HydrationRecord;
import android.health.connect.datatypes.NutritionRecord;
import android.health.connect.datatypes.PowerRecord;
import android.health.connect.datatypes.RestingHeartRateRecord;
import android.health.connect.datatypes.SleepSessionRecord;
import android.health.connect.datatypes.StepsRecord;
import android.health.connect.datatypes.TotalCaloriesBurnedRecord;
import android.health.connect.datatypes.WeightRecord;
import android.health.connect.datatypes.WheelchairPushesRecord;
import android.health.connect.datatypes.units.Energy;
import android.health.connect.datatypes.units.Length;
import android.health.connect.datatypes.units.Mass;
import android.health.connect.datatypes.units.Power;
import android.health.connect.datatypes.units.Volume;
import android.os.Parcel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AggregationTypeIdMapper {
    private static final int MAP_SIZE = 65;
    private static volatile AggregationTypeIdMapper sAggregationTypeIdMapper;
    private final Map<Integer, AggregationResultCreator> mIdToAggregateResult = new HashMap<Integer, AggregationResultCreator>(65);
    private final Map<Integer, AggregationType<?>> mIdDataAggregationTypeMap = new HashMap(65);
    private final Map<AggregationType<?>, Integer> mDataAggregationTypeIdMap = new HashMap(65);

    private AggregationTypeIdMapper() {
        this.addLongIdsToAggregateResultMap(Arrays.asList(HeartRateRecord.BPM_MAX, HeartRateRecord.BPM_MIN, StepsRecord.STEPS_COUNT_TOTAL, HeartRateRecord.BPM_AVG, RestingHeartRateRecord.BPM_MAX, RestingHeartRateRecord.BPM_MIN, RestingHeartRateRecord.BPM_AVG, WheelchairPushesRecord.WHEEL_CHAIR_PUSHES_COUNT_TOTAL, HeartRateRecord.HEART_MEASUREMENTS_COUNT, SleepSessionRecord.SLEEP_DURATION_TOTAL, ExerciseSessionRecord.EXERCISE_DURATION_TOTAL));
        this.addDoubleIdsToAggregateResultMap(Arrays.asList(FloorsClimbedRecord.FLOORS_CLIMBED_TOTAL));
        this.addPowerIdsToAggregateResultMap(Arrays.asList(PowerRecord.POWER_MIN, PowerRecord.POWER_MAX, PowerRecord.POWER_AVG));
        this.addEnergyIdsToAggregateResultMap(Arrays.asList(ActiveCaloriesBurnedRecord.ACTIVE_CALORIES_TOTAL, BasalMetabolicRateRecord.BASAL_CALORIES_TOTAL, NutritionRecord.ENERGY_TOTAL, NutritionRecord.ENERGY_FROM_FAT_TOTAL, TotalCaloriesBurnedRecord.ENERGY_TOTAL));
        this.addVolumeIdsToAggregateResultMap(Arrays.asList(HydrationRecord.VOLUME_TOTAL));
        this.addLengthIdsToAggregateResultMap(Arrays.asList(DistanceRecord.DISTANCE_TOTAL, ElevationGainedRecord.ELEVATION_GAINED_TOTAL, HeightRecord.HEIGHT_AVG, HeightRecord.HEIGHT_MAX, HeightRecord.HEIGHT_MIN));
        this.addMassIdsToAggregateResultMap(Arrays.asList(NutritionRecord.BIOTIN_TOTAL, NutritionRecord.CAFFEINE_TOTAL, NutritionRecord.CALCIUM_TOTAL, NutritionRecord.CHLORIDE_TOTAL, NutritionRecord.CHOLESTEROL_TOTAL, NutritionRecord.CHROMIUM_TOTAL, NutritionRecord.COPPER_TOTAL, NutritionRecord.DIETARY_FIBER_TOTAL, NutritionRecord.FOLATE_TOTAL, NutritionRecord.FOLIC_ACID_TOTAL, NutritionRecord.IODINE_TOTAL, NutritionRecord.IRON_TOTAL, NutritionRecord.MAGNESIUM_TOTAL, NutritionRecord.MANGANESE_TOTAL, NutritionRecord.MOLYBDENUM_TOTAL, NutritionRecord.MONOUNSATURATED_FAT_TOTAL, NutritionRecord.NIACIN_TOTAL, NutritionRecord.PANTOTHENIC_ACID_TOTAL, NutritionRecord.PHOSPHORUS_TOTAL, NutritionRecord.POLYUNSATURATED_FAT_TOTAL, NutritionRecord.POTASSIUM_TOTAL, NutritionRecord.PROTEIN_TOTAL, NutritionRecord.RIBOFLAVIN_TOTAL, NutritionRecord.SATURATED_FAT_TOTAL, NutritionRecord.SELENIUM_TOTAL, NutritionRecord.SODIUM_TOTAL, NutritionRecord.SUGAR_TOTAL, NutritionRecord.THIAMIN_TOTAL, NutritionRecord.TOTAL_CARBOHYDRATE_TOTAL, NutritionRecord.TOTAL_FAT_TOTAL, NutritionRecord.UNSATURATED_FAT_TOTAL, NutritionRecord.VITAMIN_A_TOTAL, NutritionRecord.VITAMIN_B12_TOTAL, NutritionRecord.VITAMIN_B6_TOTAL, NutritionRecord.VITAMIN_C_TOTAL, NutritionRecord.VITAMIN_D_TOTAL, NutritionRecord.VITAMIN_E_TOTAL, NutritionRecord.VITAMIN_K_TOTAL, NutritionRecord.ZINC_TOTAL, WeightRecord.WEIGHT_AVG, WeightRecord.WEIGHT_MAX, WeightRecord.WEIGHT_MIN));
    }

    public static synchronized AggregationTypeIdMapper getInstance() {
        if (sAggregationTypeIdMapper == null) {
            sAggregationTypeIdMapper = new AggregationTypeIdMapper();
        }
        return sAggregationTypeIdMapper;
    }

    public AggregateResult<?> getAggregateResultFor(int id2, Parcel parcel) {
        return this.mIdToAggregateResult.get(id2).getAggregateResult(parcel);
    }

    public AggregationType<?> getAggregationTypeFor(int id2) {
        return this.mIdDataAggregationTypeMap.get(id2);
    }

    public int getIdFor(AggregationType<?> aggregationType) {
        return this.mDataAggregationTypeIdMap.get(aggregationType);
    }

    private AggregateResult<Long> getLongResult(long result) {
        return new AggregateResult<Long>(result);
    }

    private AggregateResult<Double> getDoubleResult(double result) {
        return new AggregateResult<Double>(result);
    }

    private AggregateResult<Energy> getEnergyResult(double result) {
        return new AggregateResult<Energy>(Energy.fromCalories(result));
    }

    private AggregateResult<Power> getPowerResult(double result) {
        return new AggregateResult<Power>(Power.fromWatts(result));
    }

    private AggregateResult<Length> getLengthResult(double result) {
        return new AggregateResult<Length>(Length.fromMeters(result));
    }

    private AggregateResult<Volume> getVolumeResult(double result) {
        return new AggregateResult<Volume>(Volume.fromLiters(result));
    }

    private AggregateResult<Mass> getMassResult(double result) {
        return new AggregateResult<Mass>(Mass.fromGrams(result));
    }

    private void addLongIdsToAggregateResultMap(List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> aggregationType : aggregationTypeList) {
            this.mIdToAggregateResult.put(aggregationType.getAggregationTypeIdentifier(), result -> this.getLongResult(result.readLong()));
            this.populateIdDataAggregationType(aggregationType);
        }
    }

    private void addDoubleIdsToAggregateResultMap(List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> aggregationType : aggregationTypeList) {
            this.mIdToAggregateResult.put(aggregationType.getAggregationTypeIdentifier(), result -> this.getDoubleResult(result.readDouble()));
            this.populateIdDataAggregationType(aggregationType);
        }
    }

    private void addEnergyIdsToAggregateResultMap(List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> aggregationType : aggregationTypeList) {
            this.mIdToAggregateResult.put(aggregationType.getAggregationTypeIdentifier(), result -> this.getEnergyResult(result.readDouble()));
            this.populateIdDataAggregationType(aggregationType);
        }
    }

    private void addPowerIdsToAggregateResultMap(List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> aggregationType : aggregationTypeList) {
            this.mIdToAggregateResult.put(aggregationType.getAggregationTypeIdentifier(), result -> this.getPowerResult(result.readDouble()));
            this.populateIdDataAggregationType(aggregationType);
        }
    }

    private void addLengthIdsToAggregateResultMap(List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> aggregationType : aggregationTypeList) {
            this.mIdToAggregateResult.put(aggregationType.getAggregationTypeIdentifier(), result -> this.getLengthResult(result.readDouble()));
            this.populateIdDataAggregationType(aggregationType);
        }
    }

    private void addVolumeIdsToAggregateResultMap(List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> aggregationType : aggregationTypeList) {
            this.mIdToAggregateResult.put(aggregationType.getAggregationTypeIdentifier(), result -> this.getVolumeResult(result.readDouble()));
            this.populateIdDataAggregationType(aggregationType);
        }
    }

    private void addMassIdsToAggregateResultMap(List<AggregationType<?>> aggregationTypeList) {
        for (AggregationType<?> aggregationType : aggregationTypeList) {
            this.mIdToAggregateResult.put(aggregationType.getAggregationTypeIdentifier(), result -> this.getMassResult(result.readDouble()));
            this.populateIdDataAggregationType(aggregationType);
        }
    }

    private void populateIdDataAggregationType(AggregationType<?> aggregationType) {
        this.mIdDataAggregationTypeMap.put(aggregationType.getAggregationTypeIdentifier(), aggregationType);
        this.mDataAggregationTypeIdMap.put(aggregationType, aggregationType.getAggregationTypeIdentifier());
    }

    private static interface AggregationResultCreator {
        public AggregateResult<?> getAggregateResult(Parcel var1);
    }
}

