/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.migration;

import android.annotation.SystemApi;
import android.health.connect.migration.MigrationPayload;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class AppInfoMigrationPayload
extends MigrationPayload
implements Parcelable {
    public static final Parcelable.Creator<AppInfoMigrationPayload> CREATOR = new Parcelable.Creator<AppInfoMigrationPayload>(){

        @Override
        public AppInfoMigrationPayload createFromParcel(Parcel in) {
            in.readInt();
            return new AppInfoMigrationPayload(in);
        }

        public AppInfoMigrationPayload[] newArray(int size) {
            return new AppInfoMigrationPayload[size];
        }
    };
    private final String mPackageName;
    private final String mAppName;
    private final byte[] mAppIcon;

    private AppInfoMigrationPayload(String packageName, String appName, byte[] appIcon) {
        this.mPackageName = packageName;
        this.mAppName = appName;
        this.mAppIcon = appIcon;
    }

    AppInfoMigrationPayload(Parcel in) {
        this.mPackageName = in.readString();
        this.mAppName = in.readString();
        this.mAppIcon = in.createByteArray();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(3);
        dest.writeString(this.mPackageName);
        dest.writeString(this.mAppName);
        dest.writeByteArray(this.mAppIcon);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public byte[] getAppIcon() {
        return this.mAppIcon;
    }

    public static class Builder {
        private String mPackageName;
        private String mAppName;
        private byte[] mAppIcon;

        public Builder(String packageName, String appName) {
            Objects.requireNonNull(packageName);
            Objects.requireNonNull(appName);
            this.mPackageName = packageName;
            this.mAppName = appName;
        }

        public Builder setPackageName(String packageName) {
            Objects.requireNonNull(packageName);
            this.mPackageName = packageName;
            return this;
        }

        public Builder setAppName(String appName) {
            Objects.requireNonNull(appName);
            this.mAppName = appName;
            return this;
        }

        public Builder setAppIcon(byte[] appIcon) {
            this.mAppIcon = appIcon;
            return this;
        }

        public AppInfoMigrationPayload build() {
            return new AppInfoMigrationPayload(this.mPackageName, this.mAppName, this.mAppIcon);
        }
    }
}

