/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.migration;

import android.annotation.SystemApi;
import android.health.connect.migration.MigrationPayload;
import android.os.Parcel;
import android.os.Parcelable;

@SystemApi
public class MetadataMigrationPayload
extends MigrationPayload
implements Parcelable {
    public static final Parcelable.Creator<MetadataMigrationPayload> CREATOR = new Parcelable.Creator<MetadataMigrationPayload>(){

        @Override
        public MetadataMigrationPayload createFromParcel(Parcel in) {
            in.readInt();
            return new MetadataMigrationPayload(in);
        }

        public MetadataMigrationPayload[] newArray(int size) {
            return new MetadataMigrationPayload[size];
        }
    };
    private final int mRecordRetentionPeriodDays;

    private MetadataMigrationPayload(int recordRetentionPeriodDays) {
        this.mRecordRetentionPeriodDays = recordRetentionPeriodDays;
    }

    MetadataMigrationPayload(Parcel in) {
        this.mRecordRetentionPeriodDays = in.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(5);
        dest.writeInt(this.mRecordRetentionPeriodDays);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getRecordRetentionPeriodDays() {
        return this.mRecordRetentionPeriodDays;
    }

    public static class Builder {
        private static final int MIN_RRP = 0;
        private static final int MAX_RRP = 7300;
        private int mRecordRetentionPeriodDays = 0;

        public Builder setRecordRetentionPeriodDays(int recordRetentionPeriodDays) {
            if (recordRetentionPeriodDays < 0 || recordRetentionPeriodDays > 7300) {
                throw new IllegalArgumentException("recordRetentionPeriodDays is not within the range, was: " + recordRetentionPeriodDays);
            }
            this.mRecordRetentionPeriodDays = recordRetentionPeriodDays;
            return this;
        }

        public MetadataMigrationPayload build() {
            return new MetadataMigrationPayload(this.mRecordRetentionPeriodDays);
        }
    }
}

