/*
 * Decompiled with CFR 0.152.
 */
package android.health.connect.restore;

import android.annotation.SystemApi;
import android.health.connect.HealthConnectException;
import android.health.connect.aidl.HealthConnectExceptionParcel;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

@SystemApi
public class StageRemoteDataException
extends RuntimeException
implements Parcelable {
    private final Map<String, HealthConnectException> mExceptionsByFileNames = new ArrayMap<String, HealthConnectException>();
    public static final Parcelable.Creator<StageRemoteDataException> CREATOR = new Parcelable.Creator<StageRemoteDataException>(){

        @Override
        public StageRemoteDataException createFromParcel(Parcel in) {
            return new StageRemoteDataException(in);
        }

        public StageRemoteDataException[] newArray(int size) {
            return new StageRemoteDataException[size];
        }
    };

    private StageRemoteDataException(Parcel in) {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            this.mExceptionsByFileNames.put(in.readString(), in.readParcelable(HealthConnectExceptionParcel.class.getClassLoader(), HealthConnectExceptionParcel.class).getHealthConnectException());
        }
    }

    public StageRemoteDataException(Map<String, HealthConnectException> exceptionsByFileNames) {
        super("StageRemoteDataException");
        Objects.requireNonNull(exceptionsByFileNames);
        this.mExceptionsByFileNames.putAll(exceptionsByFileNames);
    }

    public Map<String, HealthConnectException> getExceptionsByFileNames() {
        return Collections.unmodifiableMap(this.mExceptionsByFileNames);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mExceptionsByFileNames.size());
        for (Map.Entry<String, HealthConnectException> fileNamePfd : this.mExceptionsByFileNames.entrySet()) {
            dest.writeString(fileNamePfd.getKey());
            dest.writeParcelable(new HealthConnectExceptionParcel(fileNamePfd.getValue()), 0);
        }
    }
}

