/*
 * Decompiled with CFR 0.152.
 */
package android.inputmethodservice;

import android.inputmethodservice.InlineSuggestionSessionController;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;
import android.view.autofill.AutofillId;
import android.view.inputmethod.InlineSuggestionsRequest;
import android.view.inputmethod.InlineSuggestionsResponse;
import com.android.internal.inputmethod.IInlineSuggestionsRequestCallback;
import com.android.internal.inputmethod.IInlineSuggestionsResponseCallback;
import com.android.internal.inputmethod.InlineSuggestionsRequestInfo;
import com.android.internal.util.function.pooled.PooledLambda;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

class InlineSuggestionSession {
    private static final String TAG = "ImsInlineSuggestionSession";
    static final InlineSuggestionsResponse EMPTY_RESPONSE = new InlineSuggestionsResponse(Collections.emptyList());
    private final Handler mMainThreadHandler;
    private final InlineSuggestionSessionController mInlineSuggestionSessionController;
    private final InlineSuggestionsRequestInfo mRequestInfo;
    private final IInlineSuggestionsRequestCallback mCallback;
    private final Function<Bundle, InlineSuggestionsRequest> mRequestSupplier;
    private final Supplier<IBinder> mHostInputTokenSupplier;
    private final Consumer<InlineSuggestionsResponse> mResponseConsumer;
    private Boolean mPreviousResponseIsEmpty;
    private boolean mCallbackInvoked = false;
    private InlineSuggestionsResponseCallbackImpl mResponseCallback;

    InlineSuggestionSession(InlineSuggestionsRequestInfo requestInfo, IInlineSuggestionsRequestCallback callback, Function<Bundle, InlineSuggestionsRequest> requestSupplier, Supplier<IBinder> hostInputTokenSupplier, Consumer<InlineSuggestionsResponse> responseConsumer, InlineSuggestionSessionController inlineSuggestionSessionController, Handler mainThreadHandler) {
        this.mRequestInfo = requestInfo;
        this.mCallback = callback;
        this.mRequestSupplier = requestSupplier;
        this.mHostInputTokenSupplier = hostInputTokenSupplier;
        this.mResponseConsumer = responseConsumer;
        this.mInlineSuggestionSessionController = inlineSuggestionSessionController;
        this.mMainThreadHandler = mainThreadHandler;
    }

    InlineSuggestionsRequestInfo getRequestInfo() {
        return this.mRequestInfo;
    }

    IInlineSuggestionsRequestCallback getRequestCallback() {
        return this.mCallback;
    }

    boolean shouldSendImeStatus() {
        return this.mResponseCallback != null;
    }

    boolean isCallbackInvoked() {
        return this.mCallbackInvoked;
    }

    void invalidate() {
        try {
            this.mCallback.onInlineSuggestionsSessionInvalidated();
        }
        catch (RemoteException e) {
            Log.w(TAG, "onInlineSuggestionsSessionInvalidated() remote exception", e);
        }
        if (this.mResponseCallback != null) {
            this.consumeInlineSuggestionsResponse(EMPTY_RESPONSE);
            this.mResponseCallback.invalidate();
            this.mResponseCallback = null;
        }
    }

    void makeInlineSuggestionRequestUncheck() {
        if (this.mCallbackInvoked) {
            return;
        }
        try {
            InlineSuggestionsRequest request = this.mRequestSupplier.apply(this.mRequestInfo.getUiExtras());
            if (request == null) {
                this.mCallback.onInlineSuggestionsUnsupported();
            } else {
                request.setHostInputToken(this.mHostInputTokenSupplier.get());
                request.filterContentTypes();
                this.mResponseCallback = new InlineSuggestionsResponseCallbackImpl(this);
                this.mCallback.onInlineSuggestionsRequest(request, this.mResponseCallback);
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "makeInlinedSuggestionsRequest() remote exception:" + e);
        }
        this.mCallbackInvoked = true;
    }

    void handleOnInlineSuggestionsResponse(AutofillId fieldId, InlineSuggestionsResponse response) {
        if (!this.mInlineSuggestionSessionController.match(fieldId)) {
            return;
        }
        this.consumeInlineSuggestionsResponse(response);
    }

    void consumeInlineSuggestionsResponse(InlineSuggestionsResponse response) {
        boolean isResponseEmpty = response.getInlineSuggestions().isEmpty();
        if (isResponseEmpty && Boolean.TRUE.equals(this.mPreviousResponseIsEmpty)) {
            return;
        }
        this.mPreviousResponseIsEmpty = isResponseEmpty;
        this.mResponseConsumer.accept(response);
    }

    private static class InlineSuggestionsResponseCallbackImpl
    extends IInlineSuggestionsResponseCallback.Stub {
        private final WeakReference<InlineSuggestionSession> mSession;
        private volatile boolean mInvalid = false;

        private InlineSuggestionsResponseCallbackImpl(InlineSuggestionSession session) {
            this.mSession = new WeakReference<InlineSuggestionSession>(session);
        }

        void invalidate() {
            this.mInvalid = true;
        }

        @Override
        public void onInlineSuggestionsResponse(AutofillId fieldId, InlineSuggestionsResponse response) {
            if (this.mInvalid) {
                return;
            }
            InlineSuggestionSession session = (InlineSuggestionSession)this.mSession.get();
            if (session != null) {
                session.mMainThreadHandler.sendMessage(PooledLambda.obtainMessage(InlineSuggestionSession::handleOnInlineSuggestionsResponse, session, fieldId, response));
            }
        }
    }
}

