/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.TimeUtils;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class GnssMeasurementRequest
implements Parcelable {
    public static final int PASSIVE_INTERVAL = Integer.MAX_VALUE;
    private final boolean mCorrelationVectorOutputsEnabled;
    private final boolean mFullTracking;
    private final int mIntervalMillis;
    public static final Parcelable.Creator<GnssMeasurementRequest> CREATOR = new Parcelable.Creator<GnssMeasurementRequest>(){

        @Override
        public GnssMeasurementRequest createFromParcel(Parcel parcel) {
            return new GnssMeasurementRequest(parcel.readBoolean(), parcel.readBoolean(), parcel.readInt());
        }

        public GnssMeasurementRequest[] newArray(int i) {
            return new GnssMeasurementRequest[i];
        }
    };

    private GnssMeasurementRequest(boolean fullTracking, boolean correlationVectorOutputsEnabled, int intervalMillis) {
        this.mFullTracking = fullTracking;
        this.mCorrelationVectorOutputsEnabled = correlationVectorOutputsEnabled;
        this.mIntervalMillis = intervalMillis;
    }

    @SystemApi
    public boolean isCorrelationVectorOutputsEnabled() {
        return this.mCorrelationVectorOutputsEnabled;
    }

    public boolean isFullTracking() {
        return this.mFullTracking;
    }

    public int getIntervalMillis() {
        return this.mIntervalMillis;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeBoolean(this.mFullTracking);
        parcel.writeBoolean(this.mCorrelationVectorOutputsEnabled);
        parcel.writeInt(this.mIntervalMillis);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("GnssMeasurementRequest[");
        s.append("@");
        TimeUtils.formatDuration((long)this.mIntervalMillis, s);
        if (this.mFullTracking) {
            s.append(", FullTracking");
        }
        if (this.mCorrelationVectorOutputsEnabled) {
            s.append(", CorrelationVectorOutputs");
        }
        s.append(']');
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GnssMeasurementRequest)) {
            return false;
        }
        GnssMeasurementRequest other = (GnssMeasurementRequest)obj;
        if (this.mFullTracking != other.mFullTracking) {
            return false;
        }
        if (this.mCorrelationVectorOutputsEnabled != other.mCorrelationVectorOutputsEnabled) {
            return false;
        }
        return this.mIntervalMillis == other.mIntervalMillis;
    }

    public int hashCode() {
        return Objects.hash(this.mFullTracking, this.mCorrelationVectorOutputsEnabled, this.mIntervalMillis);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static class Builder {
        private boolean mCorrelationVectorOutputsEnabled;
        private boolean mFullTracking;
        private int mIntervalMillis;

        public Builder() {
        }

        public Builder(GnssMeasurementRequest request) {
            this.mCorrelationVectorOutputsEnabled = request.isCorrelationVectorOutputsEnabled();
            this.mFullTracking = request.isFullTracking();
            this.mIntervalMillis = request.getIntervalMillis();
        }

        @SystemApi
        public Builder setCorrelationVectorOutputsEnabled(boolean value) {
            this.mCorrelationVectorOutputsEnabled = value;
            return this;
        }

        public Builder setFullTracking(boolean value) {
            this.mFullTracking = value;
            return this;
        }

        public Builder setIntervalMillis(int value) {
            this.mIntervalMillis = Preconditions.checkArgumentInRange(value, 0, Integer.MAX_VALUE, "intervalMillis");
            return this;
        }

        public GnssMeasurementRequest build() {
            return new GnssMeasurementRequest(this.mFullTracking, this.mCorrelationVectorOutputsEnabled, this.mIntervalMillis);
        }
    }
}

