/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;
import java.util.Objects;

public class GnssSignalType
implements Parcelable {
    private final int mConstellationType;
    private final double mCarrierFrequencyHz;
    private final String mCodeType;
    public static final Parcelable.Creator<GnssSignalType> CREATOR = new Parcelable.Creator<GnssSignalType>(){

        @Override
        public GnssSignalType createFromParcel(Parcel parcel) {
            return new GnssSignalType(parcel.readInt(), parcel.readDouble(), parcel.readString());
        }

        public GnssSignalType[] newArray(int i) {
            return new GnssSignalType[i];
        }
    };

    public static GnssSignalType create(int constellationType, double carrierFrequencyHz, String codeType) {
        Preconditions.checkArgument(carrierFrequencyHz > 0.0, "carrierFrequencyHz must be greater than 0.");
        Objects.requireNonNull(codeType);
        return new GnssSignalType(constellationType, carrierFrequencyHz, codeType);
    }

    private GnssSignalType(int constellationType, double carrierFrequencyHz, String codeType) {
        this.mConstellationType = constellationType;
        this.mCarrierFrequencyHz = carrierFrequencyHz;
        this.mCodeType = codeType;
    }

    public int getConstellationType() {
        return this.mConstellationType;
    }

    public double getCarrierFrequencyHz() {
        return this.mCarrierFrequencyHz;
    }

    public String getCodeType() {
        return this.mCodeType;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mConstellationType);
        parcel.writeDouble(this.mCarrierFrequencyHz);
        parcel.writeString(this.mCodeType);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("GnssSignalType[");
        s.append("Constellation=").append(this.mConstellationType);
        s.append(", CarrierFrequencyHz=").append(this.mCarrierFrequencyHz);
        s.append(", CodeType=").append(this.mCodeType);
        s.append(']');
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof GnssSignalType) {
            GnssSignalType other = (GnssSignalType)obj;
            return this.mConstellationType == other.mConstellationType && Double.compare(this.mCarrierFrequencyHz, other.mCarrierFrequencyHz) == 0 && this.mCodeType.equals(other.mCodeType);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mConstellationType, this.mCarrierFrequencyHz, this.mCodeType);
    }

    @Override
    public int describeContents() {
        return 0;
    }
}

