/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.location.Country;
import android.location.ICountryListener;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ICountryDetector
extends IInterface {
    public Country detectCountry() throws RemoteException;

    public void addCountryListener(ICountryListener var1) throws RemoteException;

    public void removeCountryListener(ICountryListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICountryDetector {
        public static final String DESCRIPTOR = "android.location.ICountryDetector";
        static final int TRANSACTION_detectCountry = 1;
        static final int TRANSACTION_addCountryListener = 2;
        static final int TRANSACTION_removeCountryListener = 3;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICountryDetector asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICountryDetector) {
                return (ICountryDetector)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "detectCountry";
                }
                case 2: {
                    return "addCountryListener";
                }
                case 3: {
                    return "removeCountryListener";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    Country _result = this.detectCountry();
                    reply.writeNoException();
                    reply.writeTypedObject(_result, 1);
                    break;
                }
                case 2: {
                    ICountryListener _arg0 = ICountryListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.addCountryListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                case 3: {
                    ICountryListener _arg0 = ICountryListener.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.removeCountryListener(_arg0);
                    reply.writeNoException();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements ICountryDetector {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Country detectCountry() throws RemoteException {
                Country _result;
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                    _result = _reply.readTypedObject(Country.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addCountryListener(ICountryListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCountryListener(ICountryListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(listener);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICountryDetector {
        @Override
        public Country detectCountry() throws RemoteException {
            return null;
        }

        @Override
        public void addCountryListener(ICountryListener listener) throws RemoteException {
        }

        @Override
        public void removeCountryListener(ICountryListener listener) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

