/*
 * Decompiled with CFR 0.152.
 */
package android.location;

import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.AppOpsManager;
import android.app.PendingIntent;
import android.app.PropertyInvalidatedCache;
import android.compat.Compatibility;
import android.content.Context;
import android.location.BatchedLocationCallback;
import android.location.Criteria;
import android.location.Geofence;
import android.location.GnssAntennaInfo;
import android.location.GnssCapabilities;
import android.location.GnssMeasurementCorrections;
import android.location.GnssMeasurementRequest;
import android.location.GnssMeasurementsEvent;
import android.location.GnssNavigationMessage;
import android.location.GnssRequest;
import android.location.GnssStatus;
import android.location.GpsMeasurementsEvent;
import android.location.GpsNavigationMessageEvent;
import android.location.GpsStatus;
import android.location.IGnssAntennaInfoListener;
import android.location.IGnssMeasurementsListener;
import android.location.IGnssNavigationMessageListener;
import android.location.IGnssNmeaListener;
import android.location.IGnssStatusListener;
import android.location.ILocationCallback;
import android.location.ILocationListener;
import android.location.ILocationManager;
import android.location.LastLocationRequest;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationProvider;
import android.location.LocationRequest;
import android.location.OnNmeaMessageListener;
import android.location.provider.IProviderRequestListener;
import android.location.provider.ProviderProperties;
import android.location.provider.ProviderRequest;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.HandlerExecutor;
import android.os.ICancellationSignal;
import android.os.IRemoteCallback;
import android.os.Looper;
import android.os.PackageTagsList;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.listeners.ListenerExecutor;
import com.android.internal.listeners.ListenerTransport;
import com.android.internal.listeners.ListenerTransportManager;
import com.android.internal.util.ConcurrentUtils;
import com.android.internal.util.Preconditions;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class LocationManager {
    public static final long BLOCK_IMMUTABLE_PENDING_INTENTS = 171317480L;
    public static final long BLOCK_PENDING_INTENT_SYSTEM_API_USAGE = 169887240L;
    public static final long DELIVER_HISTORICAL_LOCATIONS = 73144566L;
    public static final long GET_PROVIDER_SECURITY_EXCEPTIONS = 150935354L;
    public static final long BLOCK_UNTARGETED_PENDING_INTENTS = 148963590L;
    public static final long BLOCK_INCOMPLETE_LOCATIONS = 148964793L;
    public static final long BLOCK_GPS_STATUS_USAGE = 144027538L;
    public static final String NETWORK_PROVIDER = "network";
    public static final String GPS_PROVIDER = "gps";
    @SystemApi
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public static final String GPS_HARDWARE_PROVIDER = "gps_hardware";
    public static final String PASSIVE_PROVIDER = "passive";
    public static final String FUSED_PROVIDER = "fused";
    public static final String KEY_PROXIMITY_ENTERING = "entering";
    @Deprecated
    public static final String KEY_STATUS_CHANGED = "status";
    public static final String KEY_PROVIDER_ENABLED = "providerEnabled";
    public static final String KEY_LOCATION_CHANGED = "location";
    public static final String KEY_LOCATIONS = "locations";
    public static final String KEY_FLUSH_COMPLETE = "flushComplete";
    public static final String PROVIDERS_CHANGED_ACTION = "android.location.PROVIDERS_CHANGED";
    public static final String EXTRA_PROVIDER_NAME = "android.location.extra.PROVIDER_NAME";
    public static final String EXTRA_PROVIDER_ENABLED = "android.location.extra.PROVIDER_ENABLED";
    public static final String MODE_CHANGED_ACTION = "android.location.MODE_CHANGED";
    public static final String EXTRA_LOCATION_ENABLED = "android.location.extra.LOCATION_ENABLED";
    @SystemApi
    public static final String ACTION_ADAS_GNSS_ENABLED_CHANGED = "android.location.action.ADAS_GNSS_ENABLED_CHANGED";
    @SystemApi
    public static final String EXTRA_ADAS_GNSS_ENABLED = "android.location.extra.ADAS_GNSS_ENABLED";
    @Deprecated
    public static final String HIGH_POWER_REQUEST_CHANGE_ACTION = "android.location.HIGH_POWER_REQUEST_CHANGE";
    public static final String ACTION_GNSS_CAPABILITIES_CHANGED = "android.location.action.GNSS_CAPABILITIES_CHANGED";
    public static final String EXTRA_GNSS_CAPABILITIES = "android.location.extra.GNSS_CAPABILITIES";
    public static final String SETTINGS_FOOTER_DISPLAYED_ACTION = "com.android.settings.location.DISPLAYED_FOOTER";
    public static final String METADATA_SETTINGS_FOOTER_STRING = "com.android.settings.location.FOOTER_STRING";
    private static final long MAX_SINGLE_LOCATION_TIMEOUT_MS = 30000L;
    private static final String CACHE_KEY_LOCATION_ENABLED_PROPERTY = "cache_key.location_enabled";
    private static volatile LocationEnabledCache sLocationEnabledCache = new LocationEnabledCache(4);
    @GuardedBy(value={"sLocationListeners"})
    private static final WeakHashMap<LocationListener, WeakReference<LocationListenerTransport>> sLocationListeners = new WeakHashMap();
    final Context mContext;
    final ILocationManager mService;

    static ILocationManager getService() throws RemoteException {
        try {
            return ILocationManager.Stub.asInterface(ServiceManager.getServiceOrThrow(KEY_LOCATION_CHANGED));
        }
        catch (ServiceManager.ServiceNotFoundException e) {
            throw new RemoteException((Throwable)e);
        }
    }

    public LocationManager(Context context, ILocationManager service) {
        this.mContext = Objects.requireNonNull(context);
        this.mService = Objects.requireNonNull(service);
    }

    public String[] getBackgroundThrottlingWhitelist() {
        try {
            return this.mService.getBackgroundThrottlingWhitelist();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public String[] getIgnoreSettingsWhitelist() {
        return new String[0];
    }

    public PackageTagsList getIgnoreSettingsAllowlist() {
        try {
            return this.mService.getIgnoreSettingsAllowlist();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public PackageTagsList getAdasAllowlist() {
        try {
            return this.mService.getAdasAllowlist();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public String getExtraLocationControllerPackage() {
        try {
            return this.mService.getExtraLocationControllerPackage();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void setExtraLocationControllerPackage(String packageName) {
        try {
            this.mService.setExtraLocationControllerPackage(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void setExtraLocationControllerPackageEnabled(boolean enabled) {
        try {
            this.mService.setExtraLocationControllerPackageEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean isExtraLocationControllerPackageEnabled() {
        try {
            return this.mService.isExtraLocationControllerPackageEnabled();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void setLocationControllerExtraPackage(String packageName) {
        try {
            this.mService.setExtraLocationControllerPackage(packageName);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @Deprecated
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void setLocationControllerExtraPackageEnabled(boolean enabled) {
        try {
            this.mService.setExtraLocationControllerPackageEnabled(enabled);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isLocationEnabled() {
        return this.isLocationEnabledForUser(this.mContext.getUser());
    }

    @SystemApi
    public boolean isLocationEnabledForUser(UserHandle userHandle) {
        LocationEnabledCache cache;
        if (userHandle.getIdentifier() >= 0 && (cache = sLocationEnabledCache) != null) {
            return (Boolean)cache.query(userHandle.getIdentifier());
        }
        try {
            return this.mService.isLocationEnabledForUser(userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public void setLocationEnabledForUser(boolean enabled, UserHandle userHandle) {
        try {
            this.mService.setLocationEnabledForUser(enabled, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    public boolean isAdasGnssLocationEnabled() {
        try {
            return this.mService.isAdasGnssLocationEnabledForUser(this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi
    @RequiresPermission(value="android.permission.LOCATION_BYPASS")
    public void setAdasGnssLocationEnabled(boolean enabled) {
        try {
            this.mService.setAdasGnssLocationEnabledForUser(enabled, this.mContext.getUser().getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean isProviderEnabled(String provider) {
        return this.isProviderEnabledForUser(provider, Process.myUserHandle());
    }

    @SystemApi
    public boolean isProviderEnabledForUser(String provider, UserHandle userHandle) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        try {
            return this.mService.isProviderEnabledForUser(provider, userHandle.getIdentifier());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.WRITE_SECURE_SETTINGS")
    public boolean setProviderEnabledForUser(String provider, boolean enabled, UserHandle userHandle) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        return false;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.CONTROL_AUTOMOTIVE_GNSS")
    public void setAutomotiveGnssSuspended(boolean suspended) {
        try {
            this.mService.setAutomotiveGnssSuspended(suspended);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(value="android.permission.CONTROL_AUTOMOTIVE_GNSS")
    public boolean isAutomotiveGnssSuspended() {
        try {
            return this.mService.isAutomotiveGnssSuspended();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Location getLastLocation() {
        return this.getLastKnownLocation(FUSED_PROVIDER);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Location getLastKnownLocation(String provider) {
        return this.getLastKnownLocation(provider, new LastLocationRequest.Builder().build());
    }

    @SystemApi
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public Location getLastKnownLocation(String provider, LastLocationRequest lastLocationRequest) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(lastLocationRequest != null, "invalid null last location request");
        try {
            return this.mService.getLastLocation(provider, lastLocationRequest, this.mContext.getPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void getCurrentLocation(String provider, CancellationSignal cancellationSignal, Executor executor, Consumer<Location> consumer) {
        this.getCurrentLocation(provider, new LocationRequest.Builder(0L).build(), cancellationSignal, executor, consumer);
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void getCurrentLocation(LocationRequest locationRequest, CancellationSignal cancellationSignal, Executor executor, Consumer<Location> consumer) {
        Preconditions.checkArgument(locationRequest.getProvider() != null);
        this.getCurrentLocation(locationRequest.getProvider(), locationRequest, cancellationSignal, executor, consumer);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void getCurrentLocation(String provider, LocationRequest locationRequest, CancellationSignal cancellationSignal, Executor executor, Consumer<Location> consumer) {
        ICancellationSignal cancelRemote;
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(locationRequest != null, "invalid null location request");
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
        }
        GetCurrentLocationTransport transport = new GetCurrentLocationTransport(executor, consumer, cancellationSignal);
        try {
            cancelRemote = this.mService.getCurrentLocation(provider, locationRequest, transport, this.mContext.getPackageName(), this.mContext.getAttributionTag(), AppOpsManager.toReceiverId(consumer));
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        if (cancellationSignal != null) {
            cancellationSignal.setRemote(cancelRemote);
        }
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestSingleUpdate(String provider, LocationListener listener, Looper looper) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Handler handler = looper == null ? new Handler() : new Handler(looper);
        this.requestLocationUpdates(provider, new LocationRequest.Builder(0L).setMaxUpdates(1).setDurationMillis(30000L).build(), new HandlerExecutor(handler), listener);
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestSingleUpdate(Criteria criteria, LocationListener listener, Looper looper) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        Handler handler = looper == null ? new Handler() : new Handler(looper);
        this.requestLocationUpdates(FUSED_PROVIDER, new LocationRequest.Builder(0L).setQuality(criteria).setMaxUpdates(1).setDurationMillis(30000L).build(), new HandlerExecutor(handler), listener);
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestSingleUpdate(String provider, PendingIntent pendingIntent) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        this.requestLocationUpdates(provider, new LocationRequest.Builder(0L).setMaxUpdates(1).setDurationMillis(30000L).build(), pendingIntent);
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestSingleUpdate(Criteria criteria, PendingIntent pendingIntent) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        this.requestLocationUpdates(FUSED_PROVIDER, new LocationRequest.Builder(0L).setQuality(criteria).setMaxUpdates(1).setDurationMillis(30000L).build(), pendingIntent);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(String provider, long minTimeMs, float minDistanceM, LocationListener listener) {
        this.requestLocationUpdates(provider, minTimeMs, minDistanceM, listener, null);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(String provider, long minTimeMs, float minDistanceM, LocationListener listener, Looper looper) {
        Handler handler = looper == null ? new Handler() : new Handler(looper);
        this.requestLocationUpdates(provider, minTimeMs, minDistanceM, (Executor)new HandlerExecutor(handler), listener);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(String provider, long minTimeMs, float minDistanceM, Executor executor, LocationListener listener) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        this.requestLocationUpdates(provider, LocationRequest.createFromDeprecatedProvider(provider, minTimeMs, minDistanceM, false), executor, listener);
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(long minTimeMs, float minDistanceM, Criteria criteria, LocationListener listener, Looper looper) {
        Handler handler = looper == null ? new Handler() : new Handler(looper);
        this.requestLocationUpdates(minTimeMs, minDistanceM, criteria, (Executor)new HandlerExecutor(handler), listener);
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(long minTimeMs, float minDistanceM, Criteria criteria, Executor executor, LocationListener listener) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        this.requestLocationUpdates(FUSED_PROVIDER, LocationRequest.createFromDeprecatedCriteria(criteria, minTimeMs, minDistanceM, false), executor, listener);
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(String provider, long minTimeMs, float minDistanceM, PendingIntent pendingIntent) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        this.requestLocationUpdates(provider, LocationRequest.createFromDeprecatedProvider(provider, minTimeMs, minDistanceM, false), pendingIntent);
    }

    @Deprecated
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(long minTimeMs, float minDistanceM, Criteria criteria, PendingIntent pendingIntent) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        this.requestLocationUpdates(FUSED_PROVIDER, LocationRequest.createFromDeprecatedCriteria(criteria, minTimeMs, minDistanceM, false), pendingIntent);
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(LocationRequest locationRequest, LocationListener listener, Looper looper) {
        Handler handler = looper == null ? new Handler() : new Handler(looper);
        this.requestLocationUpdates(locationRequest, new HandlerExecutor(handler), listener);
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(LocationRequest locationRequest, Executor executor, LocationListener listener) {
        if (locationRequest == null) {
            locationRequest = LocationRequest.create();
        }
        Preconditions.checkArgument(locationRequest.getProvider() != null);
        this.requestLocationUpdates(locationRequest.getProvider(), locationRequest, executor, listener);
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(LocationRequest locationRequest, PendingIntent pendingIntent) {
        if (locationRequest == null) {
            locationRequest = LocationRequest.create();
        }
        Preconditions.checkArgument(locationRequest.getProvider() != null);
        this.requestLocationUpdates(locationRequest.getProvider(), locationRequest, pendingIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(String provider, LocationRequest locationRequest, Executor executor, LocationListener listener) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(locationRequest != null, "invalid null location request");
        try {
            WeakHashMap<LocationListener, WeakReference<LocationListenerTransport>> weakHashMap = sLocationListeners;
            synchronized (weakHashMap) {
                LocationListenerTransport transport;
                WeakReference<LocationListenerTransport> reference = sLocationListeners.get(listener);
                LocationListenerTransport locationListenerTransport = transport = reference != null ? (LocationListenerTransport)reference.get() : null;
                if (transport == null) {
                    transport = new LocationListenerTransport(listener, executor);
                } else {
                    Preconditions.checkState(transport.isRegistered());
                    transport.setExecutor(executor);
                }
                this.mService.registerLocationListener(provider, locationRequest, transport, this.mContext.getPackageName(), this.mContext.getAttributionTag(), AppOpsManager.toReceiverId(listener));
                sLocationListeners.put(listener, new WeakReference<LocationListenerTransport>(transport));
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void requestLocationUpdates(String provider, LocationRequest locationRequest, PendingIntent pendingIntent) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(locationRequest != null, "invalid null location request");
        Preconditions.checkArgument(pendingIntent != null, "invalid null pending intent");
        if (Compatibility.isChangeEnabled(148963590L)) {
            Preconditions.checkArgument(pendingIntent.isTargetedToPackage(), "pending intent must be targeted to a package");
        }
        if (Compatibility.isChangeEnabled(171317480L)) {
            Preconditions.checkArgument(!pendingIntent.isImmutable(), "pending intent must be mutable");
        }
        try {
            this.mService.registerLocationPendingIntent(provider, locationRequest, pendingIntent, this.mContext.getPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    @RequiresPermission(allOf={"android.permission.LOCATION_HARDWARE", "android.permission.ACCESS_FINE_LOCATION"})
    public boolean injectLocation(Location location) {
        Preconditions.checkArgument(location != null, "invalid null location");
        Preconditions.checkArgument(location.isComplete(), "incomplete location object, missing timestamp or accuracy?");
        try {
            this.mService.injectLocation(location);
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"SamShouldBeLast"})
    public void requestFlush(String provider, LocationListener listener, @SuppressLint(value={"ListenerLast"}) int requestCode) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(listener != null, "invalid null listener");
        WeakHashMap<LocationListener, WeakReference<LocationListenerTransport>> weakHashMap = sLocationListeners;
        synchronized (weakHashMap) {
            WeakReference<LocationListenerTransport> ref = sLocationListeners.get(listener);
            LocationListenerTransport transport = ref != null ? (LocationListenerTransport)ref.get() : null;
            Preconditions.checkArgument(transport != null, "unregistered listener cannot be flushed");
            try {
                this.mService.requestListenerFlush(provider, transport, requestCode);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    public void requestFlush(String provider, PendingIntent pendingIntent, int requestCode) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(pendingIntent != null, "invalid null pending intent");
        try {
            this.mService.requestPendingIntentFlush(provider, pendingIntent, requestCode);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdates(LocationListener listener) {
        Preconditions.checkArgument(listener != null, "invalid null listener");
        try {
            WeakHashMap<LocationListener, WeakReference<LocationListenerTransport>> weakHashMap = sLocationListeners;
            synchronized (weakHashMap) {
                LocationListenerTransport transport;
                WeakReference<LocationListenerTransport> ref = sLocationListeners.remove(listener);
                LocationListenerTransport locationListenerTransport = transport = ref != null ? (LocationListenerTransport)ref.get() : null;
                if (transport != null) {
                    transport.unregister();
                    this.mService.unregisterLocationListener(transport);
                }
            }
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeUpdates(PendingIntent pendingIntent) {
        Preconditions.checkArgument(pendingIntent != null, "invalid null pending intent");
        try {
            this.mService.unregisterLocationPendingIntent(pendingIntent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean hasProvider(String provider) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        try {
            return this.mService.hasProvider(provider);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<String> getAllProviders() {
        try {
            return this.mService.getAllProviders();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public List<String> getProviders(boolean enabledOnly) {
        try {
            return this.mService.getProviders(null, enabledOnly);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public List<String> getProviders(Criteria criteria, boolean enabledOnly) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        try {
            return this.mService.getProviders(criteria, enabledOnly);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public String getBestProvider(Criteria criteria, boolean enabledOnly) {
        Preconditions.checkArgument(criteria != null, "invalid null criteria");
        try {
            return this.mService.getBestProvider(criteria, enabledOnly);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public LocationProvider getProvider(String provider) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        if (!Compatibility.isChangeEnabled(150935354L)) {
            if (NETWORK_PROVIDER.equals(provider) || FUSED_PROVIDER.equals(provider)) {
                try {
                    this.mContext.enforcePermission("android.permission.ACCESS_FINE_LOCATION", Process.myPid(), Process.myUid(), null);
                }
                catch (SecurityException e) {
                    this.mContext.enforcePermission("android.permission.ACCESS_COARSE_LOCATION", Process.myPid(), Process.myUid(), null);
                }
            } else {
                this.mContext.enforcePermission("android.permission.ACCESS_FINE_LOCATION", Process.myPid(), Process.myUid(), null);
            }
        }
        try {
            ProviderProperties properties = this.mService.getProviderProperties(provider);
            return new LocationProvider(provider, properties);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public ProviderProperties getProviderProperties(String provider) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        try {
            return this.mService.getProviderProperties(provider);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public boolean isProviderPackage(String packageName) {
        return this.isProviderPackage(null, packageName, null);
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public boolean isProviderPackage(String provider, String packageName) {
        return this.isProviderPackage(provider, packageName, null);
    }

    @SystemApi
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public boolean isProviderPackage(String provider, String packageName, String attributionTag) {
        try {
            return this.mService.isProviderPackage(provider, Objects.requireNonNull(packageName), attributionTag);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.READ_DEVICE_CONFIG")
    public List<String> getProviderPackages(String provider) {
        try {
            return this.mService.getProviderPackages(provider);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public boolean sendExtraCommand(String provider, String command, Bundle extras) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(command != null, "invalid null command");
        try {
            this.mService.sendExtraCommand(provider, command, extras);
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void addTestProvider(String provider, boolean requiresNetwork, boolean requiresSatellite, boolean requiresCell, boolean hasMonetaryCost, boolean supportsAltitude, boolean supportsSpeed, boolean supportsBearing, int powerUsage, int accuracy) {
        this.addTestProvider(provider, new ProviderProperties.Builder().setHasNetworkRequirement(requiresNetwork).setHasSatelliteRequirement(requiresSatellite).setHasCellRequirement(requiresCell).setHasMonetaryCost(hasMonetaryCost).setHasAltitudeSupport(supportsAltitude).setHasSpeedSupport(supportsSpeed).setHasBearingSupport(supportsBearing).setPowerUsage(powerUsage).setAccuracy(accuracy).build());
    }

    public void addTestProvider(String provider, ProviderProperties properties) {
        this.addTestProvider(provider, properties, Collections.emptySet());
    }

    public void addTestProvider(String provider, ProviderProperties properties, Set<String> extraAttributionTags) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(properties != null, "invalid null properties");
        Preconditions.checkArgument(extraAttributionTags != null, "invalid null extra attribution tags");
        try {
            this.mService.addTestProvider(provider, properties, new ArrayList<String>(extraAttributionTags), this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeTestProvider(String provider) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        try {
            this.mService.removeTestProvider(provider, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void setTestProviderLocation(String provider, Location location) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        Preconditions.checkArgument(location != null, "invalid null location");
        if (Compatibility.isChangeEnabled(148964793L)) {
            Preconditions.checkArgument(location.isComplete(), "incomplete location object, missing timestamp or accuracy?");
        } else {
            location.makeComplete();
        }
        try {
            this.mService.setTestProviderLocation(provider, location, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void clearTestProviderLocation(String provider) {
    }

    public void setTestProviderEnabled(String provider, boolean enabled) {
        Preconditions.checkArgument(provider != null, "invalid null provider");
        try {
            this.mService.setTestProviderEnabled(provider, enabled, this.mContext.getOpPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    public void clearTestProviderEnabled(String provider) {
        this.setTestProviderEnabled(provider, false);
    }

    @Deprecated
    public void setTestProviderStatus(String provider, int status, Bundle extras, long updateTime) {
    }

    @Deprecated
    public void clearTestProviderStatus(String provider) {
    }

    @RequiresPermission(anyOf={"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"})
    public void addProximityAlert(double latitude, double longitude, float radius, long expiration, PendingIntent pendingIntent) {
        Preconditions.checkArgument(pendingIntent != null, "invalid null pending intent");
        if (Compatibility.isChangeEnabled(148963590L)) {
            Preconditions.checkArgument(pendingIntent.isTargetedToPackage(), "pending intent must be targeted to a package");
        }
        if (Compatibility.isChangeEnabled(171317480L)) {
            Preconditions.checkArgument(!pendingIntent.isImmutable(), "pending intent must be mutable");
        }
        if (expiration < 0L) {
            expiration = Long.MAX_VALUE;
        }
        try {
            Geofence fence = Geofence.createCircle(latitude, longitude, radius, expiration);
            this.mService.requestGeofence(fence, pendingIntent, this.mContext.getPackageName(), this.mContext.getAttributionTag());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void removeProximityAlert(PendingIntent intent) {
        Preconditions.checkArgument(intent != null, "invalid null pending intent");
        try {
            this.mService.removeGeofence(intent);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public GnssCapabilities getGnssCapabilities() {
        try {
            return this.mService.getGnssCapabilities();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public int getGnssYearOfHardware() {
        try {
            return this.mService.getGnssYearOfHardware();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public String getGnssHardwareModelName() {
        try {
            return this.mService.getGnssHardwareModelName();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @SuppressLint(value={"NullableCollection"})
    public List<GnssAntennaInfo> getGnssAntennaInfos() {
        try {
            return this.mService.getGnssAntennaInfos();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public GpsStatus getGpsStatus(GpsStatus status) {
        if (Compatibility.isChangeEnabled(144027538L)) {
            throw new UnsupportedOperationException("GpsStatus APIs not supported, please use GnssStatus APIs instead");
        }
        GnssStatus gnssStatus = GpsStatusTransport.sGnssStatus;
        int ttff = GpsStatusTransport.sTtff;
        if (gnssStatus != null) {
            if (status == null) {
                status = GpsStatus.create(gnssStatus, ttff);
            } else {
                status.setStatus(gnssStatus, ttff);
            }
        } else if (status == null) {
            status = GpsStatus.createEmpty();
        }
        return status;
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean addGpsStatusListener(GpsStatus.Listener listener) {
        if (Compatibility.isChangeEnabled(144027538L)) {
            throw new UnsupportedOperationException("GpsStatus APIs not supported, please use GnssStatus APIs instead");
        }
        GnssLazyLoader.sGnssStatusListeners.addListener(listener, new GpsStatusTransport((Executor)new HandlerExecutor(new Handler()), this.mContext, listener));
        return true;
    }

    @Deprecated
    public void removeGpsStatusListener(GpsStatus.Listener listener) {
        if (Compatibility.isChangeEnabled(144027538L)) {
            throw new UnsupportedOperationException("GpsStatus APIs not supported, please use GnssStatus APIs instead");
        }
        GnssLazyLoader.sGnssStatusListeners.removeListener(listener);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean registerGnssStatusCallback(GnssStatus.Callback callback) {
        return this.registerGnssStatusCallback(callback, null);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean registerGnssStatusCallback(GnssStatus.Callback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        return this.registerGnssStatusCallback(new HandlerExecutor(handler), callback);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean registerGnssStatusCallback(Executor executor, GnssStatus.Callback callback) {
        GnssLazyLoader.sGnssStatusListeners.addListener(callback, new GnssStatusTransport(executor, this.mContext, callback));
        return true;
    }

    public void unregisterGnssStatusCallback(GnssStatus.Callback callback) {
        GnssLazyLoader.sGnssStatusListeners.removeListener(callback);
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean addNmeaListener(GpsStatus.NmeaListener listener) {
        return false;
    }

    @Deprecated
    public void removeNmeaListener(GpsStatus.NmeaListener listener) {
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean addNmeaListener(OnNmeaMessageListener listener) {
        return this.addNmeaListener(listener, null);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean addNmeaListener(OnNmeaMessageListener listener, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        return this.addNmeaListener(new HandlerExecutor(handler), listener);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean addNmeaListener(Executor executor, OnNmeaMessageListener listener) {
        GnssLazyLoader.sGnssNmeaListeners.addListener(listener, new GnssNmeaTransport(executor, this.mContext, listener));
        return true;
    }

    public void removeNmeaListener(OnNmeaMessageListener listener) {
        GnssLazyLoader.sGnssNmeaListeners.removeListener(listener);
    }

    @Deprecated
    @SystemApi
    public boolean addGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
        return false;
    }

    @Deprecated
    @SystemApi
    public void removeGpsMeasurementListener(GpsMeasurementsEvent.Listener listener) {
    }

    @Deprecated
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean registerGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback) {
        return this.registerGnssMeasurementsCallback(ConcurrentUtils.DIRECT_EXECUTOR, callback);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean registerGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        return this.registerGnssMeasurementsCallback(new GnssMeasurementRequest.Builder().build(), (Executor)new HandlerExecutor(handler), callback);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean registerGnssMeasurementsCallback(Executor executor, GnssMeasurementsEvent.Callback callback) {
        return this.registerGnssMeasurementsCallback(new GnssMeasurementRequest.Builder().build(), executor, callback);
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean registerGnssMeasurementsCallback(GnssRequest request, Executor executor, GnssMeasurementsEvent.Callback callback) {
        return this.registerGnssMeasurementsCallback(request.toGnssMeasurementRequest(), executor, callback);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean registerGnssMeasurementsCallback(GnssMeasurementRequest request, Executor executor, GnssMeasurementsEvent.Callback callback) {
        GnssLazyLoader.sGnssMeasurementsListeners.addListener(callback, new GnssMeasurementsTransport(executor, this.mContext, request, callback));
        return true;
    }

    @SystemApi
    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public void injectGnssMeasurementCorrections(GnssMeasurementCorrections measurementCorrections) {
        Preconditions.checkArgument(measurementCorrections != null);
        try {
            this.mService.injectGnssMeasurementCorrections(measurementCorrections);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void unregisterGnssMeasurementsCallback(GnssMeasurementsEvent.Callback callback) {
        GnssLazyLoader.sGnssMeasurementsListeners.removeListener(callback);
    }

    public boolean registerAntennaInfoListener(Executor executor, GnssAntennaInfo.Listener listener) {
        GnssLazyLoader.sGnssAntennaInfoListeners.addListener(listener, new GnssAntennaInfoTransport(executor, this.mContext, listener));
        return true;
    }

    public void unregisterAntennaInfoListener(GnssAntennaInfo.Listener listener) {
        GnssLazyLoader.sGnssAntennaInfoListeners.removeListener(listener);
    }

    @Deprecated
    @SystemApi
    public boolean addGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
        return false;
    }

    @Deprecated
    @SystemApi
    public void removeGpsNavigationMessageListener(GpsNavigationMessageEvent.Listener listener) {
    }

    @Deprecated
    public boolean registerGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback) {
        return this.registerGnssNavigationMessageCallback(ConcurrentUtils.DIRECT_EXECUTOR, callback);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean registerGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        return this.registerGnssNavigationMessageCallback(new HandlerExecutor(handler), callback);
    }

    @RequiresPermission(value="android.permission.ACCESS_FINE_LOCATION")
    public boolean registerGnssNavigationMessageCallback(Executor executor, GnssNavigationMessage.Callback callback) {
        GnssLazyLoader.sGnssNavigationListeners.addListener(callback, new GnssNavigationTransport(executor, this.mContext, callback));
        return true;
    }

    public void unregisterGnssNavigationMessageCallback(GnssNavigationMessage.Callback callback) {
        GnssLazyLoader.sGnssNavigationListeners.removeListener(callback);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.LOCATION_HARDWARE", "android.permission.INTERACT_ACROSS_USERS"})
    public void addProviderRequestChangedListener(Executor executor, ProviderRequest.ChangedListener listener) {
        ProviderRequestLazyLoader.sProviderRequestListeners.addListener(listener, new ProviderRequestTransport(executor, listener));
    }

    @SystemApi
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void removeProviderRequestChangedListener(ProviderRequest.ChangedListener listener) {
        ProviderRequestLazyLoader.sProviderRequestListeners.removeListener(listener);
    }

    @Deprecated
    @SystemApi
    public int getGnssBatchSize() {
        try {
            return this.mService.getGnssBatchSize();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(allOf={"android.permission.LOCATION_HARDWARE", "android.permission.UPDATE_APP_OPS_STATS"})
    public boolean registerGnssBatchedLocationCallback(long periodNanos, boolean wakeOnFifoFull, BatchedLocationCallback callback, Handler handler) {
        if (handler == null) {
            handler = new Handler();
        }
        try {
            this.mService.startGnssBatch(periodNanos, new BatchedLocationCallbackTransport(callback, handler), this.mContext.getPackageName(), this.mContext.getAttributionTag(), AppOpsManager.toReceiverId(callback));
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public void flushGnssBatch() {
        try {
            this.mService.flushGnssBatch();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Deprecated
    @SystemApi
    @RequiresPermission(value="android.permission.LOCATION_HARDWARE")
    public boolean unregisterGnssBatchedLocationCallback(BatchedLocationCallback callback) {
        try {
            this.mService.stopGnssBatch();
            return true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static void invalidateLocalLocationEnabledCaches() {
        PropertyInvalidatedCache.invalidateCache(CACHE_KEY_LOCATION_ENABLED_PROPERTY);
    }

    public static void disableLocalLocationEnabledCaches() {
        sLocationEnabledCache = null;
    }

    private static class LocationEnabledCache
    extends PropertyInvalidatedCache<Integer, Boolean> {
        private ILocationManager mManager;

        LocationEnabledCache(int numEntries) {
            super(numEntries, LocationManager.CACHE_KEY_LOCATION_ENABLED_PROPERTY);
        }

        @Override
        public Boolean recompute(Integer userId) {
            Preconditions.checkArgument(userId >= 0);
            if (this.mManager == null) {
                try {
                    this.mManager = LocationManager.getService();
                }
                catch (RemoteException e) {
                    e.rethrowFromSystemServer();
                }
            }
            try {
                return this.mManager.isLocationEnabledForUser(userId);
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }

    private static class GetCurrentLocationTransport
    extends ILocationCallback.Stub
    implements ListenerExecutor,
    CancellationSignal.OnCancelListener {
        private final Executor mExecutor;
        volatile Consumer<Location> mConsumer;

        GetCurrentLocationTransport(Executor executor, Consumer<Location> consumer, CancellationSignal cancellationSignal) {
            Preconditions.checkArgument(executor != null, "illegal null executor");
            Preconditions.checkArgument(consumer != null, "illegal null consumer");
            this.mExecutor = executor;
            this.mConsumer = consumer;
            if (cancellationSignal != null) {
                cancellationSignal.setOnCancelListener(this);
            }
        }

        @Override
        public void onCancel() {
            this.mConsumer = null;
        }

        @Override
        public void onLocation(final Location location) {
            this.executeSafely(this.mExecutor, () -> this.mConsumer, new ListenerExecutor.ListenerOperation<Consumer<Location>>(){

                @Override
                public void operate(Consumer<Location> consumer) {
                    consumer.accept(location);
                }

                @Override
                public void onPostExecute(boolean success) {
                    mConsumer = null;
                }
            });
        }
    }

    private static class LocationListenerTransport
    extends ILocationListener.Stub
    implements ListenerExecutor {
        private Executor mExecutor;
        private volatile LocationListener mListener;

        LocationListenerTransport(LocationListener listener, Executor executor) {
            Preconditions.checkArgument(listener != null, "invalid null listener");
            this.mListener = listener;
            this.setExecutor(executor);
        }

        void setExecutor(Executor executor) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            this.mExecutor = executor;
        }

        boolean isRegistered() {
            return this.mListener != null;
        }

        void unregister() {
            this.mListener = null;
        }

        @Override
        public void onLocationChanged(final List<Location> locations, final IRemoteCallback onCompleteCallback) {
            this.executeSafely(this.mExecutor, () -> this.mListener, new ListenerExecutor.ListenerOperation<LocationListener>(){

                @Override
                public void operate(LocationListener listener) {
                    listener.onLocationChanged(locations);
                }

                @Override
                public void onComplete(boolean success) {
                    if (onCompleteCallback != null) {
                        try {
                            onCompleteCallback.sendResult(null);
                        }
                        catch (RemoteException e) {
                            throw e.rethrowFromSystemServer();
                        }
                    }
                }
            });
        }

        @Override
        public void onFlushComplete(int requestCode) {
            this.executeSafely(this.mExecutor, () -> this.mListener, listener -> listener.onFlushComplete(requestCode));
        }

        @Override
        public void onProviderEnabledChanged(String provider, boolean enabled) {
            this.executeSafely(this.mExecutor, () -> this.mListener, listener -> {
                if (enabled) {
                    listener.onProviderEnabled(provider);
                } else {
                    listener.onProviderDisabled(provider);
                }
            });
        }
    }

    @Deprecated
    private static class GpsStatusTransport
    extends GnssStatusTransport {
        static volatile int sTtff;
        static volatile GnssStatus sGnssStatus;

        GpsStatusTransport(Executor executor, Context context, GpsStatus.Listener listener) {
            super(executor, context, new GpsAdapter(listener));
        }

        @Override
        public void onFirstFix(int ttff) {
            sTtff = ttff;
            super.onFirstFix(ttff);
        }

        @Override
        public void onSvStatusChanged(GnssStatus gnssStatus) {
            sGnssStatus = gnssStatus;
            super.onSvStatusChanged(gnssStatus);
        }
    }

    private static class GnssLazyLoader {
        static final GnssStatusTransportManager sGnssStatusListeners = new GnssStatusTransportManager();
        static final GnssNmeaTransportManager sGnssNmeaListeners = new GnssNmeaTransportManager();
        static final GnssMeasurementsTransportManager sGnssMeasurementsListeners = new GnssMeasurementsTransportManager();
        static final GnssAntennaTransportManager sGnssAntennaInfoListeners = new GnssAntennaTransportManager();
        static final GnssNavigationTransportManager sGnssNavigationListeners = new GnssNavigationTransportManager();

        private GnssLazyLoader() {
        }
    }

    private static class GnssStatusTransportManager
    extends ListenerTransportManager<GnssStatusTransport> {
        GnssStatusTransportManager() {
            super(false);
        }

        @Override
        protected void registerTransport(GnssStatusTransport transport) throws RemoteException {
            LocationManager.getService().registerGnssStatusCallback(transport, transport.getPackage(), transport.getAttributionTag(), AppOpsManager.toReceiverId(transport.getListener()));
        }

        @Override
        protected void unregisterTransport(GnssStatusTransport transport) throws RemoteException {
            LocationManager.getService().unregisterGnssStatusCallback(transport);
        }
    }

    private static class GnssStatusTransport
    extends IGnssStatusListener.Stub
    implements ListenerTransport<GnssStatus.Callback> {
        private final Executor mExecutor;
        private final String mPackageName;
        private final String mAttributionTag;
        private volatile GnssStatus.Callback mListener;

        GnssStatusTransport(Executor executor, Context context, GnssStatus.Callback listener) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            Preconditions.checkArgument(listener != null, "invalid null callback");
            this.mExecutor = executor;
            this.mPackageName = context.getPackageName();
            this.mAttributionTag = context.getAttributionTag();
            this.mListener = listener;
        }

        public String getPackage() {
            return this.mPackageName;
        }

        public String getAttributionTag() {
            return this.mAttributionTag;
        }

        @Override
        public void unregister() {
            this.mListener = null;
        }

        @Override
        public GnssStatus.Callback getListener() {
            return this.mListener;
        }

        @Override
        public void onGnssStarted() {
            this.execute(this.mExecutor, GnssStatus.Callback::onStarted);
        }

        @Override
        public void onGnssStopped() {
            this.execute(this.mExecutor, GnssStatus.Callback::onStopped);
        }

        @Override
        public void onFirstFix(int ttff) {
            this.execute(this.mExecutor, listener -> listener.onFirstFix(ttff));
        }

        @Override
        public void onSvStatusChanged(GnssStatus gnssStatus) {
            this.execute(this.mExecutor, listener -> listener.onSatelliteStatusChanged(gnssStatus));
        }
    }

    private static class GnssNmeaTransportManager
    extends ListenerTransportManager<GnssNmeaTransport> {
        GnssNmeaTransportManager() {
            super(false);
        }

        @Override
        protected void registerTransport(GnssNmeaTransport transport) throws RemoteException {
            LocationManager.getService().registerGnssNmeaCallback(transport, transport.getPackage(), transport.getAttributionTag(), AppOpsManager.toReceiverId(transport.getListener()));
        }

        @Override
        protected void unregisterTransport(GnssNmeaTransport transport) throws RemoteException {
            LocationManager.getService().unregisterGnssNmeaCallback(transport);
        }
    }

    private static class GnssNmeaTransport
    extends IGnssNmeaListener.Stub
    implements ListenerTransport<OnNmeaMessageListener> {
        private final Executor mExecutor;
        private final String mPackageName;
        private final String mAttributionTag;
        private volatile OnNmeaMessageListener mListener;

        GnssNmeaTransport(Executor executor, Context context, OnNmeaMessageListener listener) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            Preconditions.checkArgument(listener != null, "invalid null listener");
            this.mExecutor = executor;
            this.mPackageName = context.getPackageName();
            this.mAttributionTag = context.getAttributionTag();
            this.mListener = listener;
        }

        public String getPackage() {
            return this.mPackageName;
        }

        public String getAttributionTag() {
            return this.mAttributionTag;
        }

        @Override
        public void unregister() {
            this.mListener = null;
        }

        @Override
        public OnNmeaMessageListener getListener() {
            return this.mListener;
        }

        @Override
        public void onNmeaReceived(long timestamp, String nmea) {
            this.execute(this.mExecutor, callback -> callback.onNmeaMessage(nmea, timestamp));
        }
    }

    private static class GnssMeasurementsTransportManager
    extends ListenerTransportManager<GnssMeasurementsTransport> {
        GnssMeasurementsTransportManager() {
            super(false);
        }

        @Override
        protected void registerTransport(GnssMeasurementsTransport transport) throws RemoteException {
            LocationManager.getService().addGnssMeasurementsListener(transport.getRequest(), transport, transport.getPackage(), transport.getAttributionTag(), AppOpsManager.toReceiverId(transport.getListener()));
        }

        @Override
        protected void unregisterTransport(GnssMeasurementsTransport transport) throws RemoteException {
            LocationManager.getService().removeGnssMeasurementsListener(transport);
        }
    }

    private static class GnssMeasurementsTransport
    extends IGnssMeasurementsListener.Stub
    implements ListenerTransport<GnssMeasurementsEvent.Callback> {
        private final Executor mExecutor;
        private final String mPackageName;
        private final String mAttributionTag;
        private final GnssMeasurementRequest mRequest;
        private volatile GnssMeasurementsEvent.Callback mListener;

        GnssMeasurementsTransport(Executor executor, Context context, GnssMeasurementRequest request, GnssMeasurementsEvent.Callback listener) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            Preconditions.checkArgument(listener != null, "invalid null callback");
            Preconditions.checkArgument(request != null, "invalid null request");
            this.mExecutor = executor;
            this.mPackageName = context.getPackageName();
            this.mAttributionTag = context.getAttributionTag();
            this.mRequest = request;
            this.mListener = listener;
        }

        public String getPackage() {
            return this.mPackageName;
        }

        public String getAttributionTag() {
            return this.mAttributionTag;
        }

        public GnssMeasurementRequest getRequest() {
            return this.mRequest;
        }

        @Override
        public void unregister() {
            this.mListener = null;
        }

        @Override
        public GnssMeasurementsEvent.Callback getListener() {
            return this.mListener;
        }

        @Override
        public void onGnssMeasurementsReceived(GnssMeasurementsEvent event) {
            this.execute(this.mExecutor, callback -> callback.onGnssMeasurementsReceived(event));
        }

        @Override
        public void onStatusChanged(int status) {
            this.execute(this.mExecutor, callback -> callback.onStatusChanged(status));
        }
    }

    private static class GnssAntennaTransportManager
    extends ListenerTransportManager<GnssAntennaInfoTransport> {
        GnssAntennaTransportManager() {
            super(false);
        }

        @Override
        protected void registerTransport(GnssAntennaInfoTransport transport) throws RemoteException {
            LocationManager.getService().addGnssAntennaInfoListener(transport, transport.getPackage(), transport.getAttributionTag(), AppOpsManager.toReceiverId(transport.getListener()));
        }

        @Override
        protected void unregisterTransport(GnssAntennaInfoTransport transport) throws RemoteException {
            LocationManager.getService().removeGnssAntennaInfoListener(transport);
        }
    }

    private static class GnssAntennaInfoTransport
    extends IGnssAntennaInfoListener.Stub
    implements ListenerTransport<GnssAntennaInfo.Listener> {
        private final Executor mExecutor;
        private final String mPackageName;
        private final String mAttributionTag;
        private volatile GnssAntennaInfo.Listener mListener;

        GnssAntennaInfoTransport(Executor executor, Context context, GnssAntennaInfo.Listener listener) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            Preconditions.checkArgument(listener != null, "invalid null listener");
            this.mExecutor = executor;
            this.mPackageName = context.getPackageName();
            this.mAttributionTag = context.getAttributionTag();
            this.mListener = listener;
        }

        public String getPackage() {
            return this.mPackageName;
        }

        public String getAttributionTag() {
            return this.mAttributionTag;
        }

        @Override
        public void unregister() {
            this.mListener = null;
        }

        @Override
        public GnssAntennaInfo.Listener getListener() {
            return this.mListener;
        }

        @Override
        public void onGnssAntennaInfoChanged(List<GnssAntennaInfo> antennaInfos) {
            this.execute(this.mExecutor, callback -> callback.onGnssAntennaInfoReceived(antennaInfos));
        }
    }

    private static class GnssNavigationTransportManager
    extends ListenerTransportManager<GnssNavigationTransport> {
        GnssNavigationTransportManager() {
            super(false);
        }

        @Override
        protected void registerTransport(GnssNavigationTransport transport) throws RemoteException {
            LocationManager.getService().addGnssNavigationMessageListener(transport, transport.getPackage(), transport.getAttributionTag(), AppOpsManager.toReceiverId(transport.getListener()));
        }

        @Override
        protected void unregisterTransport(GnssNavigationTransport transport) throws RemoteException {
            LocationManager.getService().removeGnssNavigationMessageListener(transport);
        }
    }

    private static class GnssNavigationTransport
    extends IGnssNavigationMessageListener.Stub
    implements ListenerTransport<GnssNavigationMessage.Callback> {
        private final Executor mExecutor;
        private final String mPackageName;
        private final String mAttributionTag;
        private volatile GnssNavigationMessage.Callback mListener;

        GnssNavigationTransport(Executor executor, Context context, GnssNavigationMessage.Callback listener) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            Preconditions.checkArgument(listener != null, "invalid null callback");
            this.mExecutor = executor;
            this.mPackageName = context.getPackageName();
            this.mAttributionTag = context.getAttributionTag();
            this.mListener = listener;
        }

        public String getPackage() {
            return this.mPackageName;
        }

        public String getAttributionTag() {
            return this.mAttributionTag;
        }

        @Override
        public void unregister() {
            this.mListener = null;
        }

        @Override
        public GnssNavigationMessage.Callback getListener() {
            return this.mListener;
        }

        @Override
        public void onGnssNavigationMessageReceived(GnssNavigationMessage event) {
            this.execute(this.mExecutor, listener -> listener.onGnssNavigationMessageReceived(event));
        }

        @Override
        public void onStatusChanged(int status) {
            this.execute(this.mExecutor, listener -> listener.onStatusChanged(status));
        }
    }

    private static class ProviderRequestLazyLoader {
        static final ProviderRequestTransportManager sProviderRequestListeners = new ProviderRequestTransportManager();

        private ProviderRequestLazyLoader() {
        }
    }

    private static class ProviderRequestTransportManager
    extends ListenerTransportManager<ProviderRequestTransport> {
        ProviderRequestTransportManager() {
            super(false);
        }

        @Override
        protected void registerTransport(ProviderRequestTransport transport) throws RemoteException {
            LocationManager.getService().addProviderRequestListener(transport);
        }

        @Override
        protected void unregisterTransport(ProviderRequestTransport transport) throws RemoteException {
            LocationManager.getService().removeProviderRequestListener(transport);
        }
    }

    private static class ProviderRequestTransport
    extends IProviderRequestListener.Stub
    implements ListenerTransport<ProviderRequest.ChangedListener> {
        private final Executor mExecutor;
        private volatile ProviderRequest.ChangedListener mListener;

        ProviderRequestTransport(Executor executor, ProviderRequest.ChangedListener listener) {
            Preconditions.checkArgument(executor != null, "invalid null executor");
            Preconditions.checkArgument(listener != null, "invalid null callback");
            this.mExecutor = executor;
            this.mListener = listener;
        }

        @Override
        public void unregister() {
            this.mListener = null;
        }

        @Override
        public ProviderRequest.ChangedListener getListener() {
            return this.mListener;
        }

        @Override
        public void onProviderRequestChanged(String provider, ProviderRequest request) {
            this.execute(this.mExecutor, listener -> listener.onProviderRequestChanged(provider, request));
        }
    }

    @Deprecated
    private static class BatchedLocationCallbackTransport
    extends LocationListenerTransport {
        BatchedLocationCallbackTransport(BatchedLocationCallback callback, Handler handler) {
            super(new BatchedLocationCallbackWrapper(callback), new HandlerExecutor(handler));
        }
    }

    @Deprecated
    private static class BatchedLocationCallbackWrapper
    implements LocationListener {
        private final BatchedLocationCallback mCallback;

        BatchedLocationCallbackWrapper(BatchedLocationCallback callback) {
            this.mCallback = callback;
        }

        @Override
        public void onLocationChanged(Location location) {
            this.mCallback.onLocationBatch(Collections.singletonList(location));
        }

        @Override
        public void onLocationChanged(List<Location> locations) {
            this.mCallback.onLocationBatch(locations);
        }
    }

    @Deprecated
    private static class GpsAdapter
    extends GnssStatus.Callback {
        private final GpsStatus.Listener mGpsListener;

        GpsAdapter(GpsStatus.Listener gpsListener) {
            this.mGpsListener = gpsListener;
        }

        @Override
        public void onStarted() {
            this.mGpsListener.onGpsStatusChanged(1);
        }

        @Override
        public void onStopped() {
            this.mGpsListener.onGpsStatusChanged(2);
        }

        @Override
        public void onFirstFix(int ttffMillis) {
            this.mGpsListener.onGpsStatusChanged(3);
        }

        @Override
        public void onSatelliteStatusChanged(GnssStatus status) {
            this.mGpsListener.onGpsStatusChanged(4);
        }
    }
}

